/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPrefsCopier {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPreferences prefs_;
    private final PanPlotMeta pmeta_;
    protected final PanPlotType plotType_;

    public PanPrefsCopier(PanPlotMeta pmeta) {
        this.pmeta_ = pmeta;
        this.plotType_ = this.pmeta_.getType();
        this.prefs_ = PanPreferences.getSharedInstance();
    }

    public void copySettingsToPrefs() {
        this.setPref("plot:size.factor", "size.factor");
        this.setPref("plot:color.background", "color.background");
        this.setPref("plot:font.master", "font.master");
        this.setPref("plot:scale.tick.format", "scale.tick.format");
        this.setPref("plot:scale.div.major", "scale.div.major");
        this.setPref("plot:scale.div.minor", "scale.div.minor");
        this.setPref("plot:scale.method", "scale.method");
        this.setPref("plot:scale.minmax.note", "scale.minmax.note");
        this.setPref("plot:scale.minmax.format", "scale.minmax.format");
        if (this.plotType_.isLinePlot()) {
            this.setPref("plot:1d.axes.offset", "axes.offset");
            this.setPref("plot:1d.axes.tickmark.weight", "axes.tickmark.weight");
            this.setPref("plot:1d.axes.tickmark.color", "axes.tickmark.color");
            this.setPref("plot:1d.grid.weight", "grid.weight");
            this.setPref("plot:1d.grid.style", "grid.style");
            for (int i = 0; i < 2; ++i) {
                this.setPref(PanParameterKeys.P_LINE_STROKE_COLOR[i], PanParameterKeys.STROKE_COLOR[i]);
                this.setPref(PanParameterKeys.P_LINE_STROKE_STYLE[i], PanParameterKeys.STROKE_STYLE[i]);
                this.setPref(PanParameterKeys.P_LINE_STROKE_WEIGHT[i], PanParameterKeys.STROKE_WEIGHT[i]);
            }
            if (this.plotType_ == PanPlotType.HORZ_LINE) {
                this.setPref("plot:1d.xaxis.tick.size", "xaxis.tick.size");
                this.setPref("plot:1d.yaxis.tick.size", "scale.tick.size");
            } else {
                this.setPref("plot:1d.xaxis.tick.size", "scale.tick.size");
                this.setPref("plot:1d.yaxis.tick.size", "yaxis.tick.size");
            }
        } else if (this.pmeta_.isLonLatZonal()) {
            this.setPref("plot:interpolate", "interpolate");
            this.setPref("plot:scale.autofit", "scale.autofit");
            this.setPref(PanParameterKeys.P_LINE_STROKE_COLOR[0], PanParameterKeys.STROKE_COLOR[0]);
            this.setPref(PanParameterKeys.P_LINE_STROKE_STYLE[0], PanParameterKeys.STROKE_STYLE[0]);
            this.setPref(PanParameterKeys.P_LINE_STROKE_WEIGHT[0], PanParameterKeys.STROKE_WEIGHT[0]);
            this.setPref("plot:lonlat.zonal.xaxis.left", "xaxis.left");
            this.setPref("plot:lonlat.zonal.xaxis.right", "xaxis.right");
        } else {
            this.setPref("plot:2d.grid.color", "grid.color");
            this.setPref("plot:2d.grid.weight", "grid.weight");
            this.setPref("plot:2d.grid.style", "grid.style");
            this.setPref("plot:2d.axes.offset", "axes.offset");
            this.setPref("plot:2d.axes.tickmark.weight", "axes.tickmark.weight");
            this.setPref("plot:2d.axes.tickmark.color", "axes.tickmark.color");
            this.setPref("plot:interpolate", "interpolate");
            this.setPref("plot:scale.autofit", "scale.autofit");
            this.setPref("plot:scale.colorbar", "scale.colorbar");
            this.setPref("plot:scale.invalids", "scale.invalids");
            this.setPref("plot:scale.width", "scale.width");
            this.setPref("plot:scale.reverse", "scale.reverse");
            this.setPref("plot:scale.outlier.shape", "scale.outlier.shape");
            this.setPref("plot:scale.outlier.side", "scale.outlier.side");
            this.setPref("plot:scale.outlier.gap", "scale.outlier.gap");
            this.setPref("plot:scale.tick.size", "scale.tick.size");
            this.setPref("plot:scale.label.location", "scale.label.location");
            this.setPref("plot:2d.xaxis.tick.size", "xaxis.tick.size");
            this.setPref("plot:2d.yaxis.tick.size", "yaxis.tick.size");
            if (!this.pmeta_.isLonLatTrajectory()) {
                this.setPref("plot:contour.weight", "contour.weight");
                this.setPref("plot:contour.style", "contour.style");
                this.setPref("plot:contour.color", "contour.color");
                this.setPref("plot:contour.location", "contour.location");
                this.setPref("plot:contour.label.vis", "contour.label.vis");
                this.setPref("plot:contour.label.size", "contour.label.size");
            }
        }
        if (this.plotType_ == PanPlotType.LON_LAT) {
            this.setPref("plot:lonlat.lltype", "lonlat.lltype");
        }
        if (this.pmeta_.isColorFillMap() || this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT) {
            this.setPref("plot:vector.weight", "vector.weight");
            this.setPref("plot:vector.style", "vector.style");
            this.setPref("plot:vector.color", "vector.color");
            this.setPref("plot:vector.spacing", "vector.spacing");
            this.setPref("plot:vector.sample", "vector.sample");
        }
        if (this.pmeta_.isColorFillMap() || this.pmeta_.isLonLatTrajectory()) {
            int i;
            PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
            this.setPref("plot:lonlat.lltype", "lonlat.lltype");
            this.setPref("plot:lonlat.proj.name", "lonlat.proj.name");
            this.setPref("plot:lonlat.proj.lon0", "lonlat.proj.lon0");
            this.setPref("plot:lonlat.proj.lat0", "lonlat.proj.lat0");
            String pname = this.pmeta_.getString("lonlat.proj.name");
            for (i = 0; i < 5; ++i) {
                Object o = this.pmeta_.get("lonlat.proj.xparam." + (i + 1));
                if (o == null) continue;
                if (o instanceof Double) {
                    pprefs.setParam(pname, i, PrintfFormat.PFORMAT_10G.sprintg(o));
                    continue;
                }
                pprefs.setParam(pname, i, o.toString());
            }
            this.setPref("plot:grid.spacing.lon", "grid.spacing.lon");
            this.setPref("plot:grid.spacing.lat", "grid.spacing.lat");
            this.setPref("plot:grid.offset.lat", "grid.offset.lat");
            this.setPref("plot:grid.label.step", "grid.label.step");
            this.setPref("plot:grid.label.size", "grid.label.size");
            this.setPref("plot:lonlat.border.weight", "lonlat.border.weight");
            for (i = 0; i < 3; ++i) {
                this.setPref(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[i], PanParameterKeys.LON_LAT_OVERLAY_NAME[i]);
                this.setPref(PanParameterKeys.P_LON_LAT_OVERLAY_COLOR[i], PanParameterKeys.LON_LAT_OVERLAY_COLOR[i]);
                this.setPref(PanParameterKeys.P_LON_LAT_OVERLAY_INVERT[i], PanParameterKeys.LON_LAT_OVERLAY_INVERT[i]);
                this.setPref(PanParameterKeys.P_LON_LAT_OVERLAY_STYLE[i], PanParameterKeys.LON_LAT_OVERLAY_STYLE[i]);
                this.setPref(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_ID[i], PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_ID[i]);
                this.setPref(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_SIZE[i], PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_SIZE[i]);
                this.setPref(PanParameterKeys.P_LON_LAT_OVERLAY_WEIGHT[i], PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[i]);
            }
            if (this.prefs_.getBoolean("beta:underlays")) {
                this.setPref("plot:lonlat.underlay.vis", "lonlat.underlay.vis");
                this.setPref("plot:lonlat.underlay.name", "lonlat.underlay.name");
                this.setPref("plot:main.alpha.method", "main.alpha.method");
                this.setPref("plot:main.alpha.1", "main.alpha.1");
                this.setPref("plot:main.alpha.2", "main.alpha.2");
                this.setPref("plot:main.alpha.knockout", "main.alpha.knockout");
            }
            this.setPref("plot:lonlat.proj.shading.vis", "lonlat.proj.shading.vis");
            this.setPref("plot:lonlat.proj.shading.opacity", "lonlat.proj.shading.opacity");
            this.setPref("plot:lonlat.proj.subsolar.lon", "lonlat.proj.subsolar.lon");
            this.setPref("plot:lonlat.proj.subsolar.lat", "lonlat.proj.subsolar.lat");
            if (this.prefs_.getBoolean("beta:numberlays")) {
                this.setPref("plot:lonlat.numbers.vis", "lonlat.numbers.vis");
                this.setPref("plot:lonlat.numbers.invalids", "lonlat.numbers.invalids");
                this.setPref("plot:lonlat.numbers.color", "lonlat.numbers.color");
                this.setPref("plot:lonlat.numbers.weight", "lonlat.numbers.weight");
                this.setPref("plot:lonlat.numbers.size", "lonlat.numbers.size");
                this.setPref("plot:lonlat.numbers.spacing.lon", "lonlat.numbers.spacing.lon");
                this.setPref("plot:lonlat.numbers.spacing.lat", "lonlat.numbers.spacing.lat");
                this.setPref("plot:lonlat.numbers.offset.lon", "lonlat.numbers.offset.lon");
                this.setPref("plot:lonlat.numbers.offset.lat", "lonlat.numbers.offset.lat");
            }
        } else if (this.plotType_ == PanPlotType.LAT_TIME) {
            this.setPref("plot:lattime.xaxis.left", "xaxis.left");
            this.setPref("plot:lattime.xaxis.right", "xaxis.right");
        } else if (this.plotType_ == PanPlotType.LAT_VERT) {
            this.setPref("plot:latvert.xaxis.left", "xaxis.left");
            this.setPref("plot:latvert.xaxis.right", "xaxis.right");
            this.setPref("plot:latvert.yaxis.method", "yaxis.method");
            this.setPref("plot:latvert.yaxis.tick.format", "yaxis.tick.format");
        } else if (this.plotType_ == PanPlotType.LON_TIME) {
            this.setPref("plot:lontime.xaxis.left", "xaxis.left");
            this.setPref("plot:lontime.xaxis.right", "xaxis.right");
        } else if (this.plotType_ == PanPlotType.LON_VERT) {
            this.setPref("plot:lonvert.xaxis.left", "xaxis.left");
            this.setPref("plot:lonvert.xaxis.right", "xaxis.right");
            this.setPref("plot:lonvert.yaxis.method", "yaxis.method");
            this.setPref("plot:lonvert.yaxis.tick.format", "yaxis.tick.format");
        } else if (this.plotType_ == PanPlotType.TIME_LAT) {
            this.setPref("plot:timelat.yaxis.top", "yaxis.top");
            this.setPref("plot:timelat.yaxis.bottom", "yaxis.bottom");
        } else if (this.plotType_ == PanPlotType.TIME_VERT) {
            this.setPref("plot:lonvert.yaxis.method", "yaxis.method");
            this.setPref("plot:lonvert.yaxis.tick.format", "yaxis.tick.format");
        } else if (this.plotType_ == PanPlotType.GENERAL_2D) {
            this.setPref("plot:xy.xaxis.div.major", "xaxis.div.major");
            this.setPref("plot:xy.xaxis.div.minor", "xaxis.div.minor");
            this.setPref("plot:xy.yaxis.div.major", "yaxis.div.major");
            this.setPref("plot:xy.yaxis.div.minor", "yaxis.div.minor");
            this.setPref("plot:xy.yaxis.tick.format", "yaxis.tick.format");
            this.setPref("plot:xy.yaxis.tick.format", "yaxis.tick.format");
        }
        if (this.pmeta_.isLonLatTrajectory()) {
            this.setPref("plot:feature.background", "feature.background");
            this.setPref("plot:feature.nanskip", "feature.nanskip");
            for (int i = 0; i < 2; ++i) {
                this.setPref(PanParameterKeys.P_FEATURE_SYMBOL_ID[i], PanParameterKeys.FEATURE_SYMBOL_ID[i]);
                this.setPref(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[i], PanParameterKeys.FEATURE_SYMBOL_SIZE[i]);
                this.setPref(PanParameterKeys.P_FEATURE_SYMBOL_FILL[i], PanParameterKeys.FEATURE_SYMBOL_FILL[i]);
                this.setPref(PanParameterKeys.P_TRAJ_STROKE_COLOR[i], PanParameterKeys.STROKE_COLOR[i]);
                this.setPref(PanParameterKeys.P_TRAJ_STROKE_STYLE[i], PanParameterKeys.STROKE_STYLE[i]);
                this.setPref(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[i], PanParameterKeys.STROKE_WEIGHT[i]);
            }
        }
        if (PanPreferencesFrame.instanceExists()) {
            PanPreferencesFrame.getSharedInstance().refresh();
        }
    }

    private final void setPref(String prefKey, String plotKey) {
        if (!this.pmeta_.containsKey(plotKey)) {
            LOGGER.warn("Plot meta does not contain key {}", (Object)plotKey);
            return;
        }
        Object o = this.pmeta_.get(plotKey);
        this.prefs_.set(prefKey, o);
    }
}

