/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.action.PanPlotZoomInAction;
import gov.nasa.giss.panoply.action.PanPlotZoomOutAction;
import gov.nasa.giss.panoply.action.PanPlotZoomResetAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanCommonXAxisControls;
import gov.nasa.giss.panoply.plotui.PanCommonYAxisControls;
import gov.nasa.giss.panoply.plotui.PanScaleControls1D;
import gov.nasa.giss.panoply.plotui.PanZoomableAxisControls;
import gov.nasa.giss.panoply.plotui.PanZoomableGridControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanGridControls1D
extends PanZoomableGridControls {
    private PanEnumComboBox gridStyleCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanIntSpinner tickWeightSpinner_;
    private PanZoomableAxisControls axisControls_;
    private PanScaleControls1D scaleControls_;

    public PanGridControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout(mbar);
        this.attachListeners();
    }

    private final void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        AbstractAction a = new PanPlotZoomResetAction(this);
        this.pmeta_.putAction("reset-bounds", a);
        plotMenu.getItemByName("reset-bounds").setAction(a);
        a = new PanPlotZoomInAction(this);
        this.pmeta_.putAction("zoom-plot-in", a);
        plotMenu.getItemByName("zoom-plot-in").setAction(a);
        a = new PanPlotZoomOutAction(this);
        this.pmeta_.putAction("zoom-plot-out", a);
        plotMenu.getItemByName("zoom-plot-out").setAction(a);
    }

    private final void createLayout(PanMenuBar mbar) {
        PanLabel gStyleLabel = PanLabel.createSmall("Grid Style: ");
        this.gridStyleCombo_ = PanEnumComboBox.createSmall("grid.style", PanStrokeStyle.class);
        this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        PanLabel gWeightLabel = PanLabel.createSmall(", Weight: ");
        this.gridWeightSpinner_ = PanIntSpinner.createSmallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 200);
        PanLabel gPctLabel = PanLabel.createSmall("%");
        this.axesOffsetCB_ = PanCheckBox.createSmall("axes.offset", "Offset axes from grid edges", this.pmeta_.getBoolean("axes.offset"));
        PanLabel aWeightLabel = PanLabel.createSmall("Tickmark Weight: ");
        this.tickWeightSpinner_ = PanIntSpinner.createSmallWeight("axes.tickmark.weight", this.pmeta_.getInt("axes.tickmark.weight"), 200);
        PanLabel aPctLabel = PanLabel.createSmall("%");
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        QuickBox gStyleBox = QuickBox.createCenterBox(gStyleLabel, this.gridStyleCombo_, gWeightLabel, this.gridWeightSpinner_, gPctLabel, Box.createHorizontalStrut(30), PanLabel.createSmall(" \u2014 "), Box.createHorizontalStrut(30), this.axesOffsetCB_, Box.createHorizontalStrut(30), PanLabel.createSmall(" \u2014 "), Box.createHorizontalStrut(30), aWeightLabel, this.tickWeightSpinner_, aPctLabel);
        this.axisControls_ = this.plotType_ == PanPlotType.HORZ_LINE ? new PanCommonXAxisControls(this.pmeta_, mbar) : new PanCommonYAxisControls(this.pmeta_, mbar);
        this.scaleControls_ = new PanScaleControls1D(this.pmeta_, mbar);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRowWeight(3, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)gStyleBox, new FGConstraint(0, 0, 2, 1, -1.0, 0.0));
        this.add((Component)new JSeparator(), new FGConstraint(0, 1, 2, 1));
        if (this.plotType_ == PanPlotType.HORZ_LINE) {
            this.add((Component)this.axisControls_, new FGConstraint(0, 2, 0.0, 0.0));
            this.add((Component)this.scaleControls_, new FGConstraint(1, 2, 0.0, 0.0));
        } else {
            this.add((Component)this.scaleControls_, new FGConstraint(0, 2, 0.0, 0.0));
            this.add((Component)this.axisControls_, new FGConstraint(1, 2, 0.0, 0.0));
        }
    }

    private final void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.gridStyleCombo_.getStringValue());
        });
        this.gridWeightSpinner_.addChangeListener(e -> this.pmeta_.setInt("grid.weight", this.gridWeightSpinner_.getIntValue()));
        this.axesOffsetCB_.addItemListener(e -> {
            boolean checked = this.axesOffsetCB_.isSelected();
            this.pmeta_.setBoolean("axes.offset", checked);
            this.tickWeightSpinner_.setEnabled(!checked);
        });
        this.tickWeightSpinner_.addChangeListener(e -> this.pmeta_.setInt("axes.tickmark.weight", this.tickWeightSpinner_.getIntValue()));
    }

    @Override
    public void refreshZoom() {
    }

    @Override
    public void recenter(double x, double y) {
        this.zoom(1.0, x, y);
    }

    @Override
    public void zoomIn() {
        this.zoom(1.5);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.6666666666666666);
    }

    @Override
    public void zoomIn(double centerx, double centery) {
        this.zoom(1.5, centerx, centery);
    }

    @Override
    public void zoomOut(double centerx, double centery) {
        this.zoom(0.6666666666666666, centerx, centery);
    }

    @Override
    public void zoom(double factor) {
        this.axisControls_.zoom(factor);
        this.scaleControls_.zoom(factor);
    }

    @Override
    public void zoom(double factor, double centerx, double centery) {
        if (this.plotType_ == PanPlotType.HORZ_LINE) {
            this.axisControls_.zoom(factor, centerx);
            this.scaleControls_.zoom(factor, centery);
        } else {
            this.scaleControls_.zoom(factor, centerx);
            this.axisControls_.zoom(factor, centery);
        }
    }

    @Override
    public void dragZoom(double centerx, double centery, double leftx, double topy, double rightx, double bottomy) {
        if (this.plotType_ == PanPlotType.HORZ_LINE) {
            this.axisControls_.setAxisBounds(leftx, rightx);
            this.scaleControls_.setScaleRange(bottomy, topy);
        } else {
            this.scaleControls_.setScaleRange(leftx, rightx);
            this.axisControls_.setAxisBounds(bottomy, topy);
        }
    }

    @Override
    public void resetGridBounds() {
        this.axisControls_.resetAxisBounds();
        PanActionHash actionHash = this.pmeta_.getActionHash();
        ((Action)actionHash.get("fit-scale-to-data")).actionPerformed(null);
    }
}

