/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataXTime;
import gov.nasa.giss.panoply.plot.PanGeneral2DPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.time.PatternTime;
import gov.nasa.giss.time.TimeFormatter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanXTimePlot
extends PanGeneral2DPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String timeAxisFormat_;
    private NcTimeAxis timeAxis_;
    private boolean formattedTime_;

    public PanXTimePlot(PanPlotMeta pmeta) {
        super(pmeta);
        PanData2D data = (PanData2D)pmeta.getData();
        NcTimeAxis tax = (NcTimeAxis)data.getYAxis();
        if (tax.isFormattedTime()) {
            TimeFormatter formatter = tax.getFormatter();
            this.timeAxisFormat_ = null;
            if (formatter instanceof PatternTime) {
                this.timeAxisFormat_ = ((PatternTime)((Object)formatter)).getPattern();
            }
            if (this.timeAxisFormat_ != null) {
                if (this.timeAxisFormat_.endsWith(" Z")) {
                    this.timeAxisFormat_ = this.timeAxisFormat_.replace(" Z", "");
                }
                this.pmeta_.setString("yaxis.tick.format", this.timeAxisFormat_);
            }
        }
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void prepareToPaint() {
        block2: {
            super.prepareToPaint();
            try {
                NcAxis yax = ((PanData2D)this.data_).getYAxis();
                this.timeAxis_ = (NcTimeAxis)yax;
                this.formattedTime_ = this.timeAxis_.isFormattedTime();
            }
            catch (Exception exc) {
                LOGGER.debug("Exception creating Y (time) axis {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    @Override
    protected String getYAxisTickLabel(double val) {
        return this.formattedTime_ ? this.timeAxis_.formatValue(val) : Double.toString(val);
    }

    @Override
    protected String getYAxisLabel() {
        if (this.yaxisLabelText_ != null) {
            return this.yaxisLabelText_;
        }
        if (this.formattedTime_) {
            return "Time";
        }
        NcAxis yaxis = ((PanData2D)this.data_).getYAxis();
        String unitsStr = yaxis.getUnitsString();
        if (unitsStr == null || unitsStr.isEmpty()) {
            return "Time";
        }
        return "Time (" + unitsStr + ")";
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("yaxis.tick.format")) {
            this.timeAxisFormat_ = this.pmeta_.getString("yaxis.tick.format");
            if (this.timeAxisFormat_ == null || this.timeAxisFormat_.isEmpty()) {
                this.timeAxisFormat_ = null;
            } else {
                ((PanDataXTime)this.data_).setTimeFormat(this.timeAxisFormat_);
            }
        }
    }
}

