/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.plot.PanMinMaxNote;
import gov.nasa.giss.panoply.plot.PanPlotLabel;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.util.PanPlotType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanPlot
extends PanPlotPiece
implements PanDataListener,
PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static float EDGE_TOLERANCE = 0.225f;
    protected boolean needsRepaint_ = true;
    protected boolean needsDataRedraw_ = true;
    protected PanData data_;
    protected PanPlotType ptype_;
    private PanPlotLabel titleNote_;
    private PanPlotLabel subtitleNote_;
    private PanPlotLabel leftFootnote_;
    private PanPlotLabel rightFootnote_;
    private PanPlotLabel centerFootnote_;
    protected float gridWidth_;
    protected float gridHeight_;
    protected float gridLeft_;
    protected float gridTop_;
    protected float gridRight_;
    protected float gridBottom_;
    protected BasicStroke gridStroke_;
    protected int gridWeight_ = 75;
    protected Color gridColor_ = Color.BLACK;
    protected float tickLengthMajor_;
    protected float tickLengthMinor_;
    protected float tickLabelOffset_;
    protected BasicStroke tickStroke_;
    protected BasicStroke borderStroke_;
    protected int xMajorDiv_ = 1;
    protected int xMinorDiv_ = 1;
    protected int yMajorDiv_ = 1;
    protected int yMinorDiv_ = 1;
    protected String xaxisLabelText_;
    protected String yaxisLabelText_;
    protected Font xAxisLabelFont_;
    protected Font yAxisLabelFont_;
    protected Font xAxisTickFont_;
    protected Font yAxisTickFont_;
    protected float xAxisLabelFhgt_;
    protected float yAxisLabelFhgt_;
    protected float xAxisTickFhgt_;
    protected float yAxisTickFhgt_;

    private PanPlot() {
    }

    protected PanPlot(PanPlotMeta pmeta) {
        super(pmeta);
        this.data_ = pmeta.getData();
        this.ptype_ = pmeta.getType();
        this.setOpaque(true);
        this.titleNote_ = new PanPlotLabel(pmeta, this.pmeta_.getString("title.text"));
        this.subtitleNote_ = new PanPlotLabel(pmeta, "");
        this.leftFootnote_ = new PanPlotLabel(pmeta, "", PanPlotLabel.HAlignment.LEFT);
        this.rightFootnote_ = new PanPlotLabel(pmeta, "", PanPlotLabel.HAlignment.RIGHT);
        this.centerFootnote_ = new PanMinMaxNote(pmeta, this.data_);
        this.attach(this.titleNote_);
        this.attach(this.subtitleNote_);
        this.attach(this.leftFootnote_);
        this.attach(this.rightFootnote_);
        this.attach(this.centerFootnote_);
        this.data_.addDataListener(this);
        this.pmeta_.addPlotPropertyListener(this);
        this.parameterChangedPrivate("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.needsDataRedraw_ = true;
    }

    @Override
    public PanPlotMeta getMeta() {
        return this.pmeta_;
    }

    public Point2D.Double transformXY2GridCoords(int x, int y) {
        return this.transformXY2GridCoords((double)x + 0.5, (double)y + 0.5);
    }

    public abstract Point2D.Double transformXY2GridCoords(double var1, double var3);

    public abstract String describePoint(int var1, int var2);

    public boolean needsRepaint() {
        return this.needsRepaint_ || this.needsDataRedraw_;
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        boolean titlesVis = this.pmeta_.getBoolean("include.title");
        boolean fnotesVis = this.pmeta_.getBoolean("include.footnotes");
        if (titlesVis) {
            String ttext = this.pmeta_.getString("title.text");
            String stext = this.pmeta_.getString("subtitle.text");
            float tfh = scaling * this.pmeta_.getFloat("title.size");
            float sfh = scaling * this.pmeta_.getFloat("subtitle.size");
            Rectangle trect = new Rectangle((Rectangle)this.pmeta_.getLayout().getParam("bounds.title"));
            Rectangle srect = new Rectangle((Rectangle)this.pmeta_.getLayout().getParam("bounds.subtitle"));
            if (stext == null || stext.isEmpty()) {
                float yshift = 0.5f * sfh;
                trect.y = (int)((float)trect.y + yshift);
                this.subtitleNote_.setVisible(false);
                this.subtitleNote_.setLocation(0, 0);
                this.subtitleNote_.setSize(0, 0);
            } else {
                this.subtitleNote_.setVisible(true);
                this.subtitleNote_.setText(stext);
                this.subtitleNote_.setFontSize(sfh);
                this.subtitleNote_.setLocation(srect.x, srect.y);
                this.subtitleNote_.setSize(srect.width, srect.height);
            }
            if (ttext == null || ttext.isEmpty()) {
                this.titleNote_.setVisible(false);
                this.titleNote_.setLocation(0, 0);
                this.titleNote_.setSize(0, 0);
            } else {
                this.titleNote_.setVisible(true);
                this.titleNote_.setText(ttext);
                this.titleNote_.setFontSize(tfh);
                this.titleNote_.setLocation(trect.x, trect.y);
                this.titleNote_.setSize(trect.width, trect.height);
            }
        } else {
            this.titleNote_.setVisible(false);
            this.titleNote_.setLocation(0, 0);
            this.titleNote_.setSize(0, 0);
            this.subtitleNote_.setVisible(false);
            this.subtitleNote_.setLocation(0, 0);
            this.subtitleNote_.setSize(0, 0);
        }
        boolean leftFnVis = false;
        boolean rightFnVis = false;
        boolean centerFnVis = false;
        if (fnotesVis) {
            String leftFnText = this.pmeta_.getString("footnote.left");
            String rightFnText = this.pmeta_.getString("footnote.right");
            if (leftFnText != null && leftFnText.length() > 40) {
                leftFnText = leftFnText.substring(0, 40) + "\u2026";
            }
            if (rightFnText != null && rightFnText.length() > 40) {
                rightFnText = rightFnText.substring(0, 40) + "\u2026";
            }
            this.leftFootnote_.setText(leftFnText);
            this.rightFootnote_.setText(rightFnText);
            leftFnVis = leftFnText != null && !leftFnText.isEmpty();
            rightFnVis = rightFnText != null && !rightFnText.isEmpty();
            centerFnVis = this.pmeta_.getBoolean("scale.minmax.note");
            float notesFhgt = scaling * this.pmeta_.getFloat("footnote.size");
            if (leftFnVis) {
                Rectangle rr = (Rectangle)this.pmeta_.getLayout().getParam("bounds.note.left");
                this.leftFootnote_.setBounds(rr);
                this.leftFootnote_.setFontSize(notesFhgt);
            }
            if (rightFnVis) {
                Rectangle rr = (Rectangle)this.pmeta_.getLayout().getParam("bounds.note.right");
                this.rightFootnote_.setBounds(rr);
                this.rightFootnote_.setFontSize(notesFhgt);
            }
            if (centerFnVis) {
                Rectangle rr = (Rectangle)this.pmeta_.getLayout().getParam("bounds.note.center");
                this.centerFootnote_.setBounds(rr);
                this.centerFootnote_.setFontSize(notesFhgt);
            }
        }
        this.leftFootnote_.setVisible(leftFnVis);
        this.rightFootnote_.setVisible(rightFnVis);
        this.centerFootnote_.setVisible(centerFnVis);
        if (!leftFnVis) {
            this.leftFootnote_.setLocation(0, 0);
            this.leftFootnote_.setSize(0, 0);
        }
        if (!rightFnVis) {
            this.rightFootnote_.setLocation(0, 0);
            this.rightFootnote_.setSize(0, 0);
        }
        if (!centerFnVis) {
            this.centerFootnote_.setLocation(0, 0);
            this.centerFootnote_.setSize(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g2d) {
        PanPlot panPlot = this;
        synchronized (panPlot) {
            super.paint(g2d);
            this.needsRepaint_ = false;
        }
    }

    protected abstract String getExtremaDescription();

    @Override
    public void paint(BufferedImage img) {
        this.needsDataRedraw_ = true;
        super.paint(img);
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        this.needsDataRedraw_ = true;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            this.parameterChanged(null);
        } else {
            this.parameterChanged(e.getMessage());
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("scale.min") || pname.contains("scale.max")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("scale.autofit")) {
            this.needsDataRedraw_ = true;
        }
        this.needsRepaint_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanPlot panPlot = this;
        synchronized (panPlot) {
            if (this.pmeta_ != null) {
                this.pmeta_.removePlotPropertyListener(this);
            }
            if (this.data_ != null) {
                this.data_.removeDataListener(this);
            }
            this.pmeta_ = null;
            this.data_ = null;
            this.centerFootnote_ = null;
            this.rightFootnote_ = null;
        }
    }
}

