/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.TextUtils;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatPlotZonal
extends PanPlotPiece {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final float BAD_POINT = -9999.0f;
    protected static float EDGE_TOLERANCE = 0.225f;
    private PanDataLonLat data_;
    private int gridWeight_ = 100;
    private Color gridColor_;
    private BasicStroke gridStroke_;
    private BasicStroke borderStroke_;
    private Color strokeColor_;
    private BasicStroke strokeStroke_;
    private int xMajorDiv_ = 6;
    private int xMinorDiv_ = 2;
    private int yMajorDiv_ = 1;
    private int yMinorDiv_ = 1;
    private PrintfFormat xAxisFormatter_ = new PrintfFormat("%.0f");
    private Font strokeLabelFont_;
    private float strokeLabelFhgt_;
    private Font xAxisLabelFont_;
    private Font yAxisLabelFont_;
    private Font xAxisTickFont_;
    private Font yAxisTickFont_;
    private float xAxisLabelFhgt_;
    private float yAxisLabelFhgt_;
    private float xAxisTickFhgt_;
    private float yAxisTickFhgt_;
    private float tickLengthMajor_;
    private float tickLengthMinor_;
    private float tickLabelOffset_;
    private BasicStroke tickStroke_;
    private float gridWidth_;
    private float gridHeight_;
    private float gridLeft_;
    private float gridTop_;
    private float gridRight_;
    private float gridBottom_;
    private boolean includeAxes_;
    private boolean axesOffset_;
    private float yAxisX_;
    private float xAxisY_;
    private String scaleCaption_;
    private String xaxisLabelText_;
    private String strokeLabelText_;
    private float sLabelY_;
    private float sStrokeY_;
    private double scaleMin_;
    private double scaleMax_;

    public PanLonLatPlotZonal(PanPlotMeta pmeta, PanDataLonLat data) {
        super(pmeta);
        this.data_ = data;
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        this.includeAxes_ = this.pmeta_.getBoolean("include.axes");
        this.axesOffset_ = this.pmeta_.getBoolean("axes.offset");
        int ww = this.getWidth();
        Dimension gsize = (Dimension)this.pmeta_.getLayout().getParam("size.gridding");
        PlotPieceMargins margins = this.getMargins();
        this.gridWidth_ = 0.8f * (float)gsize.width;
        this.gridHeight_ = 0.9f * (float)gsize.height;
        this.gridLeft_ = 0.5f * ((float)ww - this.gridWidth_);
        this.gridTop_ = margins.top;
        this.gridRight_ = this.gridLeft_ + this.gridWidth_;
        this.gridBottom_ = this.gridTop_ + this.gridHeight_;
        this.tickLengthMajor_ = Math.max(4.0f, scaling * 6.0f);
        this.tickLengthMinor_ = Math.max(2.0f, scaling * 3.0f);
        this.tickLabelOffset_ = Math.max(2.0f, scaling * 3.0f);
        if (this.axesOffset_ && this.includeAxes_) {
            this.tickStroke_ = this.borderStroke_;
        } else {
            int tickWeight = PanUtils.min0max(200, this.pmeta_.getInt("axes.tickmark.weight"));
            this.tickStroke_ = PanGraphicUtils.tickStroke((int)(0.01 * (double)tickWeight * (double)sfactor));
        }
        this.yAxisX_ = this.axesOffset_ ? this.gridLeft_ - this.tickLengthMajor_ : this.gridLeft_;
        this.xAxisY_ = this.axesOffset_ ? this.gridBottom_ + this.tickLengthMajor_ : this.gridBottom_;
        Rectangle rr = this.getBounds();
        Rectangle sBounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.scale");
        this.sLabelY_ = (float)sBounds.y + 0.5f * (float)sBounds.height - (float)rr.y;
        this.sStrokeY_ = this.sLabelY_ - 0.4f * this.strokeLabelFhgt_;
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        this.scaleMin_ = smeta.getScaleMinimum();
        this.scaleMax_ = smeta.getScaleMaximum();
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                if (this.scaleMin_ <= 0.0) {
                    this.scaleMin_ = 1.0E-50;
                }
                if (!(this.scaleMax_ <= 1.0E-50)) break;
                this.scaleMax_ = 1.0E-25;
                break;
            }
        }
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        Rectangle oldClip = g2d.getClipBounds();
        Rectangle rr = new Rectangle(oldClip.x, oldClip.y - 4, oldClip.width, oldClip.height + 4);
        if (rr.y + rr.height > oldClip.y + oldClip.height) {
            int diff = rr.y + rr.height - (oldClip.y + oldClip.height);
            rr.height -= diff;
        }
        g2d.setClip(rr);
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        GraphicUtils.drawRect(g2d, this.gridLeft_, this.gridTop_, this.gridWidth_, this.gridHeight_);
        g2d.setClip(oldClip);
        this.drawXAxis(g2d);
        if (this.includeAxes_) {
            this.drawXAxisLabel(g2d);
        }
        int maxLabelWidth = this.drawYAxis(g2d);
        if (this.includeAxes_) {
            this.drawYAxisLabel(g2d, maxLabelWidth);
        }
        this.drawCurve(g2d);
        if (this.pmeta_.getBoolean("include.scale")) {
            this.drawCurveLabel(g2d);
        }
        g2d.dispose();
    }

    private final void drawXAxis(Graphics2D g2d) {
        double xAxisLeft = this.pmeta_.getDouble("xaxis.left");
        double xAxisRight = this.pmeta_.getDouble("xaxis.right");
        int divs = this.xMajorDiv_ * this.xMinorDiv_;
        float invDivs = 1.0f / (float)divs;
        double hDelta = (xAxisRight - xAxisLeft) * (double)invDivs;
        if (this.axesOffset_ && this.includeAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.gridLeft_, this.xAxisY_, this.gridRight_, this.xAxisY_);
        }
        for (int i = 0; i <= divs; ++i) {
            boolean isMajor;
            double value = xAxisLeft + (double)i * hDelta;
            float x = this.gridLeft_ + this.gridWidth_ * (float)i * invDivs;
            boolean isNearEdge = Math.abs(x - this.gridLeft_) < EDGE_TOLERANCE || Math.abs(x - this.gridRight_) < EDGE_TOLERANCE;
            boolean bl = isMajor = i % this.xMinorDiv_ == 0;
            if (isMajor) {
                String label = this.xAxisFormatter_.sprintg(value);
                this.drawXAxisTickLabel(g2d, label, x);
                if (this.gridStroke_ != null && this.gridWeight_ > 0 && !isNearEdge) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridBottom_);
                }
            }
            float tt = isMajor ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.gridColor_);
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includeAxes_) {
                GraphicUtils.drawLine(g2d, x, this.xAxisY_ + 0.5f * tt, x, this.xAxisY_ - 0.5f * tt);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridTop_ + tt);
            GraphicUtils.drawLine(g2d, x, this.gridBottom_, x, this.gridBottom_ - tt);
        }
    }

    private int drawXAxisTickLabel(Graphics2D g2d, String label, float tickX) {
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        int labelWidth = fm.stringWidth(label);
        float x = tickX - 0.5f * (float)labelWidth;
        float y = this.xAxisY_ + 1.5f * this.tickLabelOffset_ + this.xAxisTickFhgt_;
        g2d.drawString(label, x, y);
        return labelWidth;
    }

    private final void drawXAxisLabel(Graphics2D g2d) {
        if (!this.includeAxes_) {
            return;
        }
        String label = this.xaxisLabelText_ != null ? this.xaxisLabelText_ : "Latitude (\u00b0N)";
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisLabelFont_);
        FontMetrics fm = g2d.getFontMetrics();
        int labelWidth = fm.stringWidth(label);
        int x = (int)(this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)labelWidth));
        int y = (int)(this.xAxisY_ + 2.0f + this.xAxisTickFhgt_ + 0.33f * this.xAxisTickFhgt_ + this.xAxisLabelFhgt_);
        g2d.drawString(label, x, y);
    }

    private int drawYAxis(Graphics2D g2d) {
        Rectangle oldClip = g2d.getClipBounds();
        Rectangle rr = new Rectangle(oldClip.x, oldClip.y - 12, oldClip.width, oldClip.height + 8);
        if (rr.y + rr.height > oldClip.y + oldClip.height) {
            int diff = rr.y + rr.height - (oldClip.y + oldClip.height);
            rr.height -= diff;
        }
        g2d.setClip(rr);
        if (this.axesOffset_ && this.includeAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.yAxisX_, this.gridBottom_ - this.gridHeight_, this.yAxisX_, this.gridBottom_);
        }
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        int maxLabelWidth = 0;
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                maxLabelWidth = this.drawLogYAxis(g2d, smethod);
                break;
            }
            default: {
                maxLabelWidth = this.drawScalarYAxis(g2d);
            }
        }
        g2d.setClip(oldClip);
        return maxLabelWidth;
    }

    private int drawScalarYAxis(Graphics2D g2d) {
        PanScaleTick[] ticks;
        int maxLabelWidth = 0;
        double delta = (this.scaleMax_ - this.scaleMin_) / (double)this.gridHeight_;
        double invDelta = 1.0 / delta;
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        for (PanScaleTick tick : ticks = smeta.getTicks()) {
            boolean isNearEdge;
            double value = tick.getValue();
            float y = (float)((double)this.gridBottom_ - (value - this.scaleMin_) * invDelta);
            boolean bl = isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
            if (tick.isMajor()) {
                String label = smeta.getFormatter().sprintg(value);
                int labelWidth = this.drawYAxisTickLabel(g2d, label, y);
                maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                if (this.gridStroke_ != null && this.gridWeight_ > 0 && !isNearEdge) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                }
            }
            float tt = tick.isMajor() ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.gridColor_);
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includeAxes_) {
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
            GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
        }
        return maxLabelWidth;
    }

    private int drawLogYAxis(Graphics2D g2d, PanScaleMethod smethod) {
        PanScaleTick[] ticks;
        double logScaleMax;
        double logScaleMin;
        int maxLabelWidth = 0;
        switch (smethod) {
            case LOG_E: {
                logScaleMin = Math.log(this.scaleMin_);
                logScaleMax = Math.log(this.scaleMax_);
                break;
            }
            default: {
                logScaleMin = Math.log10(this.scaleMin_);
                logScaleMax = Math.log10(this.scaleMax_);
            }
        }
        double mstep = (double)this.gridHeight_ / (logScaleMax - logScaleMin);
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        for (PanScaleTick tick : ticks = smeta.getTicks()) {
            boolean isNearEdge;
            double value = tick.getValue();
            double logValue = tick.getAlternativeValue();
            float y = (float)((double)this.gridBottom_ - (logValue - logScaleMin) * mstep);
            if (y > this.gridBottom_ + 0.1f) continue;
            if (y < this.gridBottom_ - this.gridHeight_ - 0.1f) break;
            boolean bl = isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
            if (tick.isMajor()) {
                String label = smeta.getFormatter().sprintg(value);
                int labelWidth = this.drawYAxisTickLabel(g2d, label, y);
                maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                if (this.gridStroke_ != null && this.gridWeight_ > 0 && !isNearEdge) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                }
            }
            float tt = tick.isMajor() ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.gridColor_);
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includeAxes_) {
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
            GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
        }
        return maxLabelWidth;
    }

    private int drawYAxisTickLabel(Graphics2D g2d, String label, float tickY) {
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.yAxisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        int labelWidth = fm.stringWidth(label);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - (float)labelWidth;
        float y = tickY + 0.5f * this.yAxisTickFhgt_ - 1.0f;
        g2d.drawString(label, x, y);
        return labelWidth;
    }

    private final void drawYAxisLabel(Graphics2D g2d, float maxLabelWidth) {
        if (!this.includeAxes_) {
            return;
        }
        String caption = this.scaleCaption_;
        g2d.setColor(this.getForeground());
        g2d.setFont(this.yAxisLabelFont_);
        FontMetrics fm = g2d.getFontMetrics();
        caption = TextUtils.trimStringToFit(caption, fm, this.gridHeight_);
        int labelWidth = fm.stringWidth(caption);
        int x = (int)(this.yAxisX_ - this.tickLengthMajor_ - maxLabelWidth - 0.33f * this.yAxisTickFhgt_);
        int y = (int)(this.gridBottom_ - 0.5f * (this.gridHeight_ - (float)labelWidth));
        g2d.translate(x, y);
        g2d.rotate(-1.5707963267948966);
        g2d.drawString(caption, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-x, -y);
    }

    private final void drawCurve(Graphics2D g2d) {
        int diff;
        if (this.strokeStroke_ == null) {
            return;
        }
        Rectangle oldClip = g2d.getClipBounds();
        Rectangle rr = new Rectangle((int)this.gridLeft_, (int)(this.gridTop_ - 4.0f), (int)this.gridWidth_, (int)(this.gridHeight_ + 8.0f));
        if (rr.y < oldClip.y - 4) {
            diff = oldClip.y - 4 - rr.y;
            rr.y += diff;
            rr.height -= diff;
        }
        if (rr.y + rr.height > oldClip.y + oldClip.height) {
            diff = rr.y + rr.height - (oldClip.y + oldClip.height);
            rr.height -= diff;
        }
        g2d.setClip(rr);
        g2d.setColor(this.strokeColor_);
        g2d.setStroke(this.strokeStroke_);
        double xAxisLeft = this.pmeta_.getDouble("xaxis.left");
        double xAxisRight = this.pmeta_.getDouble("xaxis.right");
        double xRange = xAxisRight - xAxisLeft;
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double yTop = 0.0;
        double yBottom = 0.0;
        switch (smethod) {
            case LOG10: {
                yTop = Math.log10(this.scaleMax_);
                yBottom = Math.log10(this.scaleMin_);
                break;
            }
            case LOG_E: {
                yTop = Math.log(this.scaleMax_);
                yBottom = Math.log(this.scaleMin_);
                break;
            }
            default: {
                yTop = this.scaleMax_;
                yBottom = this.scaleMin_;
            }
        }
        double yRange = yTop - yBottom;
        double yDelta = yRange / (double)this.gridHeight_;
        double yscale = 1.0 / yDelta;
        int dataHeight = this.data_.getHeight();
        double dataLeft = this.data_.getTopLat();
        double dataRight = this.data_.getBottomLat();
        double dataDelta = (dataRight - dataLeft) / (double)dataHeight;
        float lastY = -9999.0f;
        GeneralPath path = new GeneralPath();
        for (int j = 0; j < dataHeight; ++j) {
            double value;
            double lat = dataLeft + (0.5 + (double)j) * dataDelta;
            if (lat < xAxisLeft && lat < xAxisRight || lat > xAxisLeft && lat > xAxisRight) continue;
            float x = (float)((double)this.gridWidth_ * (lat - xAxisLeft) / xRange);
            switch (smethod) {
                case LOG10: {
                    value = this.data_.getRowAverageValue(j);
                    if (value <= 0.0) {
                        value = Double.NaN;
                        break;
                    }
                    value = Math.log10(value);
                    break;
                }
                case LOG_E: {
                    value = this.data_.getRowAverageValue(j);
                    if (value <= 0.0) {
                        value = Double.NaN;
                        break;
                    }
                    value = Math.log(value);
                    break;
                }
                default: {
                    value = this.data_.getRowAverageValue(j);
                }
            }
            float y = Double.isNaN(value) ? -9999.0f : (Double.isInfinite(value) ? (value < 0.0 ? 1.0E9f : -1.0E9f) : -((float)((value - yBottom) * yscale)));
            if (y == -9999.0f) {
                g2d.draw(path);
                path.reset();
                lastY = -9999.0f;
                continue;
            }
            if (lastY != -9999.0f) {
                path.lineTo(this.gridLeft_ + x, this.gridBottom_ + y);
            } else if (y != -9999.0f) {
                path.moveTo(this.gridLeft_ + x, this.gridBottom_ + y);
            }
            lastY = y;
        }
        g2d.draw(path);
        g2d.setClip(oldClip);
    }

    private final void drawCurveLabel(Graphics2D g2d) {
        String caption = this.strokeLabelText_;
        if (caption == null || caption.isEmpty()) {
            return;
        }
        g2d.setFont(this.strokeLabelFont_);
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        int lspace = (int)(scaling * 24.0f);
        int maxTWidth = (int)(0.75f * this.gridWidth_ - (float)lspace);
        FontMetrics fm = g2d.getFontMetrics();
        caption = TextUtils.trimStringToFit(caption, fm, maxTWidth);
        int tlength = Math.min(maxTWidth, fm.stringWidth(caption));
        int totWidth = lspace + tlength;
        int left1 = (int)(this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)totWidth));
        g2d.setColor(this.strokeColor_);
        g2d.setStroke(this.strokeStroke_);
        int strokeLength = (int)(scaling * 20.0f);
        GraphicUtils.drawLine(g2d, left1, this.sStrokeY_, left1 + strokeLength, this.sStrokeY_);
        g2d.setColor(this.getForeground());
        g2d.drawString(caption, left1 + lspace, (int)this.sLabelY_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanLonLatPlotZonal panLonLatPlotZonal = this;
        synchronized (panLonLatPlotZonal) {
            this.data_ = null;
            this.pmeta_ = null;
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if ((changeAll || pname.contains("lonlat.lltype")) && this.pmeta_.getString("lonlat.lltype").toLowerCase().contains("zonal")) {
            this.data_.setLonLatBounds(LonLatBounds.ENTIRE_GLOBE);
        }
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
            this.gridColor_ = this.getForeground();
        }
        int sfactor = this.pmeta_.getInt("size.factor");
        if (changeAll || pname.contains(PanParameterKeys.STROKE_COLOR[0]) || pname.contains(PanParameterKeys.STROKE_STYLE[0]) || pname.contains(PanParameterKeys.STROKE_WEIGHT[0])) {
            this.strokeColor_ = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[0]);
            this.strokeStroke_ = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[0]), this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[0]), sfactor);
        }
        if (changeAll || pname.contains(PanParameterKeys.STROKE_LABEL_CUSTOM[0]) || pname.contains(PanParameterKeys.STROKE_LABEL_TEXT[0])) {
            this.strokeLabelText_ = this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0]) ? this.pmeta_.getString(PanParameterKeys.STROKE_LABEL_TEXT[0]) : this.data_.getDescription();
        }
        if (changeAll || pname.contains("grid.style") || pname.contains("grid.weight")) {
            this.gridWeight_ = PanUtils.min0max(200, this.pmeta_.getInt("grid.weight"));
            this.gridStroke_ = PanGraphicUtils.buttMiterStroke(this.pmeta_.getString("grid.style"), this.gridWeight_, sfactor);
            int borderWgt = Math.max(75, this.gridWeight_);
            this.borderStroke_ = PanGraphicUtils.solidStroke(borderWgt, sfactor);
        }
        if (changeAll || pname.contains("xaxis.div.major")) {
            try {
                int divs = this.pmeta_.getInt("xaxis.div.major");
                divs = Math.min(divs, 25);
                this.xMajorDiv_ = divs = Math.max(divs, 1);
            }
            catch (Exception divs) {
                // empty catch block
            }
        }
        if (changeAll || pname.contains("xaxis.div.minor")) {
            try {
                int divs = this.pmeta_.getInt("xaxis.div.minor");
                divs = Math.min(divs, 25);
                this.xMinorDiv_ = divs = Math.max(divs, 1);
            }
            catch (Exception divs) {
                // empty catch block
            }
        }
        if (changeAll || pname.contains("xaxis.tick.format")) {
            String s = this.pmeta_.getString("xaxis.tick.format");
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"xaxis.tick.format");
                throw new RuntimeException("Null format string");
            }
            this.xAxisFormatter_ = new PrintfFormat(s);
        }
        if (changeAll || pname.contains("scale.label.custom") || pname.contains("scale.label.text")) {
            this.scaleCaption_ = this.pmeta_.getBoolean("scale.label.custom") ? this.pmeta_.getString("scale.label.text") : this.data_.getDescription();
        }
        if (changeAll || pname.contains("scale.div.major")) {
            this.yMajorDiv_ = Math.max(1, this.pmeta_.getInt("scale.div.major"));
            this.yMajorDiv_ = Math.min(20, this.yMajorDiv_);
        }
        if (changeAll || pname.contains("scale.div.minor")) {
            this.yMinorDiv_ = Math.max(1, this.pmeta_.getInt("scale.div.minor"));
            this.yMinorDiv_ = Math.min(20, this.yMinorDiv_);
        }
        if (changeAll || pname.contains("scale.method")) {
            // empty if block
        }
        float scaling = 0.01f * (float)sfactor;
        if (changeAll || pname.contains("font.master") || pname.contains("size.factor") || pname.contains("xaxis.label.size") || pname.contains("xaxis.tick.size") || pname.contains("yaxis.label.size") || pname.contains("yaxis.tick.size")) {
            LOGGER.trace("{}", (Object)pname);
            String fn = this.pmeta_.getString("font.master");
            this.strokeLabelFhgt_ = scaling * this.pmeta_.getFloat("stroke.label.size");
            this.strokeLabelFont_ = PanGraphicUtils.getFont(fn, this.strokeLabelFhgt_);
            this.xAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("xaxis.label.size");
            this.yAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("yaxis.label.size");
            this.xAxisTickFhgt_ = scaling * this.pmeta_.getFloat("xaxis.tick.size");
            this.yAxisTickFhgt_ = scaling * this.pmeta_.getFloat("yaxis.tick.size");
            this.xAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.xAxisLabelFhgt_);
            this.yAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.yAxisLabelFhgt_);
            this.xAxisTickFont_ = PanGraphicUtils.getFont(fn, this.xAxisTickFhgt_);
            this.yAxisTickFont_ = PanGraphicUtils.getFont(fn, this.yAxisTickFhgt_);
        }
        if (changeAll || pname.contains("xaxis.left") || pname.contains("xaxis.right")) {
            // empty if block
        }
        if (changeAll || pname.contains("xaxis.label.custom") || pname.contains("xaxis.label.text")) {
            this.xaxisLabelText_ = this.pmeta_.getBoolean("xaxis.label.custom") ? this.pmeta_.getString("xaxis.label.text") : null;
        }
    }
}

