/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.plot.PanLonLatPlotMap;
import gov.nasa.giss.panoply.plot.PanLonLatPlotMapColorFill;
import gov.nasa.giss.panoply.plot.PanLonLatPlotTrajectory;
import gov.nasa.giss.panoply.plot.PanLonLatPlotZonal;
import gov.nasa.giss.panoply.plot.PanPlot2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanPlotType;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatPlot
extends PanPlot2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private LLPlotType llPlotType_ = LLPlotType.MAP;
    private PanLonLatPlotMap map_;
    private PanLonLatPlotZonal zonalPlot_;
    private boolean mainKnockout_;

    public PanLonLatPlot(PanPlotMeta pmeta) {
        super(pmeta);
        this.parameterChangedPrivate("all");
    }

    private final void showMap() {
        this.llPlotType_ = LLPlotType.MAP;
        if (this.map_ == null) {
            this.map_ = this.pmeta_.getType() == PanPlotType.LON_LAT ? new PanLonLatPlotMapColorFill(this.pmeta_) : new PanLonLatPlotTrajectory(this.pmeta_);
            this.attach(this.map_);
        }
        if (this.zonalPlot_ != null) {
            this.zonalPlot_.setVisible(false);
        }
        this.placeMap();
        this.map_.setVisible(true);
        this.colorbar_.setVisible(this.pmeta_.getBoolean("include.scale"));
    }

    private final void showZonalAverage() {
        if (!(this.data_ instanceof PanDataLonLat)) {
            return;
        }
        this.llPlotType_ = LLPlotType.ZONAL;
        if (this.zonalPlot_ == null) {
            this.zonalPlot_ = new PanLonLatPlotZonal(this.pmeta_, (PanDataLonLat)this.data_);
            this.attach(this.zonalPlot_);
        }
        if (this.map_ != null) {
            this.map_.setVisible(false);
        }
        this.placeZonalPlot();
        this.zonalPlot_.setVisible(true);
        this.colorbar_.setVisible(false);
    }

    public boolean isMap() {
        return this.llPlotType_ == LLPlotType.MAP;
    }

    public boolean isZoomableMap() {
        return this.isMap() && this.pmeta_.getProjectionMeta().isZoomable();
    }

    public PanLonLatPlotMap getMap() {
        return this.map_;
    }

    public LonLatBounds getLonLatBounds() {
        return this.map_.getLonLatBounds();
    }

    public BufferedImage drawKmlIconImage(boolean knockout, boolean borderVis) {
        boolean knockoutNow = knockout || this.mainKnockout_;
        this.needsDataRedraw_ = true;
        this.refreshMap(knockoutNow);
        BufferedImage img = this.map_.drawKmlIconImage(knockoutNow, borderVis);
        this.needsDataRedraw_ = true;
        this.refreshMap(this.mainKnockout_);
        return img;
    }

    private final void placeMap() {
        if (this.map_ == null) {
            return;
        }
        Rectangle mfBounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.figure");
        Dimension gridSize = (Dimension)this.pmeta_.getLayout().getParam("size.gridding");
        int mw = (mfBounds.width - gridSize.width) / 2;
        int mh = (mfBounds.height - gridSize.height) / 2;
        this.map_.setLocation(mfBounds.x, mfBounds.y);
        this.map_.setSize(mfBounds.width, mfBounds.height);
        this.map_.setMargins(mw, mh, mw, mh);
    }

    private final void placeZonalPlot() {
        if (this.zonalPlot_ == null) {
            return;
        }
        Rectangle mfBounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.figure");
        Rectangle sbounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.scale");
        this.zonalPlot_.setLocation(mfBounds.x, mfBounds.y);
        this.zonalPlot_.setSize(mfBounds.width, mfBounds.height + sbounds.height);
        this.zonalPlot_.setMargins(0);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.map_ != null) {
            this.placeMap();
        }
        if (this.zonalPlot_ != null) {
            this.placeZonalPlot();
        }
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        if (this.isMap()) {
            this.refreshMap(this.mainKnockout_);
            this.colorbar_.setVisible(this.pmeta_.getBoolean("include.scale"));
        } else {
            this.colorbar_.setVisible(false);
        }
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
    }

    private final void refreshMap(boolean knockout) {
        if (this.map_ == null) {
            return;
        }
        if (!(this.data_ instanceof PanDataLonLat)) {
            return;
        }
        if (this.needsDataRedraw_) {
            this.paintDataImage(knockout);
            this.map_.setDataImage(this.dataImage_);
            this.needsRecontour_ = true;
        }
        if (this.map_ instanceof PanLonLatPlotMapColorFill) {
            ContourLevels levels = null;
            if (this.needsRecontour_ && this.contourWeight_ > 0) {
                PanScaleMeta smeta = this.pmeta_.getScaleMeta();
                double[] tvalues = smeta.getContourTickValues();
                this.contours_.setLevelValues(tvalues);
                levels = this.contours_.getLevels();
                if (PanContourLocation.MINOR.matches(this.pmeta_.getString("contour.location"))) {
                    double[] mvalues = smeta.getMajorTickValues();
                    block0: for (ContourLevel level : levels) {
                        double value = level.getValue();
                        level.setLabeled(false);
                        for (int i = 0; i < mvalues.length; ++i) {
                            if (value != mvalues[i]) continue;
                            level.setLabeled(true);
                            continue block0;
                        }
                    }
                }
                ((PanLonLatPlotMapColorFill)this.map_).setContours(levels);
            }
            this.needsRecontour_ = false;
        }
    }

    public PointLL transformXY2LL(int x, int y) {
        if (this.llPlotType_ == LLPlotType.ZONAL) {
            return null;
        }
        if (this.map_ == null) {
            return null;
        }
        return this.map_.transformXY2LL((double)(x - this.map_.getLocation().x) + 0.5, (double)(y - this.map_.getLocation().y) + 0.5);
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        if (this.llPlotType_ == LLPlotType.ZONAL) {
            return null;
        }
        if (this.map_ == null) {
            return null;
        }
        PointLL ll = this.map_.transformXY2LL(x - (double)this.map_.getLocation().x, y - (double)this.map_.getLocation().y);
        if (ll == null) {
            return null;
        }
        return new Point2D.Double(ll.getLon(), ll.getLat());
    }

    @Override
    public String describePoint(int x, int y) {
        PointLL ll = this.transformXY2LL(x, y);
        if (ll == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.map_ instanceof PanLonLatPlotMapColorFill) {
            ((PanDataLonLat)this.data_).describeDataAt(sb, ll);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatPlot panLonLatPlot = this;
        synchronized (panLonLatPlot) {
            if (this.map_ != null) {
                this.map_ = null;
            }
            if (this.zonalPlot_ != null) {
                this.zonalPlot_.flush();
                this.zonalPlot_ = null;
            }
            super.flush();
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        PanPreferences prefs;
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("lonlat.lltype")) {
            if (this.pmeta_.getString("lonlat.lltype").toLowerCase().contains("zonal")) {
                this.showZonalAverage();
            } else {
                this.showMap();
            }
        }
        if (changeAll || pname.contains("lonlat.lltype") || pname.contains("interpolate") || pname.contains("scale.method")) {
            this.needsDataRedraw_ = true;
        }
        if (this.llPlotType_ == LLPlotType.MAP && (pname.contains("lonlat.lltype") || pname.contains("lonlat.proj.name") || pname.contains("lonlat.proj.lon0") || pname.contains("lonlat.proj.lat0") || pname.contains("lonlat.proj.xparam") || pname.contains("scale.method"))) {
            this.needsDataRedraw_ = true;
            this.needsRecontour_ = true;
            this.showMap();
        }
        if ((prefs = PanPreferences.getSharedInstance()).getBoolean("beta:numberlays")) {
            // empty if block
        }
        if (prefs.getBoolean("beta:underlays") && (changeAll || pname.contains("lonlat.underlay.vis") || pname.contains("lonlat.underlay.name") || pname.contains("main.alpha.method") || pname.contains("main.alpha.1") || pname.contains("main.alpha.2") || pname.contains("main.alpha.knockout"))) {
            boolean ulayEnabled = this.pmeta_.getBoolean("lonlat.underlay.vis");
            Object oo = this.pmeta_.get("lonlat.underlay.name");
            LOGGER.trace("meta {}, oo {}", (Object)ulayEnabled, (Object)(oo != null ? 1 : 0));
            this.mainKnockout_ = ulayEnabled && oo != null && this.pmeta_.getBoolean("main.alpha.knockout");
            this.needsDataRedraw_ = true;
        }
    }

    private static enum LLPlotType {
        MAP,
        ZONAL;

    }
}

