/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.TextUtils;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanLinePlot
extends PanPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PanData1D data1D_;
    protected boolean isHorizontal_;
    protected boolean isCompare_;
    protected double lBound_ = -90.0;
    protected double rBound_ = 90.0;
    protected double bBound_;
    protected double tBound_ = 100.0;
    protected double logTop_;
    protected double logBottom_;
    protected double logLeft_;
    protected double logRight_;
    protected PanAxisMethod xaxisMethod_ = PanAxisMethod.SCALAR;
    protected PanAxisMethod yaxisMethod_ = PanAxisMethod.SCALAR;
    protected boolean includesAxes_;
    protected boolean axesOffset_;
    protected float yAxisX_;
    protected float xAxisY_;
    protected Color[] lineColors_ = new Color[2];
    protected BasicStroke[] lineStrokes_ = new BasicStroke[2];
    protected String scaleCaption_;
    protected float sLabelY_;
    protected float sStrokeY_;
    protected Font strokeLabelFont_;
    protected float strokeLabelFhgt_;
    protected boolean[] useCustomStrokeLabel_ = new boolean[2];
    protected String[] userStrokeLabelText_ = new String[2];
    protected boolean useCustomAxisLabel_;
    protected String customAxisLabelText_;

    public PanLinePlot(PanPlotMeta pmeta) {
        super(pmeta);
        this.data1D_ = (PanData1D)pmeta.getData();
        this.isHorizontal_ = this.ptype_ == PanPlotType.HORZ_LINE;
        this.parameterChangedPrivate("all");
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        LOGGER.trace("NOT IMPLEMENTED.");
        return null;
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        this.includesAxes_ = this.pmeta_.getBoolean("include.axes");
        this.axesOffset_ = this.pmeta_.getBoolean("axes.offset");
        Rectangle mfBounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.figure");
        Dimension gsize = (Dimension)this.pmeta_.getLayout().getParam("size.gridding");
        Rectangle sBounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.scale");
        this.gridWidth_ = gsize.width;
        this.gridHeight_ = gsize.height;
        this.gridLeft_ = (float)mfBounds.x + 0.5f * (float)(mfBounds.width - gsize.width);
        this.gridTop_ = mfBounds.y;
        this.gridRight_ = this.gridLeft_ + this.gridWidth_;
        this.gridBottom_ = this.gridTop_ + this.gridHeight_;
        this.tickLengthMajor_ = Math.max(4.0f, scaling * 6.0f);
        this.tickLengthMinor_ = Math.max(2.0f, scaling * 3.0f);
        this.tickLabelOffset_ = Math.max(2.0f, scaling * 3.0f);
        int tickWeight = PanUtils.min0max(200, this.pmeta_.getInt("axes.tickmark.weight"));
        this.tickStroke_ = this.axesOffset_ ? this.borderStroke_ : PanGraphicUtils.tickStroke((int)(0.01 * (double)tickWeight * (double)sfactor));
        this.yAxisX_ = this.axesOffset_ ? this.gridLeft_ - this.tickLengthMajor_ : this.gridLeft_;
        this.xAxisY_ = this.axesOffset_ ? this.gridBottom_ + this.tickLengthMajor_ : this.gridBottom_;
        this.sLabelY_ = (float)sBounds.y + 0.5f * (float)sBounds.height;
        this.sStrokeY_ = this.sLabelY_ - 0.4f * this.strokeLabelFhgt_;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        GraphicUtils.drawRect(g2d, this.gridLeft_, this.gridTop_, this.gridWidth_, this.gridHeight_);
        this.drawXAxis(g2d);
        if (this.includesAxes_) {
            this.drawXAxisLabel(g2d);
        }
        int maxLabelWidth = this.drawYAxis(g2d);
        if (this.includesAxes_) {
            this.drawYAxisLabel(g2d, maxLabelWidth);
        }
        this.drawCurve(g2d);
        if (this.pmeta_.getBoolean("include.scale")) {
            this.drawCurveLabels(g2d);
        }
        g2d.dispose();
        this.needsDataRedraw_ = false;
    }

    protected abstract void drawXAxis(Graphics2D var1);

    protected abstract String getXAxisLabel();

    protected int drawXAxisTickLabel(Graphics2D g2d, Object label, float tickX) {
        if (!this.includesAxes_) {
            return 0;
        }
        if (!(label instanceof String) && !(label instanceof AttributedString)) {
            return 0;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisTickFont_);
        float labelWidth = GraphicUtils.getStringWidth(g2d, label);
        float x = tickX - 0.5f * labelWidth;
        float y = this.xAxisY_ + 1.5f * this.tickLabelOffset_ + this.xAxisTickFhgt_;
        if (label instanceof String) {
            g2d.drawString((String)label, x, y);
        } else {
            GraphicUtils.drawAttributedString(g2d, (AttributedString)label, x, y);
        }
        return Math.round(labelWidth);
    }

    protected void drawXAxisLabel(Graphics2D g2d) {
        if (!this.includesAxes_) {
            return;
        }
        String label = this.getXAxisLabel();
        if (label == null || label.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisLabelFont_);
        FontMetrics fm = g2d.getFontMetrics();
        label = TextUtils.trimStringToFit(label, fm, this.gridWidth_);
        int labelWidth = fm.stringWidth(label);
        float x = this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)labelWidth);
        float y = this.xAxisY_ + this.tickLabelOffset_ + this.xAxisTickFhgt_ + 0.33f * this.xAxisTickFhgt_ + this.xAxisLabelFhgt_;
        g2d.drawString(label, x, y);
    }

    protected abstract int drawYAxis(Graphics2D var1);

    protected abstract String getYAxisLabel();

    protected int drawYAxisTickLabel(Graphics2D g2d, Object label, float tickY) {
        if (!this.includesAxes_) {
            return 0;
        }
        if (!(label instanceof String) && !(label instanceof AttributedString)) {
            return 0;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.yAxisTickFont_);
        float labelWidth = GraphicUtils.getStringWidth(g2d, label);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - labelWidth;
        float y = tickY + 0.5f * this.yAxisTickFhgt_ - 1.0f;
        if (label instanceof String) {
            g2d.drawString((String)label, x, y);
        } else {
            GraphicUtils.drawAttributedString(g2d, (AttributedString)label, x, y);
        }
        return Math.round(labelWidth);
    }

    protected void drawYAxisLabel(Graphics2D g2d, int maxLabelWidth) {
        if (!this.includesAxes_) {
            return;
        }
        String label = this.getYAxisLabel();
        if (label == null || label.isEmpty()) {
            return;
        }
        g2d.setFont(this.yAxisLabelFont_);
        g2d.setColor(this.getForeground());
        FontMetrics fm = g2d.getFontMetrics();
        label = TextUtils.trimStringToFit(label, fm, this.gridHeight_);
        int labelWidth = fm.stringWidth(label);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - (float)maxLabelWidth - 0.67f * this.yAxisTickFhgt_;
        float y = this.gridBottom_ - 0.5f * (this.gridHeight_ - (float)labelWidth);
        g2d.translate(x, y);
        g2d.rotate(-1.5707963267948966);
        g2d.drawString(label, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-x, -y);
    }

    protected abstract void drawCurve(Graphics2D var1);

    protected void drawCurveLabels(Graphics2D g2d) {
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        int strokeLength = (int)(scaling * 20.0f);
        int lspace = (int)(scaling * 24.0f);
        g2d.setFont(this.strokeLabelFont_);
        FontMetrics fm = g2d.getFontMetrics();
        String[] labels = new String[2];
        if (this.isCompare_) {
            String label1 = this.useCustomStrokeLabel_[0] ? this.userStrokeLabelText_[0] : this.data1D_.getVarShortName(0);
            String label2 = this.useCustomStrokeLabel_[1] ? this.userStrokeLabelText_[1] : this.data1D_.getVarShortName(1);
            int maxLWidth = (int)(0.5f * (this.gridWidth_ - 2.0f * (float)lspace));
            int maxTWidth = (int)(0.5f * (this.gridWidth_ - 2.0f * (float)lspace) - (float)lspace);
            label1 = TextUtils.trimStringToFit(label1, fm, maxTWidth);
            label2 = TextUtils.trimStringToFit(label2, fm, maxTWidth);
            int twidth1 = Math.min(maxTWidth, fm.stringWidth(label1));
            int twidth2 = Math.min(maxTWidth, fm.stringWidth(label2));
            int left1 = (int)(this.gridLeft_ + 0.5f * (float)(maxLWidth - twidth1));
            int left2 = (int)(this.gridLeft_ + (float)maxLWidth + (float)lspace + 0.5f * (float)(maxLWidth - twidth2));
            if (label1.length() > 0 && this.lineStrokes_[0] != null) {
                g2d.setColor(this.lineColors_[0]);
                g2d.setStroke(this.lineStrokes_[0]);
                GraphicUtils.drawLine(g2d, left1, this.sStrokeY_, left1 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                g2d.drawString(label1, left1 + lspace, (int)this.sLabelY_);
            }
            if (label2.length() > 0 && this.lineStrokes_[1] != null) {
                g2d.setColor(this.lineColors_[1]);
                g2d.setStroke(this.lineStrokes_[1]);
                GraphicUtils.drawLine(g2d, left2, this.sStrokeY_, left2 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                g2d.drawString(label2, left2 + lspace, (int)this.sLabelY_);
            }
        } else {
            String label1;
            String string = label1 = this.useCustomStrokeLabel_[0] ? this.userStrokeLabelText_[0] : this.data1D_.getDescription();
            if (label1.length() > 0 && this.lineStrokes_[0] != null) {
                int maxTWidth = (int)(0.75f * this.gridWidth_ - (float)lspace);
                label1 = TextUtils.trimStringToFit(label1, fm, maxTWidth);
                int tlength = Math.min(maxTWidth, fm.stringWidth(label1));
                int totWidth = lspace + tlength;
                int left1 = (int)(this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)totWidth));
                g2d.setColor(this.lineColors_[0]);
                g2d.setStroke(this.lineStrokes_[0]);
                GraphicUtils.drawLine(g2d, left1, this.sStrokeY_, left1 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                g2d.drawString(label1, left1 + lspace, (int)this.sLabelY_);
            }
        }
    }

    @Override
    public String getExtremaDescription() {
        return "";
    }

    @Override
    public String describePoint(int x, int y) {
        LOGGER.trace("NOT IMPLEMENTED.");
        return null;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        int minor;
        String method;
        String fn;
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        if (changeAll || pname.contains("combination")) {
            String ctype = this.pmeta_.getString("combination");
            this.isCompare_ = PanCombinationType.COMPARE.matches(ctype);
        }
        if (changeAll || pname.contains(PanParameterKeys.STROKE_COLOR[0]) || pname.contains(PanParameterKeys.STROKE_STYLE[0]) || pname.contains(PanParameterKeys.STROKE_WEIGHT[0])) {
            this.lineColors_[0] = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[0]);
            this.lineStrokes_[0] = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[0]), this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[0]), sfactor);
        }
        if (changeAll || pname.contains(PanParameterKeys.STROKE_COLOR[1]) || pname.contains(PanParameterKeys.STROKE_STYLE[1]) || pname.contains(PanParameterKeys.STROKE_WEIGHT[1])) {
            this.lineColors_[1] = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[1]);
            this.lineStrokes_[1] = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[1]), this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[1]), sfactor);
        }
        if (changeAll || pname.contains(PanParameterKeys.STROKE_LABEL_CUSTOM[0]) || pname.contains(PanParameterKeys.STROKE_LABEL_CUSTOM[1]) || pname.contains(PanParameterKeys.STROKE_LABEL_TEXT[0]) || pname.contains(PanParameterKeys.STROKE_LABEL_TEXT[1])) {
            this.useCustomStrokeLabel_[0] = this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0]);
            this.useCustomStrokeLabel_[1] = this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1]);
            this.userStrokeLabelText_[0] = this.pmeta_.getString(PanParameterKeys.STROKE_LABEL_TEXT[0]);
            this.userStrokeLabelText_[1] = this.pmeta_.getString(PanParameterKeys.STROKE_LABEL_TEXT[1]);
        }
        if (changeAll || pname.contains("grid.style") || pname.contains("grid.weight") || pname.contains("color.background")) {
            this.gridColor_ = this.getForeground();
            this.gridWeight_ = PanUtils.min0max(200, this.pmeta_.getInt("grid.weight"));
            String gs = this.pmeta_.getString("grid.style");
            this.gridStroke_ = this.gridWeight_ > 0 ? PanGraphicUtils.buttMiterStroke(gs, this.gridWeight_, sfactor) : null;
            int borderWgt = Math.max(75, this.gridWeight_);
            this.borderStroke_ = PanGraphicUtils.solidStroke(borderWgt, sfactor);
        }
        if (changeAll || pname.contains("interpolate") || pname.contains("scale.method")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("scale.div.major") || pname.contains("scale.div.minor") || pname.contains("scale.tick.format")) {
            // empty if block
        }
        if (changeAll || pname.contains("font.master") || pname.contains("size.factor") || pname.contains("stroke.label.size")) {
            fn = this.pmeta_.getString("font.master");
            this.strokeLabelFhgt_ = scaling * this.pmeta_.getFloat("stroke.label.size");
            this.strokeLabelFont_ = PanGraphicUtils.getFont(fn, this.strokeLabelFhgt_);
        }
        if (changeAll || pname.contains("font.master") || pname.contains("size.factor") || pname.contains("xaxis.label.size") || pname.contains("yaxis.label.size") || pname.contains("xaxis.tick.size") || pname.contains("yaxis.tick.size") || pname.contains("scale.tick.size") || pname.contains("scale.label.size")) {
            fn = this.pmeta_.getString("font.master");
            if (this.isHorizontal_) {
                this.xAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("xaxis.label.size");
                this.xAxisTickFhgt_ = scaling * this.pmeta_.getFloat("xaxis.tick.size");
                this.yAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("scale.label.size");
                this.yAxisTickFhgt_ = scaling * this.pmeta_.getFloat("scale.tick.size");
            } else {
                this.xAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("scale.label.size");
                this.xAxisTickFhgt_ = scaling * this.pmeta_.getFloat("scale.tick.size");
                this.yAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("yaxis.label.size");
                this.yAxisTickFhgt_ = scaling * this.pmeta_.getFloat("yaxis.tick.size");
            }
            this.xAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.xAxisLabelFhgt_);
            this.yAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.yAxisLabelFhgt_);
            this.xAxisTickFont_ = PanGraphicUtils.getFont(fn, this.xAxisTickFhgt_);
            this.yAxisTickFont_ = PanGraphicUtils.getFont(fn, this.yAxisTickFhgt_);
        }
        if (changeAll || pname.contains("scale.label.custom") || pname.contains("scale.label.text") || pname.contains("scale.units") || pname.contains("xaxis.units") || pname.contains("yaxis.units")) {
            this.scaleCaption_ = this.pmeta_.getBoolean("scale.label.custom") ? this.pmeta_.getString("scale.label.text") : this.data_.getDescription();
        }
        if (changeAll || pname.contains("xaxis.left") || pname.contains("xaxis.right") || pname.contains("xaxis.method") || pname.contains("xaxis.units")) {
            this.lBound_ = this.pmeta_.getDouble("xaxis.left");
            this.rBound_ = this.pmeta_.getDouble("xaxis.right");
            method = this.pmeta_.getString("xaxis.method");
            this.xaxisMethod_ = PanAxisMethod.matching(method);
            if (this.xaxisMethod_ == PanAxisMethod.LOG10) {
                this.logLeft_ = Math.log10(this.lBound_);
                this.logRight_ = Math.log10(this.rBound_);
            } else {
                this.logLeft_ = 0.0;
                this.logRight_ = 0.0;
            }
            this.data1D_.setAxisBounds(this.lBound_, this.rBound_);
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("yaxis.bottom") || pname.contains("yaxis.top") || pname.contains("yaxis.method") || pname.contains("yaxis.units")) {
            this.bBound_ = this.pmeta_.getDouble("yaxis.bottom");
            this.tBound_ = this.pmeta_.getDouble("yaxis.top");
            method = this.pmeta_.getString("yaxis.method");
            this.yaxisMethod_ = PanAxisMethod.matching(method);
            if (this.yaxisMethod_ == PanAxisMethod.LOG10) {
                this.logTop_ = Math.log10(this.tBound_);
                this.logBottom_ = Math.log10(this.bBound_);
            } else {
                this.logTop_ = 0.0;
                this.logBottom_ = 0.0;
            }
            this.data1D_.setAxisBounds(this.bBound_, this.tBound_);
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("xaxis.div.major") || pname.contains("xaxis.div.minor")) {
            int major = this.pmeta_.getInt("xaxis.div.major");
            minor = this.pmeta_.getInt("xaxis.div.minor");
            major = Math.min(major, 25);
            major = Math.max(major, 1);
            minor = Math.min(minor, 25);
            minor = Math.max(minor, 1);
            this.xMajorDiv_ = major;
            this.xMinorDiv_ = minor;
        }
        if (changeAll || pname.contains("yaxis.div.major") || pname.contains("yaxis.div.minor")) {
            int major = this.pmeta_.getInt("yaxis.div.major");
            minor = this.pmeta_.getInt("yaxis.div.minor");
            major = Math.min(major, 25);
            major = Math.max(major, 1);
            minor = Math.min(minor, 25);
            minor = Math.max(minor, 1);
            this.yMajorDiv_ = major;
            this.yMinorDiv_ = minor;
        }
        if (changeAll || pname.contains("xaxis.label.custom") || pname.contains("xaxis.label.text")) {
            this.xaxisLabelText_ = this.pmeta_.getBoolean("xaxis.label.custom") ? this.pmeta_.getString("xaxis.label.text") : null;
        }
        if (changeAll || pname.contains("yaxis.label.custom") || pname.contains("yaxis.label.text")) {
            this.yaxisLabelText_ = this.pmeta_.getBoolean("yaxis.label.custom") ? this.pmeta_.getString("yaxis.label.text") : null;
        }
    }
}

