/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.data.ContourLine;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.TextUtils;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.plot.PanPlot2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanGeneral2DPlot
extends PanPlot2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final float HALF_PI = 1.5707964f;
    protected static final float RAD_0 = 0.0f;
    protected static final float RAD_90 = 1.5707964f;
    protected static final float RAD_135 = 2.3561945f;
    protected static final float RAD_180 = (float)Math.PI;
    protected static final float RAD_270 = 4.712389f;
    protected PrintfFormat scaleFormatter_ = new PrintfFormat("%G");
    protected PrintfFormat xAxisFormatter_ = new PrintfFormat("%.1f");
    protected PrintfFormat yAxisFormatter_ = new PrintfFormat("%.1f");
    protected ContourLevels contourLevels_;
    protected BasicStroke contourStrokeSolid_;
    protected BasicStroke contourStrokeDotted_;
    protected Font contourFont_;
    protected PanVectorStyle vectorStyle_;
    protected int vectorWeight_;
    protected Color vectorColor_;
    protected BasicStroke vectorStroke_;
    protected Color tickColor_ = Color.BLACK;
    protected PanData2D data2D_;
    protected boolean includeAxes_;
    protected boolean axesOffset_;
    protected float yAxisX_;
    protected float xAxisY_;

    public PanGeneral2DPlot(PanPlotMeta pmeta) {
        super(pmeta);
        this.data2D_ = (PanData2D)pmeta.getData();
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        this.includeAxes_ = this.pmeta_.getBoolean("include.axes");
        this.axesOffset_ = this.pmeta_.getBoolean("axes.offset");
        Rectangle mfBounds = (Rectangle)this.pmeta_.getLayout().getParam("bounds.figure");
        Dimension gsize = (Dimension)this.pmeta_.getLayout().getParam("size.gridding");
        this.gridWidth_ = gsize.width;
        this.gridHeight_ = gsize.height;
        this.gridLeft_ = (float)mfBounds.x + 0.5f * (float)(mfBounds.width - gsize.width);
        this.gridTop_ = mfBounds.y;
        this.gridRight_ = this.gridLeft_ + this.gridWidth_;
        this.gridBottom_ = this.gridTop_ + this.gridHeight_;
        this.tickLengthMajor_ = Math.max(4.0f, scaling * 6.0f);
        this.tickLengthMinor_ = Math.max(2.0f, scaling * 3.0f);
        this.tickLabelOffset_ = Math.max(2.0f, scaling * 2.0f);
        if (this.axesOffset_ && this.includeAxes_) {
            this.tickStroke_ = this.borderStroke_;
        } else {
            int tickWeight = PanUtils.min0max(200, this.pmeta_.getInt("axes.tickmark.weight"));
            this.tickStroke_ = PanGraphicUtils.tickStroke((int)(0.01 * (double)sfactor * (double)tickWeight));
        }
        this.tickColor_ = PanAxisTickColor.GRID.matches(this.pmeta_.getString("axes.tickmark.color")) ? this.gridColor_ : this.getForeground();
        this.yAxisX_ = this.axesOffset_ ? this.gridLeft_ - this.tickLengthMajor_ : this.gridLeft_;
        this.xAxisY_ = this.axesOffset_ ? this.gridBottom_ + this.tickLengthMajor_ : this.gridBottom_;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        if (this.needsDataRedraw_) {
            this.paintDataImage(false);
            this.needsRecontour_ = true;
        }
        g2d.translate(this.gridLeft_, this.gridTop_);
        if (printing) {
            this.drawDataVectorized(g2d);
        } else {
            g2d.drawImage((Image)this.dataImage_, 0, 0, this);
        }
        g2d.translate(-this.gridLeft_, -this.gridTop_);
        this.drawGrid(g2d);
        this.drawContours(g2d);
        if (this.pmeta_.getType().supportsVectorPlots() && this.vectorWeight_ > 0 && this.vectorStyle_ != PanVectorStyle.NONE) {
            this.drawVectors(g2d);
        }
        g2d.dispose();
    }

    private final void drawGrid(Graphics2D g2d) {
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        GraphicUtils.drawRect(g2d, this.gridLeft_, this.gridTop_, this.gridWidth_, this.gridHeight_);
        this.drawXAxis(g2d);
        this.drawYAxis(g2d);
    }

    protected void drawXAxis(Graphics2D g2d) {
        if (this.axesOffset_ && this.includeAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.gridLeft_, this.xAxisY_, this.gridRight_, this.xAxisY_);
        }
        PanAxisMethod axmethod = ((PanDataGeneral2D)this.data_).getXAxisMethod();
        switch (axmethod) {
            case LOG10: {
                this.drawLogXAxisTicks(g2d);
                break;
            }
            default: {
                this.drawScalarXAxisTicks(g2d);
            }
        }
        if (this.includeAxes_) {
            this.drawXAxisLabel(g2d);
        }
    }

    protected void drawScalarXAxisTicks(Graphics2D g2d) {
        double lBound = this.pmeta_.getDouble("xaxis.left");
        double rBound = this.pmeta_.getDouble("xaxis.right");
        int divs = this.xMajorDiv_ * this.xMinorDiv_;
        float invDivs = 1.0f / (float)divs;
        double delta = (rBound - lBound) * (double)invDivs;
        for (int i = 0; i <= divs; ++i) {
            float tt;
            boolean isMajor;
            float x = this.gridLeft_ + this.gridWidth_ * (float)i * invDivs;
            boolean isNearEdge = Math.abs(x - this.gridLeft_) < EDGE_TOLERANCE || Math.abs(x - this.gridRight_) < EDGE_TOLERANCE;
            boolean bl = isMajor = i % this.xMinorDiv_ == 0;
            if (isMajor) {
                double axisVal = lBound + delta * (double)i;
                String label = this.getXAxisTickLabel(axisVal);
                this.drawXAxisTickLabel(g2d, label, x);
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridBottom_);
                }
            }
            float f = tt = isMajor ? this.tickLengthMajor_ : this.tickLengthMinor_;
            if (this.axesOffset_ && this.includeAxes_) {
                g2d.setColor(this.getForeground());
                g2d.setStroke(this.tickStroke_);
                GraphicUtils.drawLine(g2d, x, this.xAxisY_ + 0.5f * tt, x, this.xAxisY_ - 0.5f * tt);
                continue;
            }
            if (isNearEdge) continue;
            g2d.setColor(this.tickColor_);
            g2d.setStroke(this.tickStroke_);
            GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridTop_ + tt);
            GraphicUtils.drawLine(g2d, x, this.gridBottom_, x, this.gridBottom_ - tt);
        }
    }

    protected void drawLogXAxisTicks(Graphics2D g2d) {
        double lBound = this.pmeta_.getDouble("xaxis.left");
        double rBound = this.pmeta_.getDouble("xaxis.right");
        double logleft = Math.log10(lBound);
        double logright = Math.log10(rBound);
        double logrange = logright - logleft;
        double logmin = Math.min(logleft, logright);
        double logmax = Math.max(logleft, logright);
        int iMin = (int)Math.floor(logmin) - 1;
        int iMax = (int)Math.floor(logmax) + 1;
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        boolean majorMarked = false;
        block0: for (int j = iMin; j <= iMax; ++j) {
            double value0 = Math.pow(10.0, j);
            for (int k = 0; k < 9; ++k) {
                float tt;
                boolean isNearEdge;
                double value;
                double logval;
                if (k > 0 && intDiv > 20 || (logval = Math.log10(value = value0 * (1.0 + (double)k))) < logmin) continue;
                if (logval > logmax) continue block0;
                float pct = (float)((logval - logleft) / logrange);
                float x = this.gridLeft_ + pct * this.gridWidth_;
                if (x < this.gridLeft_ || x > this.gridRight_) continue;
                boolean bl = isNearEdge = Math.abs(x - this.gridLeft_) < EDGE_TOLERANCE || Math.abs(x - this.gridRight_) < EDGE_TOLERANCE;
                if (k == 0 && j % intStep == 0) {
                    String label = this.getXAxisTickLabel(Math.pow(10.0, j));
                    this.drawXAxisTickLabel(g2d, label, x);
                    if (this.gridStroke_ != null && !isNearEdge) {
                        g2d.setColor(this.gridColor_);
                        g2d.setStroke(this.gridStroke_);
                        GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridBottom_);
                    }
                    majorMarked = true;
                }
                if (isNearEdge) continue;
                float f = tt = k == 0 ? this.tickLengthMajor_ : this.tickLengthMinor_;
                if (this.axesOffset_ && this.includeAxes_) {
                    g2d.setColor(this.getForeground());
                    g2d.setStroke(this.tickStroke_);
                    GraphicUtils.drawLine(g2d, x, this.xAxisY_ + 0.5f * tt, x, this.xAxisY_ - 0.5f * tt);
                    continue;
                }
                if (isNearEdge) continue;
                g2d.setColor(this.tickColor_);
                g2d.setStroke(this.tickStroke_);
                GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridTop_ + tt);
                GraphicUtils.drawLine(g2d, x, this.gridBottom_, x, this.gridBottom_ - tt);
            }
        }
        if (!majorMarked) {
            if (this.axesOffset_ && this.includeAxes_) {
                g2d.setColor(this.getForeground());
                g2d.setStroke(this.tickStroke_);
                float tt = this.tickLengthMinor_;
                GraphicUtils.drawLine(g2d, this.gridLeft_, this.xAxisY_ + 0.5f * tt, this.gridLeft_, this.xAxisY_ - 0.5f * tt);
                GraphicUtils.drawLine(g2d, this.gridRight_, this.xAxisY_ + 0.5f * tt, this.gridRight_, this.xAxisY_ - 0.5f * tt);
            }
            if (this.includeAxes_) {
                String label1 = this.getXAxisTickLabel(lBound);
                String label2 = this.getXAxisTickLabel(rBound);
                this.drawXAxisTickLabel(g2d, label1, this.gridLeft_ + 0.0f);
                this.drawXAxisTickLabel(g2d, label2, this.gridRight_);
            }
        }
    }

    protected String getXAxisTickLabel(double val) {
        return this.xAxisFormatter_.sprintg(val);
    }

    protected int drawXAxisTickLabel(Graphics2D g2d, String label, float tickX) {
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        int labelWidth = fm.stringWidth(label);
        float x = tickX - 0.5f * (float)labelWidth;
        float y = this.xAxisY_ + 1.5f * this.tickLabelOffset_ + this.xAxisTickFhgt_;
        g2d.drawString(label, x, y);
        return labelWidth;
    }

    protected void drawXAxisLabel(Graphics2D g2d) {
        if (!this.includeAxes_) {
            return;
        }
        String label = this.getXAxisLabel();
        if (label == null || label.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisLabelFont_);
        FontMetrics fm = g2d.getFontMetrics();
        label = TextUtils.trimStringToFit(label, fm, this.gridWidth_);
        int labelWidth = fm.stringWidth(label);
        float x = this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)labelWidth);
        float y = this.xAxisY_ + this.tickLabelOffset_ + this.xAxisTickFhgt_ + 0.33f * this.xAxisTickFhgt_ + this.xAxisLabelFhgt_;
        g2d.drawString(label, x, y);
    }

    protected String getXAxisLabel() {
        if (this.xaxisLabelText_ != null) {
            return this.xaxisLabelText_;
        }
        PanAxisMethod method = ((PanDataGeneral2D)this.data_).getXAxisMethod();
        if (method == PanAxisMethod.INDEX) {
            return this.data2D_.getXAxisName() + " (grid index)";
        }
        return this.data2D_.getXAxisLabel();
    }

    protected void drawYAxis(Graphics2D g2d) {
        if (this.axesOffset_ && this.includeAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.yAxisX_, this.gridTop_, this.yAxisX_, this.gridBottom_);
        }
        PanAxisMethod axmethod = ((PanDataGeneral2D)this.data_).getYAxisMethod();
        int maxLabelWidth = 0;
        switch (axmethod) {
            case LOG10: {
                maxLabelWidth = this.drawLogYAxisTicks(g2d);
                break;
            }
            default: {
                maxLabelWidth = this.drawScalarYAxisTicks(g2d);
            }
        }
        this.drawYAxisLabel(g2d, maxLabelWidth);
    }

    protected int drawScalarYAxisTicks(Graphics2D g2d) {
        int maxLabelWidth = 0;
        double tBound = this.pmeta_.getDouble("yaxis.top");
        double bBound = this.pmeta_.getDouble("yaxis.bottom");
        int divs = this.yMajorDiv_ * this.yMinorDiv_;
        float invDivs = 1.0f / (float)divs;
        double delta = (tBound - bBound) * (double)invDivs;
        for (int i = 0; i <= divs; ++i) {
            float tt;
            boolean isMajor;
            float y = this.gridBottom_ - this.gridHeight_ * (float)i * invDivs;
            boolean isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
            boolean bl = isMajor = i % this.yMinorDiv_ == 0;
            if (isMajor) {
                double axisVal = bBound + (double)i * delta;
                String label = this.getYAxisTickLabel(axisVal);
                int labelWidth = this.drawYAxisTickLabel(g2d, label, y);
                maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                }
            }
            float f = tt = isMajor ? this.tickLengthMajor_ : this.tickLengthMinor_;
            if (this.axesOffset_ && this.includeAxes_) {
                g2d.setColor(this.getForeground());
                g2d.setStroke(this.tickStroke_);
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                continue;
            }
            if (isNearEdge) continue;
            g2d.setColor(this.tickColor_);
            g2d.setStroke(this.tickStroke_);
            GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
            GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
        }
        return maxLabelWidth;
    }

    protected int drawLogYAxisTicks(Graphics2D g2d) {
        int maxLabelWidth = 0;
        double tBound = this.pmeta_.getDouble("yaxis.top");
        double bBound = this.pmeta_.getDouble("yaxis.bottom");
        double logtop = Math.log10(tBound);
        double logbottom = Math.log10(bBound);
        double logrange = logtop - logbottom;
        double logmin = Math.min(logtop, logbottom);
        double logmax = Math.max(logtop, logbottom);
        int iMin = (int)Math.floor(logmin) - 1;
        int iMax = (int)Math.floor(logmax) + 1;
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        boolean majorMarked = false;
        block0: for (int j = iMin; j <= iMax; ++j) {
            double value0 = Math.pow(10.0, j);
            for (int k = 0; k < 9; ++k) {
                float tt;
                boolean isNearEdge;
                double value;
                double logval;
                if (k > 0 && intDiv > 20 || (logval = Math.log10(value = value0 * (1.0 + (double)k))) < logmin) continue;
                if (logval > logmax) continue block0;
                float pct = (float)((logval - logbottom) / logrange);
                float y = this.gridBottom_ - pct * this.gridHeight_;
                boolean bl = isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
                if (k == 0 && j % intStep == 0) {
                    String label = this.getYAxisTickLabel(Math.pow(10.0, j));
                    int labelWidth = this.drawYAxisTickLabel(g2d, label, y);
                    maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                    if (this.gridStroke_ != null && !isNearEdge) {
                        g2d.setColor(this.gridColor_);
                        g2d.setStroke(this.gridStroke_);
                        GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                    }
                    majorMarked = true;
                }
                float f = tt = k == 0 ? this.tickLengthMajor_ : this.tickLengthMinor_;
                if (this.axesOffset_ && this.includeAxes_) {
                    g2d.setColor(this.getForeground());
                    g2d.setStroke(this.tickStroke_);
                    GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                    continue;
                }
                if (isNearEdge) continue;
                g2d.setColor(this.tickColor_);
                g2d.setStroke(this.tickStroke_);
                GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
                GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
            }
        }
        if (!majorMarked) {
            g2d.setColor(this.tickColor_);
            g2d.setStroke(this.tickStroke_);
            if (this.includeAxes_) {
                String label1 = this.getYAxisTickLabel(tBound);
                String label2 = this.getYAxisTickLabel(bBound);
                int label1Width = this.drawYAxisTickLabel(g2d, label1, this.gridTop_);
                int label2Width = this.drawYAxisTickLabel(g2d, label2, this.gridBottom_);
                maxLabelWidth = Math.max(maxLabelWidth, label1Width);
                maxLabelWidth = Math.max(maxLabelWidth, label2Width);
            }
        }
        return maxLabelWidth;
    }

    protected String getYAxisTickLabel(double val) {
        return this.yAxisFormatter_.sprintg(val);
    }

    protected int drawYAxisTickLabel(Graphics2D g2d, String label, float tickY) {
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.yAxisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        int labelWidth = fm.stringWidth(label);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - (float)labelWidth;
        float y = tickY + 0.5f * this.yAxisTickFhgt_ - 1.0f;
        g2d.drawString(label, x, y);
        return labelWidth;
    }

    protected void drawYAxisLabel(Graphics2D g2d, int maxLabelWidth) {
        if (!this.includeAxes_) {
            return;
        }
        String label = this.getYAxisLabel();
        if (label == null || label.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.yAxisLabelFont_);
        FontMetrics fm = g2d.getFontMetrics();
        label = TextUtils.trimStringToFit(label, fm, this.gridHeight_);
        int labelWidth = fm.stringWidth(label);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - (float)maxLabelWidth - 0.67f * this.yAxisTickFhgt_;
        float y = this.gridBottom_ - 0.5f * (this.gridHeight_ - (float)labelWidth);
        g2d.translate(x, y);
        g2d.rotate(-1.5707963267948966);
        g2d.drawString(label, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-x, -y);
    }

    protected String getYAxisLabel() {
        if (this.yaxisLabelText_ != null) {
            return this.yaxisLabelText_;
        }
        PanAxisMethod method = ((PanDataGeneral2D)this.data_).getYAxisMethod();
        if (method == PanAxisMethod.INDEX) {
            return this.data2D_.getYAxisName() + " (grid index)";
        }
        return this.data2D_.getYAxisLabel();
    }

    private final void drawDataVectorized(Graphics2D g2d) {
        int ww = this.dataImage_.getWidth();
        int hh = this.dataImage_.getHeight();
        int[] pixels = this.dataImage_.getRGB(0, 0, ww, hh, null, 0, ww);
        g2d.setStroke(GraphicUtils.squareMiterStroke(5));
        ArrayList<ColorArea> areas = new ArrayList<ColorArea>(2500);
        for (int row = 0; row < hh; ++row) {
            int rowOffset = row * ww;
            int first = 0;
            for (int col = 1; col < ww - 1; ++col) {
                int offset = rowOffset + col;
                if (pixels[offset] == pixels[rowOffset + first]) continue;
                Rectangle2D.Float area = new Rectangle2D.Float(first, row, col - first, 1.0f);
                areas.add(new ColorArea(pixels[rowOffset + first], new Area(area)));
                first = col;
            }
            Rectangle2D.Float area = new Rectangle2D.Float(first, row, ww - 1 - first, 1.0f);
            areas.add(new ColorArea(pixels[rowOffset + first], new Area(area)));
            if (areas.size() <= 2400) continue;
            this.drawAreaVectorized(g2d, areas);
            areas.clear();
        }
        this.drawAreaVectorized(g2d, areas);
    }

    private final void drawAreaVectorized(Graphics2D g2d, ArrayList<ColorArea> areas) {
        while (!areas.isEmpty()) {
            ColorArea carea = areas.remove(areas.size() - 1);
            int colorval = carea.colorval_;
            Area area = carea.area_;
            for (int i = areas.size() - 1; i >= 0; --i) {
                carea = areas.get(i);
                if (carea.colorval_ != colorval) continue;
                area.add(carea.area_);
                areas.remove(i);
            }
            g2d.setColor(new Color(colorval));
            g2d.fill(area);
            g2d.draw(area);
        }
    }

    protected void drawVectors(Graphics2D g2d) {
        if (this.vectorWeight_ < 1) {
            return;
        }
        if (this.vectorStyle_ == PanVectorStyle.NONE) {
            return;
        }
        double referenceVal = this.pmeta_.getDouble("vector.refvalue");
        if (referenceVal <= 0.0) {
            return;
        }
        Color color = this.vectorColor_;
        BasicStroke stroke = this.vectorStroke_;
        g2d.setColor(color);
        g2d.setStroke(stroke);
        int vlength = (Integer)this.pmeta_.getLayout().getParam("vector.length");
        double spacePct = 0.01 * (double)this.pmeta_.getInt("vector.spacing");
        int spacing = (int)((double)vlength * spacePct);
        Object[] baseAngleData = this.getXYVectorBaseAngle();
        if (baseAngleData == null) {
            LOGGER.trace("getXYVectorBaseAngle returned null");
            return;
        }
        double baseAngleRad = (Double)baseAngleData[0];
        boolean counterclockwise = (Boolean)baseAngleData[1];
        GeneralPath arrow = new GeneralPath();
        int xstart = (int)(0.5f * this.gridWidth_ - (float)spacing * (0.5f * this.gridWidth_ / (float)spacing));
        int ystart = (int)(0.5f * this.gridHeight_ - (float)spacing * (0.5f * this.gridHeight_ / (float)spacing));
        g2d.translate(this.gridLeft_, this.gridTop_);
        int y = ystart;
        while ((float)y < this.gridHeight_) {
            if (y >= 0) {
                float yorig = (float)y + 0.5f;
                int x = xstart;
                while ((float)x < this.gridWidth_) {
                    if (x >= 0) {
                        double angleRad;
                        float factor;
                        float length;
                        float xorig = (float)x + 0.5f;
                        double mag = this.data2D_.valueAt(x, y);
                        if (!Double.isNaN(mag) && (double)(length = (float)vlength * (factor = (float)(mag / referenceVal))) != 0.0 && !Double.isNaN(angleRad = this.data2D_.angleRadAt(x, y))) {
                            angleRad = counterclockwise ? baseAngleRad - angleRad : baseAngleRad + angleRad;
                            if (this.vectorStyle_ == PanVectorStyle.UPDOT) {
                                double radius = Math.sqrt(0.2 * (double)length);
                                if (radius < 1.0) {
                                    radius = 1.0;
                                }
                                g2d.fill(new Ellipse2D.Double((double)xorig - radius, (double)yorig - radius, radius * 2.0, radius * 2.0));
                            }
                            float xtip = (float)((double)xorig + (double)length * Math.sin(angleRad));
                            float ytip = (float)((double)yorig - (double)length * Math.cos(angleRad));
                            if (xtip < 0.0f || ytip < 0.0f || xtip > this.gridWidth_ || ytip > this.gridHeight_) {
                                float xmin = xorig;
                                float ymin = yorig;
                                float xmax = xtip;
                                float ymax = ytip;
                                for (int iterate = 0; iterate < 5; ++iterate) {
                                    xtip = 0.5f * (xmin + xmax);
                                    ytip = 0.5f * (ymin + ymax);
                                    if (xtip < 0.0f || ytip < 0.0f || xtip > this.gridWidth_ || ytip > this.gridHeight_) {
                                        xmax = xtip;
                                        ymax = ytip;
                                        continue;
                                    }
                                    xmin = xtip;
                                    ymin = ytip;
                                }
                                GraphicUtils.drawLine(g2d, xorig, yorig, xtip, ytip);
                            } else {
                                GraphicUtils.drawLine(g2d, xorig, yorig, xtip, ytip);
                                if (this.vectorStyle_ == PanVectorStyle.ARROW) {
                                    float hlengthX = 0.175f * (float)vlength * Math.max(0.5f, factor);
                                    float x1 = (float)((double)xtip + (double)hlengthX * Math.sin(angleRad - 2.356194496154785));
                                    float y1 = (float)((double)ytip - (double)hlengthX * Math.cos(angleRad - 2.356194496154785));
                                    float x2 = (float)((double)xtip + (double)hlengthX * Math.sin(angleRad + 2.356194496154785));
                                    float y2 = (float)((double)ytip - (double)hlengthX * Math.cos(angleRad + 2.356194496154785));
                                    arrow.reset();
                                    arrow.moveTo(x1, y1);
                                    arrow.lineTo(xtip, ytip);
                                    arrow.lineTo(x2, y2);
                                    g2d.draw(arrow);
                                }
                            }
                        }
                    }
                    x += spacing;
                }
            }
            y += spacing;
        }
        g2d.translate(-this.gridLeft_, -this.gridTop_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] getXYVectorBaseAngle() {
        boolean counterclockwise;
        double baseAngleRad;
        String dir1 = this.pmeta_.getString("vector.dir1");
        String dir2 = this.pmeta_.getString("vector.dir2");
        if (dir1 == null || dir2 == null) {
            return null;
        }
        if (dir2.equalsIgnoreCase("Up")) {
            baseAngleRad = 0.0;
            if (dir1.equalsIgnoreCase("Right")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Left")) return null;
                counterclockwise = true;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        } else if (dir2.equalsIgnoreCase("Right")) {
            baseAngleRad = 1.5707963705062866;
            if (dir1.equalsIgnoreCase("Up")) {
                counterclockwise = true;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Down")) return null;
                counterclockwise = false;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        } else if (dir2.equalsIgnoreCase("Down")) {
            baseAngleRad = 3.1415927410125732;
            if (dir1.equalsIgnoreCase("Left")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Right")) return null;
                counterclockwise = true;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        } else {
            if (!dir2.equalsIgnoreCase("Left")) return null;
            baseAngleRad = 4.71238899230957;
            if (dir1.equalsIgnoreCase("Up")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Down")) return null;
                counterclockwise = true;
            }
        }
        return new Object[]{baseAngleRad, counterclockwise};
    }

    protected void drawContours(Graphics2D g2d) {
        if (this.contourWeight_ < 1) {
            return;
        }
        String style = this.pmeta_.getString("contour.style").toLowerCase();
        if (PanContourStyle.NONE.matches(style)) {
            return;
        }
        if (this.needsRecontour_) {
            PanScaleMeta smeta = this.pmeta_.getScaleMeta();
            double[] tvalues = smeta.getContourTickValues();
            this.contours_.setLevelValues(tvalues);
            this.contourLevels_ = this.contours_.getLevels();
            if (this.pmeta_.getString("contour.location").equalsIgnoreCase("minor")) {
                double[] mvalues = smeta.getMajorTickValues();
                block4: for (ContourLevel level : this.contourLevels_) {
                    double value = level.getValue();
                    level.setLabeled(false);
                    for (int i = 0; i < mvalues.length; ++i) {
                        if (value != mvalues[i]) continue;
                        level.setLabeled(true);
                        continue block4;
                    }
                }
            }
            this.needsRecontour_ = false;
        }
        if (this.contourLevels_ == null) {
            return;
        }
        int levelcount = this.contourLevels_.size();
        if (levelcount == 0) {
            return;
        }
        g2d.setColor(this.pmeta_.getColor("contour.color"));
        if (this.contourFont_ != null) {
            g2d.setFont(this.contourFont_);
        }
        FontMetrics fm = g2d.getFontMetrics();
        float fleft = this.gridLeft_;
        float ftop = this.gridTop_;
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        for (ContourLevel level : this.contourLevels_) {
            ContourLine line;
            int lineSize;
            level.sortBySize();
            double value = level.getValue();
            switch (smethod) {
                case LOG10: {
                    value = Math.pow(10.0, value);
                    break;
                }
                case LOG_E: {
                    value = Math.pow(Math.E, value);
                    break;
                }
            }
            BasicStroke stroke = PanContourStyle.DOTNEG.matches(style) ? (value < 0.0 ? this.contourStrokeDotted_ : this.contourStrokeSolid_) : (PanContourStyle.DOTMINOR.matches(style) ? (level.isLabeled() ? this.contourStrokeSolid_ : this.contourStrokeDotted_) : (PanContourStyle.DOTS.matches(style) ? this.contourStrokeDotted_ : this.contourStrokeSolid_));
            g2d.setStroke(stroke);
            int levelsize = level.size();
            int labelcount = levelsize <= 8 ? levelsize : Math.max(6, levelsize / 2);
            for (int jj = 0; jj < levelsize && (lineSize = (line = (ContourLine)level.get(jj)).size()) >= 2; ++jj) {
                float py;
                float px;
                Polygon lpoly = null;
                if (this.pmeta_.getBoolean("contour.label.vis") && this.contourFont_ != null && level.isLabeled() && lineSize > 50 && jj <= labelcount) {
                    String ltext = this.scaleFormatter_.sprintg(value);
                    int twidth = fm.stringWidth(ltext);
                    int ixx = lineSize * (jj % 3 + 1) / 4;
                    Point2D.Double p0 = (Point2D.Double)line.get(ixx);
                    Point2D.Double pa = (Point2D.Double)line.get(ixx - 3);
                    Point2D.Double pb = (Point2D.Double)line.get(ixx + 3);
                    double dy = pb.y - pa.y;
                    double dx = pb.x - pa.x;
                    double rad = Math.atan2(dy, dx);
                    if (rad > 1.5707963705062866) {
                        rad -= Math.PI;
                    } else if (rad < -1.5707963705062866) {
                        rad += Math.PI;
                    }
                    px = fleft + (float)p0.x;
                    py = ftop + (float)p0.y;
                    float hw = (float)(0.5 * (double)twidth);
                    float hh = (float)(0.5 * (double)fm.getAscent());
                    lpoly = this.makeContourLabelPolygon(px, py, twidth, fm.getAscent(), (float)rad);
                    g2d.translate(px, py);
                    g2d.rotate(rad);
                    g2d.drawString(ltext, -hw, hh);
                    g2d.rotate(-rad);
                    g2d.translate(-px, -py);
                }
                GeneralPath path = new GeneralPath();
                Point2D.Double pt0 = (Point2D.Double)line.get(0);
                px = fleft + (float)pt0.x;
                py = ftop + (float)pt0.y;
                path.moveTo(px, py);
                for (Object ptobj : line) {
                    Point2D.Double pt = (Point2D.Double)ptobj;
                    px = fleft + (float)pt.x;
                    py = ftop + (float)pt.y;
                    if (lpoly != null && lpoly.contains(px, py)) {
                        if (path.getCurrentPoint() != null) {
                            g2d.draw(path);
                        }
                        path.reset();
                        continue;
                    }
                    if (path.getCurrentPoint() != null) {
                        path.lineTo(px, py);
                        continue;
                    }
                    path.moveTo(px, py);
                }
                if (path.getCurrentPoint() == null) continue;
                g2d.draw(path);
            }
        }
    }

    private Polygon makeContourLabelPolygon(float px, float py, float w, float h, float angle) {
        float hw = (float)(0.6 * (double)w);
        float hh = (float)(0.6 * (double)h);
        float cosA = (float)Math.cos(angle);
        float sinA = (float)Math.sin(angle);
        int px1 = (int)(px + hw * cosA - hh * sinA);
        int px2 = (int)(px + hw * cosA + hh * sinA);
        int px3 = (int)(px - hw * cosA + hh * sinA);
        int px4 = (int)(px - hw * cosA - hh * sinA);
        int py1 = (int)(py + hw * sinA + hh * cosA);
        int py2 = (int)(py + hw * sinA - hh * cosA);
        int py3 = (int)(py - hw * sinA - hh * cosA);
        int py4 = (int)(py - hw * sinA + hh * cosA);
        return new Polygon(new int[]{px1, px2, px3, px4}, new int[]{py1, py2, py3, py4}, 4);
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        PlotPieceMargins margins = this.getMargins();
        double xx = x - (double)((float)margins.left + this.gridLeft_);
        double yy = y - (double)((float)margins.top + this.gridTop_);
        if (xx < 0.0 || yy < 0.0 || xx > (double)this.gridWidth_ || yy > (double)this.gridHeight_) {
            return null;
        }
        return ((PanData2D)this.data_).transformXY2GridCoords(xx, yy);
    }

    @Override
    public String describePoint(int x, int y) {
        PlotPieceMargins margins = this.getMargins();
        int xx = (int)((float)x - ((float)margins.left + this.gridLeft_));
        int yy = (int)((float)y - ((float)margins.top + this.gridTop_));
        if (xx < 0 || yy < 0 || (float)xx > this.gridWidth_ || (float)yy > this.gridHeight_) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        ((PanDataGeneral2D)this.data_).describeDataAt(sb, xx, yy);
        return sb.toString();
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        this.needsDataRedraw_ = true;
        this.needsRecontour_ = true;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        if (changeAll || pname.contains("font.master") || pname.contains("size.factor") || pname.contains("xaxis.label.size") || pname.contains("xaxis.tick.size") || pname.contains("yaxis.label.size") || pname.contains("yaxis.tick.size") || pname.contains("contour.label.size")) {
            String fn = this.pmeta_.getString("font.master");
            this.xAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("xaxis.label.size");
            this.yAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("yaxis.label.size");
            this.xAxisTickFhgt_ = scaling * this.pmeta_.getFloat("xaxis.tick.size");
            this.yAxisTickFhgt_ = scaling * this.pmeta_.getFloat("yaxis.tick.size");
            float cfhgt = scaling * this.pmeta_.getFloat("contour.label.size");
            this.xAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.xAxisLabelFhgt_);
            this.yAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.yAxisLabelFhgt_);
            this.xAxisTickFont_ = PanGraphicUtils.getFont(fn, this.xAxisTickFhgt_);
            this.yAxisTickFont_ = PanGraphicUtils.getFont(fn, this.yAxisTickFhgt_);
            if (cfhgt > 0.0f) {
                cfhgt = MathUtils.minmax(2.0f, 36.0f, cfhgt);
                this.contourFont_ = PanGraphicUtils.getFont(fn, cfhgt);
            } else {
                this.contourFont_ = null;
            }
        }
        if (changeAll || pname.contains("scale.tick.format")) {
            String s = this.pmeta_.getString("scale.tick.format");
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"scale.tick.format");
                throw new RuntimeException("Null format string");
            }
            this.scaleFormatter_ = new PrintfFormat(s);
        }
        if (changeAll || pname.contains("grid.style") || pname.contains("grid.color") || pname.contains("grid.weight")) {
            try {
                this.gridColor_ = this.pmeta_.getColor("grid.color");
                this.gridWeight_ = PanUtils.min0max(200, this.pmeta_.getInt("grid.weight"));
                String gs = this.pmeta_.getString("grid.style");
                this.gridStroke_ = this.gridWeight_ > 0 ? PanGraphicUtils.buttMiterStroke(gs, this.gridWeight_, sfactor) : null;
                int borderWgt = Math.max(75, this.gridWeight_);
                this.borderStroke_ = PanGraphicUtils.solidStroke(borderWgt, sfactor);
            }
            catch (Exception gs) {
                // empty catch block
            }
        }
        if (changeAll || pname.contains("xaxis.method") || pname.contains("xaxis.left") || pname.contains("xaxis.right") || pname.contains("xaxis.units")) {
            this.needsDataRedraw_ = true;
            this.needsRecontour_ = true;
        }
        if (changeAll || pname.contains("yaxis.method") || pname.contains("yaxis.top") || pname.contains("yaxis.bottom") || pname.contains("yaxis.units")) {
            this.needsDataRedraw_ = true;
            this.needsRecontour_ = true;
        }
        if (changeAll || pname.contains("xaxis.div.major")) {
            try {
                int divs = this.pmeta_.getInt("xaxis.div.major");
                divs = Math.min(divs, 25);
                this.xMajorDiv_ = divs = Math.max(divs, 1);
            }
            catch (Exception divs) {
                // empty catch block
            }
        }
        if (changeAll || pname.contains("xaxis.div.minor")) {
            try {
                int divs = this.pmeta_.getInt("xaxis.div.minor");
                divs = Math.min(divs, 25);
                this.xMinorDiv_ = divs = Math.max(divs, 1);
            }
            catch (Exception divs) {
                // empty catch block
            }
        }
        if (changeAll || pname.contains("yaxis.div.major")) {
            try {
                int divs = this.pmeta_.getInt("yaxis.div.major");
                divs = Math.min(divs, 25);
                this.yMajorDiv_ = divs = Math.max(divs, 1);
            }
            catch (Exception divs) {
                // empty catch block
            }
        }
        if (changeAll || pname.contains("yaxis.div.minor")) {
            try {
                int divs = this.pmeta_.getInt("yaxis.div.minor");
                divs = Math.min(divs, 25);
                this.yMinorDiv_ = divs = Math.max(divs, 1);
            }
            catch (Exception divs) {
                // empty catch block
            }
        }
        if (changeAll || pname.contains("xaxis.label.custom") || pname.contains("xaxis.label.text")) {
            this.xaxisLabelText_ = this.pmeta_.getBoolean("xaxis.label.custom") ? this.pmeta_.getString("xaxis.label.text") : null;
        }
        if (changeAll || pname.contains("yaxis.label.custom") || pname.contains("yaxis.label.text")) {
            this.yaxisLabelText_ = this.pmeta_.getBoolean("yaxis.label.custom") ? this.pmeta_.getString("yaxis.label.text") : null;
        }
        if (changeAll || pname.contains("xaxis.tick.format")) {
            String s = this.pmeta_.getString("xaxis.tick.format");
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"xaxis.tick.format");
                throw new RuntimeException("Null format string");
            }
            this.xAxisFormatter_ = new PrintfFormat(s);
        }
        if (changeAll || pname.contains("yaxis.tick.format")) {
            String s = this.pmeta_.getString("yaxis.tick.format");
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"yaxis.tick.format");
                throw new RuntimeException("Null format string");
            }
            this.yAxisFormatter_ = new PrintfFormat(s);
        }
        if (changeAll || pname.contains("contour.color") || pname.contains("contour.weight") || pname.contains("contour.style") || pname.contains("contour.location") || changeAll) {
            String s = this.pmeta_.getString("contour.style");
            this.contourWeight_ = s.toLowerCase().contains("none") ? 0 : PanUtils.min0max(500, this.pmeta_.getInt("contour.weight"));
            this.contourStrokeSolid_ = PanGraphicUtils.roundStroke(PanStrokeStyle.SOLID, this.contourWeight_, sfactor);
            this.contourStrokeDotted_ = PanGraphicUtils.roundStroke(PanStrokeStyle.DOTS, this.contourWeight_, sfactor);
        }
        if (changeAll || pname.contains("combination") || pname.contains("vector.color") || pname.contains("vector.weight") || pname.contains("vector.style")) {
            boolean vectorsEnabled;
            PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
            boolean bl = vectorsEnabled = ctype != null && ctype == PanCombinationType.VECTOR;
            if (vectorsEnabled) {
                String vs = this.pmeta_.getString("vector.style").toLowerCase();
                if (PanVectorStyle.ARROW.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.ARROW;
                    this.vectorWeight_ = PanUtils.min0max(500, this.pmeta_.getInt("vector.weight"));
                } else if (PanVectorStyle.UPDOT.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.UPDOT;
                    this.vectorWeight_ = PanUtils.min0max(500, this.pmeta_.getInt("vector.weight"));
                } else {
                    this.vectorStyle_ = PanVectorStyle.NONE;
                    this.vectorWeight_ = 0;
                }
            } else {
                this.vectorWeight_ = 0;
            }
            if (this.vectorWeight_ > 0) {
                this.vectorColor_ = this.pmeta_.getColor("vector.color");
                this.vectorStroke_ = GraphicUtils.buttMiterStroke(this.vectorWeight_);
            } else {
                this.vectorColor_ = null;
                this.vectorStroke_ = null;
            }
        }
    }

    private class ColorArea {
        public final int colorval_;
        public final Area area_;

        ColorArea(int colorval, Area area) {
            this.colorval_ = colorval;
            this.area_ = area;
        }
    }
}

