/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.overlay;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanPrintablePanel;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOverlayPanel
extends PanPrintablePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final int DEFAULT_MAP_WIDTH = 540;
    private static final int DEFAULT_MAP_HEIGHT = 270;
    private static final int MAP_MARGIN = 6;
    private BufferedImage mapImage_;
    private MapOverlay overlay_;
    private boolean oInverted_;
    private AbstractProjection projection_;
    private Dimension imgSize_;
    private Dimension mapSize_;

    public PanOverlayPanel(MapOverlay ao) {
        this();
        this.setOverlay(ao);
    }

    public PanOverlayPanel() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        Rectangle rr = GuiUtils.getActiveScreenBounds();
        int mapW = 540;
        int mapH = 270;
        if (rr != null && rr.width > mapW * 3 / 2 + 40) {
            mapW = mapW * 3 / 2;
            mapH = mapH * 3 / 2;
        }
        this.mapImage_ = new BufferedImage(mapW, mapH, 2);
        this.imgSize_ = new Dimension(mapW, mapH);
        this.mapSize_ = new Dimension(mapW + 12, mapH + 12);
        this.setOpaque(false);
        this.setBorder(SIMPLE_OUTLINE_BORDER);
        Insets ins = this.getInsets();
        Dimension size = new Dimension(this.mapSize_.width + ins.left + ins.right, this.mapSize_.height + ins.top + ins.bottom);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setProjection(prefs.getString("plot:lonlat.proj.name"));
        this.setOverlay((MapOverlay)prefs.get(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[0]));
        this.setOverlayInverted(prefs.getBoolean(PanParameterKeys.P_LON_LAT_OVERLAY_INVERT[0]));
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int w, int h) {
        if (this.projection_ != null) {
            Insets ins = this.getInsets();
            this.mapSize_ = new Dimension(w - (ins.left + ins.right), h - (ins.top + ins.bottom));
            this.projection_.setSizeAndMargins(this.mapSize_.width, this.mapSize_.height, 6, 6);
        }
        super.setSize(w, h);
    }

    public final void setOverlay(MapOverlay o) {
        this.overlay_ = o;
        this.repaint();
    }

    public void setOverlayInverted(boolean b) {
        this.oInverted_ = b;
        this.repaint();
    }

    public AbstractProjection getProjection() {
        return this.projection_;
    }

    public final void setProjection(String name) {
        AbstractProjection old = this.projection_;
        try {
            this.projection_ = ProjectionFactory.create(name, this.mapSize_.width, this.mapSize_.height, 6, 6);
        }
        catch (Exception exc) {
            this.projection_ = new Equirectangular(this.mapSize_.width, this.mapSize_.height, 6, 6);
        }
        if (old == null) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            this.projection_.setCenter(prefs.getDouble("plot:lonlat.proj.lon0"), prefs.getDouble("plot:lonlat.proj.lat0"));
            this.projection_.setBackground(new Color(238, 238, 238));
            this.projection_.setBorderColor(Color.BLACK);
            this.projection_.setPathColor(Color.BLACK);
            this.projection_.setGridSpacing(30.0);
            this.projection_.setGridColor(Color.LIGHT_GRAY);
        } else {
            this.projection_.setCenter(old.getCenter());
            this.projection_.setBackground(old.getBackground());
            this.projection_.setBorderColor(old.getBorderColor());
            this.projection_.setZoom(old.getZoom());
            this.projection_.setBorderStroke(old.getBorderStroke());
            this.projection_.setLonGridSpacing(old.getLonGridSpacing());
            this.projection_.setLatGridSpacing(old.getLatGridSpacing());
            this.projection_.setGridColor(old.getGridColor());
            this.projection_.setGridStroke(old.getGridStroke());
            this.projection_.setGridLabeled(old.isGridLabeled());
            this.projection_.setPathColor(old.getPathColor());
            this.projection_.setPathColor(old.getPathColor());
        }
        this.repaint();
    }

    @Override
    public void printBorder(Graphics g) {
    }

    @Override
    public void paintBorder(Graphics g) {
    }

    @Override
    public void paintComponent(Graphics g) {
        LOGGER.trace("");
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        Graphics2D imgG2D = this.mapImage_.createGraphics();
        imgG2D.setColor(Color.WHITE);
        GraphicUtils.fillRect(imgG2D, 0.0, 0.0, this.imgSize_.width, this.imgSize_.height);
        if (this.overlay_ instanceof PanMaskOverlay) {
            BufferedImage mask = ((PanMaskOverlay)this.overlay_).getMask(Color.BLACK, this.oInverted_);
            imgG2D.drawImage(mask, 0, 0, this.imgSize_.width, this.imgSize_.height, 0, 0, ((Image)mask).getWidth(this), ((Image)mask).getHeight(this), this);
        }
        imgG2D.dispose();
        this.projection_.setSourceImage(this.mapImage_);
        Insets ins = this.getInsets();
        g2d.translate(ins.left, ins.top);
        this.projection_.paintMap(g2d);
        if (this.overlay_ instanceof OutlineOverlay) {
            this.projection_.drawOutline(g2d, (OutlineOverlay)this.overlay_);
        }
        this.projection_.drawGrid(g2d);
        this.projection_.drawBorder(g2d);
        g2d.dispose();
    }
}

