/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanPlotWidthAction;
import gov.nasa.giss.panoply.action.PanThinnerPlotAction;
import gov.nasa.giss.panoply.action.PanWiderPlotAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotWidth;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotWidthMenu
extends PanMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JMenuItem miCurrentWidth_;
    private final JMenuItem miWider_;
    private final JMenuItem miThinner_;
    private final Hashtable<String, JCheckBoxMenuItem> miPresetsHash_ = new Hashtable(20);

    public PanPlotWidthMenu(PanFrame parent) {
        super(parent, "plot-width-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        this.miCurrentWidth_ = this.makeItemFromProperties("current-width", null);
        this.add(this.miCurrentWidth_).setEnabled(false);
        this.addSeparator();
        AbstractAction a = parentIsPlot ? new PanWiderPlotAction((PanPlotFrame)parent) : null;
        this.miWider_ = this.makeItemFromProperties("show-wider", a);
        this.add(this.miWider_).setEnabled(false);
        a = parentIsPlot ? new PanThinnerPlotAction((PanPlotFrame)parent) : null;
        this.miThinner_ = this.makeItemFromProperties("show-thinner", a);
        this.add(this.miThinner_).setEnabled(false);
        this.addSeparator();
        for (PanPlotWidth pwidth : PanPlotWidth.values()) {
            String aid = pwidth.getActionID();
            String atext = pwidth.toString();
            PanPlotWidthAction a2 = parentIsPlot ? new PanPlotWidthAction((PanPlotFrame)parent, pwidth) : null;
            GissCheckBoxMenuItem mi = aid != null ? this.makeCheckBoxItemFromProperties(aid, a2) : this.makeCheckBoxItem(atext, a2);
            this.miPresetsHash_.put(atext, mi);
            this.add(mi).setEnabled(parentIsPlot);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        JFrame pf = GuiUtils.getParentFrame(this);
        if (!(pf instanceof PanPlotFrame)) {
            return;
        }
        int wf = ((PanPlotFrame)pf).getWidthFactor();
        this.miCurrentWidth_.setText(PanProperties.MENU_PROPS.getString("current-width") + " = " + wf);
        this.miWider_.setEnabled(wf < 100);
        this.miThinner_.setEnabled(wf > 20);
        for (String key : this.miPresetsHash_.keySet()) {
            JCheckBoxMenuItem mi = this.miPresetsHash_.get(key);
            mi.setEnabled(true);
            String text = mi.getText();
            PanPlotWidth pwidth = PanPlotWidth.matching(text);
            if (pwidth == null) {
                mi.setSelected(false);
                continue;
            }
            mi.setSelected(pwidth.getWidthFactor() == wf);
        }
    }
}

