/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayTimeVert;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridderTimeVert;
import gov.nasa.giss.panoply.data.PanDataTimeY;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import java.awt.Dimension;

public class PanDataTimeVert
extends PanDataTimeY {
    public PanDataTimeVert(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanDataTimeVert(NcArray nca, int width, int height) {
        super(nca, width, height);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayTimeVert)) {
            throw new IllegalArgumentException("NcArray is not NcArrayTimeVert.");
        }
        return true;
    }

    @Override
    protected void regrid(NcArray nca, double[] target, boolean interpolated) {
        NcGridderTimeVert gridder = (NcGridderTimeVert)nca.getGridder();
        if (this.yaxisMethod_ == PanAxisMethod.INDEX) {
            gridder.setYAxisMethod(NcAxisMethod.INDEX);
        } else if (this.yaxisMethod_ == PanAxisMethod.LOG10) {
            gridder.setYAxisUcarUnits(this.yAxisUcarUnits_);
            gridder.setYAxisMethod(NcAxisMethod.LOG10);
        } else {
            gridder.setYAxisUcarUnits(this.yAxisUcarUnits_);
            gridder.setYAxisMethod(NcAxisMethod.SCALAR);
        }
        gridder.setSize(this.gridWidth_, this.gridHeight_);
        gridder.setBounds(this.lBound_, this.tBound_, this.rBound_, this.bBound_);
        if (interpolated) {
            gridder.regridInterpolate(nca, target);
        } else {
            gridder.regridNoInterpolate(nca, target);
        }
    }
}

