/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.colortable;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanPrintablePanel;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorTableBinPanel;
import gov.nasa.giss.ui.color.ColorTablePreviewPanel;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanColorTableFrame
extends PanDisplayFrame
implements DropTargetListener,
Printable,
ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int LABEL_FHGT = 12;
    private static final int LABEL_HGT = 18;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 12);
    private PanPrintablePanel contentPanel_;
    private PanColorTableComboBox cbCombo_;
    private ColorTableBinPanel cbPanel_;
    private ColorTablePreviewPanel csPanel_;

    public static PanColorTableFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanColorTableFrame() {
        super("Panoply \u2014 Color Tables");
        if (PlatformUtils.isWindows()) {
            this.setTitle("Panoply: " + this.getTitle());
        }
        this.setResizable(false);
        this.setPanMenuBar(new PanMenuBar(this));
        this.setPanMenuBar(new PanMenuBar(this));
        this.createLayout();
        this.placeOnScreen();
        this.attachListeners();
    }

    private final void createLayout() {
        this.cbCombo_ = PanColorTableComboBox.create(false);
        AbstractColorTable cb = (AbstractColorTable)this.cbCombo_.getSelectedItem();
        this.csPanel_ = new ColorTablePreviewPanel(cb);
        this.cbPanel_ = new ColorTableBinPanel(cb);
        this.csPanel_.setOutlierShape(ColorTableOutlierShape.TRIANGLE);
        this.contentPanel_ = new PanPrintablePanel();
        this.contentPanel_.setLayout(new BoxLayout(this.contentPanel_, 1));
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.add(QuickBox.createCenterBox(new JLabel("Show: "), this.cbCombo_));
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.csPanel_);
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.cbPanel_);
        this.csPanel_.setOpaque(false);
        this.cbPanel_.setOpaque(false);
        this.contentPanel_.setOpaque(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.contentPanel_);
        contentPane.add(this.getStatusBar());
        this.pack();
    }

    private final void attachListeners() {
        GuiUtils.makeRecursiveDropTarget(this.csPanel_, this);
        GuiUtils.makeRecursiveDropTarget(this.cbPanel_, this);
        this.cbCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            Dimension w1 = this.getSize();
            Dimension p1 = this.cbPanel_.getSize();
            AbstractColorTable cb = (AbstractColorTable)this.cbCombo_.getSelectedItem();
            this.csPanel_.setColorTable(cb);
            this.cbPanel_.setColorTable(cb);
            this.pack();
            this.repaint();
            Dimension w2 = this.getSize();
            Dimension p2 = this.cbPanel_.getPreferredSize();
            int dd = p2.height - p1.height - (w2.height - w1.height);
            this.setSize(new Dimension(w2.width, w2.height + dd));
        });
        PanUtils.getColorTableResourceList().addListDataListener(this);
    }

    public void setColorTable(AbstractColorTable act) {
        this.cbCombo_.setSelectedItem(act);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiConstants.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!ColorTableFilenameFilter.isColorTableName(f)) continue;
                    addlist.add(f);
                }
                Object[] oo = PanUtils.getColorTableResourceList().addAlphabetic((Component)this, addlist);
                if (oo != null && oo.length > 0) {
                    this.cbCombo_.setSelectedItem(oo[0]);
                }
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiConstants.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        LOGGER.debug("Not implemented.");
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        if (jf == this) {
            ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
            AbstractColorTable act = (AbstractColorTable)reslist.getBackingObject(e.getIndex0());
            EventQueue.invokeLater(() -> this.setColorTable(act));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = new Dimension(Math.max(this.csPanel_.getWidth(), this.cbPanel_.getWidth()), this.csPanel_.getHeight() + this.cbPanel_.getHeight() + 18);
        double scaleX = pf.getImageableWidth() / (double)size.width;
        double scaleY = pf.getImageableHeight() / (double)size.height;
        double scale = Math.min(scaleY, scaleX);
        double tranY = 0.5 * (pf.getImageableHeight() - scale * (double)size.height);
        g2d.translate(pf.getImageableX(), pf.getImageableY() + tranY);
        g2d.scale(scale, scale);
        this.csPanel_.print(g2d);
        g2d.translate(0, this.csPanel_.getHeight());
        this.cbPanel_.print(g2d);
        g2d.translate(0, this.cbPanel_.getHeight() + 18);
        this.printLabel(g2d, 0);
        return 0;
    }

    private final void printLabel(Graphics2D g2d, int y) {
        g2d.setFont(LABEL_FONT);
        FontMetrics fm = g2d.getFontMetrics();
        String s = this.cbCombo_.getSelectedItem().toString();
        g2d.drawString(s, (int)(0.5 * (double)(this.cbPanel_.getWidth() - fm.stringWidth(s))), y);
    }

    @Override
    public PanPrintablePanel getPrintable() {
        return this.contentPanel_;
    }

    private static class Singleton {
        private static final PanColorTableFrame INSTANCE = new PanColorTableFrame();

        private Singleton() {
        }
    }
}

