/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanDnVPanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanToggleSourcesEnhancedAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("toggle-enhanced-mode");
    private boolean busy_;
    private long last_;

    public static synchronized PanToggleSourcesEnhancedAction getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanToggleSourcesEnhancedAction() {
        super(ACTION_NAME);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean oldValue = prefs.getBoolean("sources:info.enhanced");
        long now = System.currentTimeMillis();
        if (now - this.last_ < 200L && e.getSource() instanceof JCheckBoxMenuItem) {
            LOGGER.debug("Too soon, {}; do nothing", (Object)(now - this.last_));
        } else {
            PanSourcesFrame sf = PanSourcesFrame.getSharedInstance();
            PanSourcesPanel sp = sf.getVisibleSubpanel();
            if (!(sp instanceof PanDnVPanel)) {
                return;
            }
            boolean newValue = !oldValue;
            prefs.setBoolean("sources:info.enhanced", newValue);
            ((PanDnVPanel)sp).setEnhanced(newValue);
        }
        GuiUtils.refreshFrontFrameMenuBar();
        this.last_ = now;
        this.busy_ = false;
    }

    private static class Singleton {
        private static final PanToggleSourcesEnhancedAction INSTANCE = new PanToggleSourcesEnhancedAction();

        private Singleton() {
        }
    }
}

