/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanScaleControls2D;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanReverseColorbarAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanScaleControls2D controls_;
    private long last_;
    private boolean busy_;

    public PanReverseColorbarAction(PanScaleControls2D controls) {
        super(PanProperties.MENU_PROPS.getString("reverse-scale"));
        this.controls_ = controls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        PanPlotFrame pf = this.controls_.getParentFrame();
        Object source = e.getSource();
        long now = System.currentTimeMillis();
        if (now - this.last_ < 200L && source instanceof JCheckBoxMenuItem) {
            LOGGER.debug("Too soon; do nothing");
        } else {
            boolean newValue = ((AbstractButton)source).isSelected();
            this.controls_.setReverseColorbar(newValue);
            PanPlotMeta pmeta = pf.getMeta();
            pmeta.setBoolean("scale.reverse", newValue);
        }
        GuiUtils.refreshFrontFrameMenuBar();
        this.last_ = now;
        this.busy_ = false;
    }
}

