/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.panoply.action.dialog.PanExportAnimationDialog;
import gov.nasa.giss.panoply.action.task.PanExportAnimationTask;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanAnimationFormat;
import gov.nasa.giss.panoply.util.PanAnimationOption;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.task.TaskEvent;
import gov.nasa.giss.util.task.TaskListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportAnimationAction
extends AbstractAction
implements TaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DOT = ".";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-animation");
    private final PanPlotFrame parent_;
    private File file_;
    private String fnameRoot_;
    private NcDimension[] dimensions_;
    private PanExportAnimationTask animationTask_;
    private boolean animationInProgress_;

    public PanExportAnimationAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    public void cancel() {
        if (this.animationInProgress_) {
            this.animationTask_.cancel(true);
            this.parent_.setAnimationInProgress(false);
            GuiUtils.showSlowMessage(this.parent_, "Animation Canceled", "The animation was canceled before completion.");
        }
    }

    public File getFile() {
        return this.file_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        PanExportAnimationDialog aod = new PanExportAnimationDialog(this.parent_);
        aod.setVisible(true);
        if (!aod.isSuccessful()) {
            return;
        }
        Hashtable<PanAnimationOption, Object> opts = aod.getOptions();
        this.dimensions_ = aod.getDimensions();
        aod.dispose();
        if (this.dimensions_.length == 2 && this.dimensions_[0] == null && this.dimensions_[1] == null) {
            LOGGER.trace("No animation dimension selected; this will be a single-frame movie.");
        }
        PanAnimationFormat format = (PanAnimationFormat)((Object)opts.get((Object)PanAnimationOption.FORMAT));
        String fnameExt = format.getExtension().toLowerCase();
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export animation as\u2026", fnameExt, this.fnameRoot_, fnameExt)) == null) {
            return;
        }
        this.file_ = file;
        this.animationTask_ = new PanExportAnimationTask(this.file_, this.parent_, this.dimensions_, opts);
        this.parent_.toFront();
        this.parent_.setAnimationInProgress(true);
        this.animationTask_.addTaskListener(this);
        this.setEnabled(false);
        this.animationInProgress_ = true;
        this.parent_.addTask(this.animationTask_);
    }

    @Override
    public void taskCommenced(TaskEvent e) {
        this.animationInProgress_ = true;
    }

    @Override
    public void taskCompleted(TaskEvent e) {
        this.animationInProgress_ = false;
        this.setEnabled(true);
    }

    @Override
    public void taskCanceled(TaskEvent e) {
        this.animationInProgress_ = false;
        this.setEnabled(true);
    }
}

