/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBiggerPlotAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("show-bigger");
    private final PanPlotFrame pframe_;

    public PanBiggerPlotAction(PanPlotFrame pframe) {
        super(ACTION_NAME);
        this.pframe_ = pframe;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.trace("");
        PanPlotMeta pmeta = this.pframe_.getMeta();
        int oldSF = pmeta.getInt("size.factor");
        if (oldSF >= 300) {
            this.setEnabled(false);
        } else {
            int newSF = oldSF >= 120 ? oldSF + 10 : oldSF + 5;
            this.pframe_.setSizeFactor(newSF);
        }
        PanMenuBar mbar = this.pframe_.getPanMenuBar();
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        plotMenu.refresh();
    }
}

