/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.shapefile;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.shapefile.ShapeRecord;
import gov.nasa.giss.map.shapefile.ShapeRecordMultiPatch;
import gov.nasa.giss.map.shapefile.ShapeRecordMultiPoint;
import gov.nasa.giss.map.shapefile.ShapeRecordNull;
import gov.nasa.giss.map.shapefile.ShapeRecordPoint;
import gov.nasa.giss.map.shapefile.ShapeRecordPolygon;
import gov.nasa.giss.map.shapefile.ShapeRecordPolyline;
import gov.nasa.giss.map.shapefile.ShapeRecordType;
import gov.nasa.giss.map.shapefile.ShapeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shapefile {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Object address_;
    private boolean dataRead_;
    private int flength_;
    private int fread_;
    private ShapeRecordType shapeType_;
    private ArrayList<ShapeRecord> shapes_;
    private double left_;
    private double top_;
    private double right_;
    private double bottom_;

    public Shapefile(File f) throws IOException, FileNotFoundException {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.address_ = f;
        this.readHeader();
    }

    public Shapefile(URL url) throws IOException {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.address_ = url;
        this.readHeader();
    }

    public Shapefile(InputStream istream) throws IOException {
        this.readFullContent(istream);
    }

    public ShapeRecordType getType() {
        return this.shapeType_;
    }

    private void readHeader() throws IOException {
        block51: {
            if (this.address_ == null) {
                throw new RuntimeException("Shapefile address is null");
            }
            if (this.address_ instanceof File) {
                try (FileInputStream fstream = new FileInputStream((File)this.address_);
                     PushbackInputStream pstream = new PushbackInputStream(fstream, 12);){
                    this.readHeader(pstream);
                    break block51;
                }
            }
            if (this.address_ instanceof URL) {
                try (InputStream istream = ((URL)this.address_).openStream();
                     PushbackInputStream pstream = new PushbackInputStream(istream, 12);){
                    this.readHeader(pstream);
                    break block51;
                }
            }
            throw new RuntimeException("Shapefile address must be a File or URL");
        }
    }

    private void readFullContent() throws IOException {
        if (this.address_ == null) {
            throw new RuntimeException("Shapefile address is null");
        }
        if (this.address_ instanceof File) {
            try (FileInputStream fstream = new FileInputStream((File)this.address_);){
                this.readFullContent(fstream);
            }
        } else if (this.address_ instanceof URL) {
            try (InputStream istream = ((URL)this.address_).openStream();){
                this.readFullContent(istream);
            }
        } else {
            throw new RuntimeException("Shapefile address must be a File or URL");
        }
    }

    private void readFullContent(InputStream istream) throws IOException {
        try (PushbackInputStream pstream = new PushbackInputStream(istream, 12);){
            this.readHeader(pstream);
            this.readData(pstream);
        }
    }

    private void readHeader(PushbackInputStream pstream) throws IOException {
        byte[] b = new byte[100];
        int bytesRead = pstream.read(b);
        if (bytesRead < 100) {
            pstream.close();
            throw new IOException("Does not seem to be a shapefile.");
        }
        this.fread_ = 100;
        int magic = ShapeUtils.intFromBigBytes(ShapeUtils.arraySection(b, 0, 4));
        if (magic != 9994) {
            pstream.close();
            throw new IOException("Magic number is not 9994.");
        }
        this.flength_ = ShapeUtils.intFromBigBytes(ShapeUtils.arraySection(b, 24, 4));
        this.flength_ *= 2;
        int version = ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(b, 28, 4));
        if (version != 1000) {
            LOGGER.warn("Expected 1000 for version but found {}", (Object)version);
        }
        this.shapeType_ = ShapeRecordType.matching(ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(b, 32, 4)));
        double xmin = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(b, 36, 8));
        double ymin = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(b, 44, 8));
        double xmax = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(b, 52, 8));
        double ymax = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(b, 60, 8));
        this.left_ = xmin;
        this.top_ = ymax;
        this.right_ = xmax;
        this.bottom_ = ymin;
    }

    private void readData(PushbackInputStream pstream) throws IOException {
        this.shapes_ = new ArrayList(500);
        while (this.fread_ < this.flength_) {
            this.readRecord(pstream);
        }
        this.dataRead_ = true;
    }

    private void readRecord(PushbackInputStream pstream) throws IOException {
        int rnum = 0;
        int wordLength = 0;
        int byteLength = 0;
        byte[] headerBytes = new byte[8];
        int bytesRead = pstream.read(headerBytes);
        if (bytesRead < 8) {
            pstream.close();
            throw new IOException("Error reading record header");
        }
        this.fread_ += bytesRead;
        rnum = ShapeUtils.intFromBigBytes(ShapeUtils.arraySection(headerBytes, 0, 4));
        wordLength = ShapeUtils.intFromBigBytes(ShapeUtils.arraySection(headerBytes, 4, 4));
        byteLength = wordLength * 2;
        int shapeID = -1;
        byte[] typeBytes = new byte[4];
        int bytesRead2 = pstream.read(typeBytes);
        if (bytesRead2 < 4) {
            pstream.close();
            throw new IOException("Error reading shape type");
        }
        this.fread_ += bytesRead2;
        shapeID = ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(typeBytes, 0, 4));
        pstream.unread(typeBytes);
        this.fread_ -= 4;
        byte[] recordBytes = new byte[byteLength];
        int bytesRead3 = pstream.read(recordBytes);
        if (bytesRead3 < byteLength) {
            pstream.close();
            throw new IOException("Error reading remainder of record");
        }
        this.fread_ += bytesRead3;
        ShapeRecord sr = null;
        switch (shapeID) {
            case 0: {
                sr = new ShapeRecordNull();
                break;
            }
            case 1: 
            case 11: 
            case 21: {
                sr = new ShapeRecordPoint();
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                sr = new ShapeRecordPolyline();
                break;
            }
            case 5: 
            case 15: 
            case 25: {
                sr = new ShapeRecordPolygon();
                break;
            }
            case 8: 
            case 18: 
            case 28: {
                sr = new ShapeRecordMultiPoint();
                break;
            }
            case 31: {
                sr = new ShapeRecordMultiPatch();
                break;
            }
            default: {
                LOGGER.warn("Shape {} is unknown type {}", (Object)rnum, (Object)shapeID);
                return;
            }
        }
        if (sr != null) {
            sr.readFromBuffer(recordBytes);
            this.shapes_.add(sr);
        }
    }

    public LonLatBounds getBounds() {
        return new LonLatBounds(this.left_, this.top_, this.right_, this.bottom_);
    }

    public int size() throws IOException {
        if (!this.dataRead_) {
            this.readFullContent();
        }
        return this.shapes_.size();
    }

    public ShapeRecord getShape(int index) throws IndexOutOfBoundsException, IOException {
        if (!this.dataRead_) {
            this.readFullContent();
        }
        return this.shapes_.get(index);
    }
}

