/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class WinkelTripel
extends QuadSymmetricProjection {
    public static final String PROJECTION_NAME = "Winkel Tripel";
    public static final int PROPERTIES = 32;
    private static final double COS_PHI1 = 0.6366197723675814;
    private static final double COS_PHI1_B = Math.cos(Math.toRadians(40.0));
    private static final double WIDTH_FACTOR = 1.5707963267948966 * (1.0 + COS_PHI1_B);
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double cosPhi1_ = 0.6366197723675814;
    private ProjBooleanParameter bartParam_ = new ProjBooleanParameter("Apply Bartholomew's scaling", "Apply Bartholomew's scaling", false);

    public WinkelTripel(int width, int height) {
        this(width, height, 0, 0);
    }

    public WinkelTripel(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public WinkelTripel(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, WIDTH_FACTOR, 1.5707963267948966);
        this.addParameter(this.bartParam_);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        this.setBartholomewVariant(this.bartParam_.isSelected());
    }

    public void setBartholomewVariant(boolean b) {
        this.cosPhi1_ = b ? COS_PHI1_B : 0.6366197723675814;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        this.setSizeFactors(0.5 * (Math.PI + Math.PI * this.cosPhi1_), 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double halfLambdaRad = 0.5 * lambdaRad;
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double a = Math.acos(cosPhi * Math.cos(halfLambdaRad));
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(a) > 1.0E-5) {
            double b = a / Math.sin(a);
            x = 0.5 * (lambdaRad * this.cosPhi1_ + 2.0 * b * cosPhi * Math.sin(halfLambdaRad));
            y = 0.5 * (phiRad + b * Math.sin(phiRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double[] llRad = this.iterateXY2LL(x, y, 1.5707963267948966, 1.5707963267948966 * y / this.ymRS_);
        if (llRad == null) {
            return null;
        }
        double lambda = Math.toDegrees(llRad[0]);
        double phi = Math.toDegrees(llRad[1]);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        WinkelTripel winkelTripel = this;
        synchronized (winkelTripel) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double[] llRad;
                double y = (double)iy + 0.5;
                double phiRad = this.invRS_ * y;
                double lambdaRad = 0.0;
                for (int ix = 0; ix < this.dxMax_ && (llRad = this.iterateXY2LL(x = (double)ix + 0.5, y, lambdaRad += 1.0E-5, phiRad += 1.0E-5)) != null; ++ix) {
                    lambdaRad = llRad[0];
                    phiRad = llRad[1];
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double[] iterateXY2LL(double x, double y, double lambdaRad0, double phiRad0) {
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        for (int iter = 0; iter < 33; ++iter) {
            double halfLambdaRad = 0.5 * lambdaRad;
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double sin2Phi = Math.sin(2.0 * phiRad);
            double cossqPhi = cosPhi * cosPhi;
            double sinsqPhi = sinPhi * sinPhi;
            double sinLambda = Math.sin(lambdaRad);
            double cosHalfLambda = Math.cos(halfLambdaRad);
            double sinHalfLambda = Math.sin(halfLambdaRad);
            double cosA = cosPhi * Math.cos(halfLambdaRad);
            double a = Math.acos(cosA);
            double sinsqA = 1.0 - cosA * cosA;
            double invSinsqA = 1.0 / sinsqA;
            double sinA = Math.sqrt(sinsqA);
            double invSinA = 1.0 / sinA;
            double b = a * invSinA;
            double bOverSinsqA = b * invSinsqA;
            double df1dPhi = invSinsqA * (0.25 * sinLambda * sin2Phi - b * sinPhi * sinHalfLambda);
            double df1dLambda = 0.5 * (cossqPhi * sinHalfLambda * sinHalfLambda * invSinsqA + bOverSinsqA * cosPhi * cosHalfLambda * sinsqPhi + this.cosPhi1_);
            double df2dPhi = 0.5 * (sinsqPhi * cosHalfLambda * invSinsqA + bOverSinsqA * (1.0 - cosHalfLambda * cosHalfLambda) * cosPhi + 1.0);
            double df2dLambda = 0.125 * invSinsqA * (sin2Phi * sinHalfLambda - b * cossqPhi * sinPhi * sinLambda);
            double f1 = halfLambdaRad * this.cosPhi1_ + b * cosPhi * sinHalfLambda - xOverRS;
            double f2 = 0.5 * (b * sinPhi + phiRad) - yOverRS;
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = -(f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = -(f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad += dphi;
            lambdaRad += dlambda;
            if (Math.abs(dphi) < 1.0E-5 && Math.abs(dlambda) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double edgeLon = this.lambdaC_ + 179.99999;
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        new Bezier(false, dotsE).draw(g2d);
        new Bezier(false, dotsW).draw(g2d);
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + 180.0, 90.0);
        g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        g2d.draw(new Line2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y));
    }
}

