/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner7
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Wagner VII";
    public static final int PROPERTIES = 32;
    private static final double CONST_N = 0.3333333333333333;
    private static final double MSUB2 = 1.0;
    private static final double MSUB1 = Math.sin(Math.toRadians(65.0));
    private static final double CONST_K = 2.0 * Math.sqrt(Math.sin(Math.toRadians(32.5)));
    private static final double CSUBX = 2.0 * CONST_K / Math.sqrt(0.3333333333333333 * MSUB1 * 1.0);
    private static final double INV_CSUBX = 1.0 / CSUBX;
    private static final double CSUBY = 2.0 / (CONST_K * Math.sqrt(0.3333333333333333 * MSUB1 * 1.0));
    private static final double INV_CSUBY = 1.0 / CSUBY;
    private static final double HALF_CX = 0.5 * CSUBX;
    private static final double HALF_CY = 0.5 * CSUBY;
    private static final double STEMP = MSUB1 * Math.sin(1.5707963267948966);
    private static final double C0TEMP = Math.sqrt(1.0 - STEMP * STEMP);
    private static final double C1TEMP = Math.sqrt(2.0 / (1.0 + 0.5 * C0TEMP));
    private static final double WIDTH_FACTOR = HALF_CX;
    private static final double HEIGHT_FACTOR = HALF_CY * STEMP * C1TEMP;

    public Wagner7(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner7(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner7(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double lambdaRadOver3 = lambdaRad / 3.0;
        double sinPsi = MSUB1 * Math.sin(1.0 * phiRad);
        double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
        double c1 = Math.sqrt(2.0 / (1.0 + cosPsi * Math.cos(lambdaRadOver3)));
        double x = HALF_CX * cosPsi * c1 * Math.sin(lambdaRadOver3);
        double y = HALF_CY * sinPsi * c1;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverCx = x * INV_CSUBX;
        double yOverCy = y * INV_CSUBY;
        double yOverCyRS = yOverCy * this.invRS_;
        double d = Math.hypot(xOverCx, yOverCy) * this.invRS_;
        double phiRad = 0.0;
        double lambdaRad = 0.0;
        if (d > 1.0E-5) {
            if (Math.abs(phiRad) > MSUB1) {
                return null;
            }
            double delta = 2.0 * Math.asin(d);
            double s = yOverCyRS * Math.sin(delta) / d;
            phiRad = Math.asin(s / MSUB1) / 1.0;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            if (Math.abs(phiRad) == 1.5707963267948966) {
                lambdaRad = 0.0;
            } else {
                double c0 = Math.sqrt(1.0 - s * s);
                lambdaRad = 3.0 * Math.acos(Math.cos(delta) / c0);
                if (x < 0.0) {
                    lambdaRad = 0.0 - lambdaRad;
                }
            }
            if (lambdaRad > Math.PI) {
                return null;
            }
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner7 wagner7 = this;
        synchronized (wagner7) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverCy = y * INV_CSUBY;
                double yOverCyRS = yOverCy * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverCx = x * INV_CSUBX;
                    double d = Math.hypot(xOverCx, yOverCy) * this.invRS_;
                    if (d > 1.0E-5) {
                        double delta = 2.0 * Math.asin(d);
                        double s = yOverCyRS * Math.sin(delta) / d;
                        if (s > MSUB1 || (phiRad = Math.asin(s / MSUB1) / 1.0) > 1.5707963267948966) continue;
                        if (phiRad == 1.5707963267948966) {
                            lambdaRad = 0.0;
                        } else {
                            double c0 = Math.sqrt(1.0 - s * s);
                            lambdaRad = 3.0 * Math.acos(Math.cos(delta) / c0);
                        }
                        if (lambdaRad > Math.PI) {
                            continue block3;
                        }
                    } else {
                        phiRad = 0.0;
                        lambdaRad = 0.0;
                    }
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

