/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class MillerCylindrical1
extends GlobalCylindric {
    public static final String PROJECTION_NAME = "Miller Cylindrical I";
    private static final double CONST_N = 1.25;
    private static final double CONST_M = 1.25;
    private static final double INV_N = 0.8;
    private static final double TWO_M = 2.5;
    private static final double INV_2M = 0.4;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.25 * Math.log(Math.tan(1.413716694115407));
    private double invNRS_ = 0.8;

    public MillerCylindrical1(int width, int height) {
        this(width, height, 0, 0);
    }

    public MillerCylindrical1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MillerCylindrical1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.finishScaling();
    }

    @Override
    protected void finishScaling() {
        this.invNRS_ = 0.8 * this.invRS_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double x = this.lonToLambdaRad(lon);
        double y = 1.25 * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(lat) * 0.4));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = 2.5 * (Math.atan(Math.exp(y * this.invNRS_)) - 0.7853981633974483);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        MillerCylindrical1 millerCylindrical1 = this;
        synchronized (millerCylindrical1) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = 2.5 * (Math.atan(Math.exp((y = (double)iy + 0.5) * this.invNRS_)) - 0.7853981633974483)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

