/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class GlobalCylindric
extends QuadSymmetricProjection {
    public static final int PROPERTIES = 4;

    public GlobalCylindric(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
    }

    @Override
    public boolean canLabelGrid() {
        return true;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ - 179.99999, lat);
        Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ + 179.99999, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        Shape oldclip = g2d.getClip();
        if (label != null) {
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(dot2.x - (double)fh2 - (double)w);
            g2d.drawString(label, labelx, (float)(dot1.y + (double)fh2 - (double)(des / 2)));
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot1.y - (double)fh2, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2d.setClip(clipArea);
        }
        GraphicUtils.drawLine(g2d, dot1.x, dot1.y, dot2.x, dot1.y);
        g2d.setClip(oldclip);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dot = this.transformLL2XY(lon, 0.0);
        if (dot == null) {
            return;
        }
        float top = this.outCenterY_ - this.dyMax_;
        float bottom = this.outCenterY_ + this.dyMax_;
        Shape oldclip = g2d.getClip();
        if (label != null) {
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(dot.x - 0.5 * (double)w);
            g2d.drawString(label, labelx, bottom - (float)fh2 - (float)des);
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, bottom - (float)fh2 - (float)fh, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2d.setClip(clipArea);
        }
        GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
        g2d.setClip(oldclip);
    }
}

