/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class EquirectangularOblique
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Equirectangular Oblique";
    public static final int PROPERTIES = 0x200004;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    protected static final double DEFAULT_HEIGHT = 180.0;
    private LonLatRotator rotMatrices_ = new LonLatRotator(this.lambdaC_, this.phiC_);
    private double heightDeg_ = 180.0;
    private ProjDoubleParameter hghtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center of map", "Height", "\u00b0", 180.0, 0.002, 180.0, true, true);

    public EquirectangularOblique(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public EquirectangularOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200004, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.hghtParam_);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.hghtParam_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setHeight(this.hghtParam_.getValue());
    }

    public void setHeight(double height) {
        this.heightDeg_ = height;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double ratio = this.heightDeg_ / 180.0;
        this.setSizeFactors(ratio * Math.PI, ratio * 1.5707963267948966);
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat);
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double x = Math.toRadians(llP[0]);
        double y = Math.toRadians(llP[1]);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double lambdaP = Math.toDegrees(x * this.invRS_);
        if (Math.abs(lambdaP) > 180.0) {
            return null;
        }
        double phiP = Math.toDegrees(y * this.invRS_);
        if (Math.abs(phiP) > 90.0) {
            return null;
        }
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        EquirectangularOblique equirectangularOblique = this;
        synchronized (equirectangularOblique) {
            double y;
            double phiP;
            for (int iy = -this.dyMax_; iy < this.dyMax_ && !(Math.abs(phiP = Math.toDegrees((y = (double)iy + 0.5) * this.invRS_)) > 90.0); ++iy) {
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaP = Math.toDegrees(x * this.invRS_);
                    double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
                    this.set2SymmetricPoints(ix, iy, ll[0] - this.lambdaC_, ll[1]);
                }
            }
        }
    }

    @Override
    public LonLatBounds getBounds() {
        double dlon2;
        double dlon1;
        double lat;
        PointLL ll;
        double wOver2 = 0.5 * (double)this.outWidth_;
        double hOver2 = 0.5 * (double)this.outHeight_;
        double tLat = -9999.0;
        double bLat = 9999.0;
        if (this.transformLL2XY(0.0, 90.0) != null) {
            tLat = 90.0;
        }
        if (this.transformLL2XY(0.0, -90.0) != null) {
            bLat = -90.0;
        }
        int j1 = 0;
        int j2 = 0;
        int j = 0;
        while ((double)j < hOver2) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll != null) {
                lat = ll.getLat();
                tLat = Math.max(tLat, lat);
                bLat = Math.min(bLat, lat);
                j1 = j;
                break;
            }
            ++j;
        }
        j = this.outHeight_ - 1;
        while ((double)j > hOver2) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll != null) {
                lat = ll.getLat();
                tLat = Math.max(tLat, lat);
                bLat = Math.min(bLat, lat);
                j2 = j;
                break;
            }
            --j;
        }
        double dlon = 0.0;
        if (tLat < 90.0 && bLat > -90.0) {
            double r = Math.abs((double)j1 - hOver2);
            for (int i = 5; i < 90; i += 5) {
                double rCos = r * Math.cos(Math.toRadians(i));
                double rSin = r * Math.sin(Math.toRadians(i));
                PointLL ll1 = this.transformXY2LL(wOver2 + rCos - 1.0, hOver2 + rSin - 1.0);
                PointLL ll2 = this.transformXY2LL(wOver2 - rCos + 1.0, hOver2 - rSin + 1.0);
                dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ > ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            }
        }
        int i = 0;
        while ((double)i < wOver2) {
            double lat2;
            PointLL ll1 = this.transformXY2LL(wOver2 + (double)i, (double)j1 + 0.5);
            PointLL ll2 = this.transformXY2LL(wOver2 + (double)i, (double)j2 + 0.5);
            if (ll1 == null && ll2 == null) break;
            if (ll1 == null) {
                dlon1 = 0.0;
            } else {
                lat2 = ll1.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon1 = this.lambdaC_ > ll1.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll1.getLon());
            }
            if (ll2 == null) {
                dlon2 = 0.0;
            } else {
                lat2 = ll2.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon2 = this.lambdaC_ > ll2.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll2.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll2.getLon());
            }
            dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            ++i;
        }
        double dlat = Math.max(Math.abs(this.phiC_ - tLat), Math.abs(this.phiC_ - bLat));
        double llTop = Math.min(90.0, tLat);
        double llBottom = Math.max(-90.0, bLat);
        if (tLat > 89.5 || bLat < -89.5 || dlon > 180.0) {
            dlon = 180.0;
        } else {
            PointLL ll1;
            dlon = Math.max(dlon, dlat);
            int i1 = 0;
            int i2 = 0;
            while ((double)i2 < wOver2) {
                ll1 = this.transformXY2LL((double)i2, hOver2);
                if (ll1 != null) {
                    dlon1 = this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon());
                    dlon = Math.max(dlon, dlon1);
                    i1 = i2;
                    break;
                }
                ++i2;
            }
            int j3 = 0;
            while ((double)j3 < hOver2) {
                ll1 = this.transformXY2LL((double)i1, hOver2 - (double)j3 + 0.5);
                PointLL ll2 = this.transformXY2LL((double)i1, hOver2 + (double)j3 + 0.5);
                if (ll1 == null && ll2 == null) break;
                dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
                ++j3;
            }
        }
        double llLeft = this.lambdaC_ - dlon;
        double llRight = this.lambdaC_ + dlon;
        if (llRight - llLeft > 300.0) {
            llLeft = -180.0;
            llRight = 180.0;
        } else if (llLeft < -180.0) {
            llLeft += 360.0;
            llRight += 360.0;
        }
        return new LonLatBounds(llLeft, llTop, llRight, llBottom);
    }
}

