/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CantersPseudocylindricW34
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Canters Pseudocylindric W34";
    private static final double CP1 = 1.1481;
    private static final double CP3 = -0.0753;
    private static final double CP5 = -0.015;
    private static final double THREE_CP3 = -0.22590000000000002;
    private static final double FIVE_CP5 = -0.075;
    private static final double PI2_OVER_4 = 2.4674011002723395;
    private static final double PI4_OVER_16 = 6.088068189625152;
    private static final double WIDTH_FACTOR = 2.736340609345696;
    private static final double HEIGHT_FACTOR = 1.368137956296798;

    public CantersPseudocylindricW34(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPseudocylindricW34(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public CantersPseudocylindricW34(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.736340609345696, 1.368137956296798);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double capX = lambdaRad * cosPhi;
        double capY = phiRad;
        double capY2 = capY * capY;
        double capY4 = capY2 * capY2;
        double yp = (1.1481 + -0.0753 * capY2 + -0.015 * capY4) * capY;
        double dyp = 1.1481 + -0.22590000000000002 * capY2 + -0.075 * capY4;
        double xp = capX / dyp;
        double x = (double)this.outCenterX_ + xp * this.rS_;
        double y = (double)this.outCenterY_ - yp * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double capY4;
        double capY2;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yp = y * this.invRS_;
        double capY = 1.5707963267948966 * yp / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            capY2 = capY * capY;
            capY4 = capY2 * capY2;
            double func = (1.1481 + -0.0753 * capY2 + -0.015 * capY4) * capY;
            double dfunc = 1.1481 + -0.22590000000000002 * capY2 + -0.075 * capY4;
            double dCapY = -(func - yp) / dfunc;
            capY += dCapY;
            if (Math.abs(dCapY) < 1.0E-5) break;
        }
        if ((phiRad = capY) >= 1.5707963267948966) {
            return null;
        }
        double xp = x * this.invRS_;
        capY2 = capY * capY;
        capY4 = capY2 * capY2;
        double dyp = 1.1481 + -0.22590000000000002 * capY2 + -0.075 * capY4;
        double capX = xp * dyp;
        double lambdaRad = capX / Math.cos(phiRad);
        if (lambdaRad > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPseudocylindricW34 cantersPseudocylindricW34 = this;
        synchronized (cantersPseudocylindricW34) {
            double y;
            double capY = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double xp;
                double capX;
                double lambdaRad;
                double phiRad;
                double capY4;
                double capY2;
                double yp = y * this.invRS_;
                capY += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    capY2 = capY * capY;
                    capY4 = capY2 * capY2;
                    double func = (1.1481 + -0.0753 * capY2 + -0.015 * capY4) * capY;
                    double dfunc = 1.1481 + -0.22590000000000002 * capY2 + -0.075 * capY4;
                    double dCapY = -(func - yp) / dfunc;
                    capY += dCapY;
                    if (Math.abs(dCapY) < 1.0E-5) break;
                }
                if ((phiRad = capY) >= 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                capY2 = capY * capY;
                capY4 = capY2 * capY2;
                double dyp = 1.1481 + -0.22590000000000002 * capY2 + -0.075 * capY4;
                double xFactor = 1.0 / Math.cos(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (capX = (xp = (x = (double)ix + 0.5) * this.invRS_) * dyp) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

