/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;
import java.awt.Dimension;

public class BreusingHarmonic2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Breusing Harmonic (Two-Hemisphere)";
    public static final int PROPERTIES = 0x2200040;
    private static final double CONST_B = 3.3473373961;
    private static final double RADIUS_FACTOR = 3.3473373961 * Math.tan(0.39269908169872414);

    public BreusingHarmonic2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public BreusingHarmonic2H(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BreusingHarmonic2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2200040, width, height, xmargin, ymargin, RADIUS_FACTOR);
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        if (cosZ == 1.0) {
            return 0.0;
        }
        double z = Math.acos(cosZ);
        double quarterZ = 0.25 * z;
        return 3.3473373961 * Math.tan(quarterZ) / Math.sin(z);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return 4.0 * Math.atan(rhoRS * this.invRS_ / 3.3473373961);
    }
}

