/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.TwoHemisphereGlobularProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class BaconGlobular2H
extends TwoHemisphereGlobularProjection {
    public static final String PROJECTION_NAME = "Bacon Globular (Two-Hemisphere)";
    public static final int PROPERTIES = 0x6000008;
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public BaconGlobular2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public BaconGlobular2H(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BaconGlobular2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x6000008, width, height, xmargin, ymargin, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double y = 1.5707963267948966 * Math.sin(phiRad);
        double x = 0.0;
        if (absLambdaRad != 0.0) {
            double f = 0.5 * (absLambdaRad + 2.4674011002723395 / absLambdaRad);
            x = absLambdaRad - f + Math.sqrt(f * f - y * y);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = Math.asin(yOverRS * 0.6366197723675814);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double y2OverR2S2 = yOverRS * yOverRS;
        double lambdaRad = 0.0;
        if (x != 0.0) {
            double xOverRS = Math.abs(x) * this.invRS_;
            lambdaRad = Math.abs(phiRad) < 1.5707963267948966 ? 0.7853981633974483 : 2.356194490192345;
            for (int iter = 0; iter < 33; ++iter) {
                double lambdaRad2 = lambdaRad * lambdaRad;
                double f = 0.5 * (lambdaRad + 2.4674011002723395 / lambdaRad);
                double sqrtTerm = Math.sqrt(f * f - y2OverR2S2);
                double dfDLambda = 0.5 * (1.0 - 2.4674011002723395 / lambdaRad2);
                double func = lambdaRad - f + sqrtTerm - xOverRS;
                double dfunc = 1.0 - dfDLambda + f * dfDLambda / sqrtTerm;
                double dlambdaRad = -func / dfunc;
                lambdaRad += dlambdaRad;
                if (Math.abs(dlambdaRad) < 1.0E-5) break;
            }
            if (lambdaRad > 1.5707963267948966) {
                return null;
            }
            if (x < 0.0) {
                lambdaRad = -lambdaRad;
            }
        }
        if (!leftside) {
            lambdaRad += Math.PI;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BaconGlobular2H baconGlobular2H = this;
        synchronized (baconGlobular2H) {
            double y;
            double yOverRS;
            double phiRad;
            block3: for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin((yOverRS = (y = (double)iy + 0.5) * this.invRS_) * 0.6366197723675814)) > 1.5707963267948966); ++iy) {
                double phiP = Math.toDegrees(phiRad);
                double y2OverR2S2 = yOverRS * yOverRS;
                double lambdaRad = phiP < 90.0 ? 1.0E-5 : 1.5708063267948966;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    for (int iter = 0; iter < 33; ++iter) {
                        double lambdaRad2 = lambdaRad * lambdaRad;
                        double f = 0.5 * (lambdaRad + 2.4674011002723395 / lambdaRad);
                        double sqrtTerm = Math.sqrt(f * f - y2OverR2S2);
                        double dfDLambda = 0.5 * (1.0 - 2.4674011002723395 / lambdaRad2);
                        double func = lambdaRad - f + sqrtTerm - xOverRS;
                        double dfunc = 1.0 - dfDLambda + f * dfDLambda / sqrtTerm;
                        double dlambdaRad = -func / dfunc;
                        lambdaRad += dlambdaRad;
                        if (Math.abs(dlambdaRad) < 1.0E-5) break;
                    }
                    if (lambdaRad > 1.5707963267948966) continue block3;
                    double lambdaP = Math.toDegrees(lambdaRad);
                    this.setEightPoints(ix, iy, lambdaP, phiP);
                }
            }
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lambdaCH = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            Point2D.Double east = this.transformLL2XY(lambdaCH + 89.99999, lat);
            Point2D.Double west = this.transformLL2XY(lambdaCH + -89.99999, lat);
            if (east == null && west == null) {
                return;
            }
            GraphicUtils.drawLine(g2d, west, east);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambda = this.lonToLambda(lon);
        if (Math.abs(lambda) == 90.0) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

