/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;

public class AzimuthalFarSidePerspective
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Azimuthal Far-Side Perspective";
    public static final int PROPERTIES = 0x200040;
    private static final double DEFAULT_RADIUS = 90.0;
    private static final double MAX_RADIUS = 90.0;
    private static final double DEFAULT_D = 1.7071067811865475;
    private ProjDoubleParameter distParam_ = new ProjDoubleParameter("Distance between point of projection and center of body", "Proj. pt. distance", "Radii (D\u22651)", 1.7071067811865475, 1.0, Double.POSITIVE_INFINITY, true, true);
    private double dPerspective_ = 1.7071067811865475;

    public AzimuthalFarSidePerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalFarSidePerspective(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public AzimuthalFarSidePerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.distParam_);
        this.addEdgeRadiusParameter(90.0, 90.0, true);
        this.setFillCorners(true);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.distParam_) {
            this.setProjPointDistance(this.distParam_.getValue());
        }
    }

    public void setProjPointDistance(double d) {
        this.dPerspective_ = d;
        this.autoscale();
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double cosZ = Math.cos(this.radiusRad_);
        double sinZ = Math.sin(this.radiusRad_);
        double rhoMaxOverR = this.dPerspective_ * sinZ / (this.dPerspective_ + cosZ);
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rS_;
        this.rhoBorder2_ = this.rS_ * this.rS_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < 0.0) {
            return -1.0;
        }
        return this.dPerspective_ / (this.dPerspective_ + cosZ);
    }

    @Override
    protected final double getZForRhoRS(double rhoRS) {
        double rho = rhoRS * this.invRS_;
        double dOverRho = this.dPerspective_ / rho;
        double z = rho;
        for (int iter = 0; iter < 33; ++iter) {
            double sinZ = Math.sin(z);
            double cosZ = Math.cos(z);
            double func = this.dPerspective_ + cosZ - dOverRho * sinZ;
            double dfunc = -sinZ - dOverRho * cosZ;
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

