/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;
import java.awt.Dimension;

public class AzimuthalEquidistant2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Azimuthal Equidistant (Two-Hemisphere)";
    public static final int PROPERTIES = 0x2200040;
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public AzimuthalEquidistant2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalEquidistant2H(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public AzimuthalEquidistant2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2200040, width, height, xmargin, ymargin, 1.5707963267948966);
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        if (cosZ == 1.0) {
            return 0.0;
        }
        double z = Math.acos(cosZ);
        return z / Math.sin(z);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return rhoRS * this.invRS_;
    }
}

