/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;

public class AzimuthalEquidistant
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Azimuthal Equidistant";
    private static final double DEFAULT_RADIUS = 90.0;
    private static final double MAX_RADIUS = 180.0;

    public AzimuthalEquidistant(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalEquidistant(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public AzimuthalEquidistant(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(90.0, 180.0, true);
        this.addFillParameter();
        this.parameterChanged(null);
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = this.radiusRad_;
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = Math.PI;
            this.rhoBorder_ = Math.PI * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ == 1.0) {
            return 0.0;
        }
        if (cosZ == -1.0) {
            return -1.0;
        }
        double z = Math.acos(cosZ);
        return z / Math.sin(z);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return rhoRS * this.invRS_;
    }
}

