/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;

public class Airy
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Airy";
    private static final double MAX_RADIUS = 150.0;
    private static final double MAX_RADIUS_RAD = Math.toRadians(150.0);
    private static final double DEFAULT_RADIUS = 90.0;
    private double constB_;

    public Airy(int width, int height) {
        this(width, height, 0, 0);
    }

    public Airy(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Airy(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(90.0, 150.0, false);
        this.addFillParameter();
        this.parameterChanged(null);
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        double halfBeta_ = 0.5 * this.radiusRad_;
        double cosHalfBeta_ = Math.cos(halfBeta_);
        double secHalfBeta_ = 1.0 / cosHalfBeta_;
        double lnSecHalfBeta_ = Math.log(secHalfBeta_);
        double tanHalfBeta = Math.tan(halfBeta_);
        double tansqHalfBeta_ = tanHalfBeta * tanHalfBeta;
        double cotsqHalfBeta_ = 1.0 / tansqHalfBeta_;
        this.constB_ = cotsqHalfBeta_ * lnSecHalfBeta_;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double halfZ = 0.5 * Math.toRadians(this.radiusDeg_);
        double cosHalfZ = Math.cos(halfZ);
        double tanHalfZ = Math.tan(halfZ);
        double secHalfZ = 1.0 / cosHalfZ;
        double cotHalfZ = 1.0 / tanHalfZ;
        double lnSecHalfZ = Math.log(secHalfZ);
        double rhoMaxOverR = 2.0 * (cotHalfZ * lnSecHalfZ + tanHalfZ * this.constB_);
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double halfZ = 0.5 * Math.toRadians(150.0);
            double cosHalfZ = Math.cos(halfZ);
            double tanHalfZ = Math.tan(halfZ);
            double secHalfZ = 1.0 / cosHalfZ;
            double cotHalfZ = 1.0 / tanHalfZ;
            double lnSecHalfZ = Math.log(secHalfZ);
            double rhoBOverR = 2.0 * (cotHalfZ * lnSecHalfZ + tanHalfZ * this.constB_);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ == 1.0) {
            return 0.5 * (1.0 + this.constB_);
        }
        double onePCosZ = 1.0 + cosZ;
        double oneMCosZ = 1.0 - cosZ;
        return -Math.log(0.5 * onePCosZ) / oneMCosZ + 2.0 * this.constB_ / onePCosZ;
    }

    @Override
    protected final double getZForRhoRS(double rhoRS) {
        double rho = rhoRS * this.invRS_;
        double z = this.fillCorners_ ? rhoRS * MAX_RADIUS_RAD / this.rhoBorder_ : rhoRS * this.radiusRad_ / this.rhoBorder_;
        for (int iter = 0; iter < 33; ++iter) {
            double dfunc;
            double halfZ = 0.5 * z;
            double cosHalfZ = Math.cos(halfZ);
            double secHalfZ = 1.0 / cosHalfZ;
            double sec2HalfZ = secHalfZ * secHalfZ;
            double lnSecHalfZ = Math.log(secHalfZ);
            double sinHalfZ = Math.sin(halfZ);
            double sinsqHalfZ = sinHalfZ * sinHalfZ;
            double cscsqHalfZ = 1.0 / sinsqHalfZ;
            double tanHalfZ = Math.tan(halfZ);
            double cotHalfZ = 1.0 / tanHalfZ;
            double func = 2.0 * (cotHalfZ * lnSecHalfZ + this.constB_ * tanHalfZ) - rho;
            double dz = -func / (dfunc = -cscsqHalfZ * lnSecHalfZ + 1.0 + this.constB_ * sec2HalfZ);
            if (Double.isNaN(dz)) {
                z = this.radiusRad_ - Math.PI / 180;
                continue;
            }
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

