/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.OverlayFactory;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.OverlayResourceListEntry;
import gov.nasa.giss.util.ResourceList;
import gov.nasa.giss.util.ResourceListEntry;
import java.io.File;

public class OverlayResourceList
extends ResourceList {
    private static final String RESOURCE_DESC = "map overlay";
    private static final String RESOURCE_DESC_PLURAL = "map overlays";
    private static final String RESOURCES_DIR = "resources";
    private static final String APP_SUPPORT_DIR = "overlays";

    public OverlayResourceList() {
        super(new OverlayFilenameFilter());
        this.scanJarDirectory(OverlayResourceList.class, RESOURCES_DIR);
        this.scanAppSupportDirectory(APP_SUPPORT_DIR);
    }

    @Override
    public String getResourceDescription() {
        return RESOURCE_DESC;
    }

    @Override
    public String getResourceDescriptionPlural() {
        return RESOURCE_DESC_PLURAL;
    }

    @Override
    public String getAppSupportDirectoryName() {
        return APP_SUPPORT_DIR;
    }

    @Override
    protected Object createObject(File f) {
        try {
            return OverlayFactory.open(f);
        }
        catch (Exception exc) {
            System.err.printf("WARNING: Could not create object: %s%n", exc.toString());
            return null;
        }
    }

    @Override
    protected ResourceListEntry createSetEntry(ResourceListEntry.LocType loctype, Object link, Object o) {
        if (o != null && !(o instanceof MapOverlay)) {
            throw new IllegalArgumentException("Object is not a " + this.getResourceDescription());
        }
        return new OverlayResourceListEntry(loctype, link, o);
    }
}

