/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.overlay.OutlineArea;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.overlay.OutlineSegment;
import gov.nasa.giss.math.PointLL;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GissOverlay
extends OutlineOverlay {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public GissOverlay(File f) throws FileNotFoundException, IOException {
        super(f);
    }

    public GissOverlay(URL url) throws IOException {
        super(url);
    }

    public GissOverlay(byte[] bytes, String id) throws IOException {
        super(bytes, id);
    }

    @Override
    protected boolean readHeader(InputStream istream) throws IOException {
        return true;
    }

    @Override
    protected void readFullContent(InputStream istream) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(istream);
             BufferedReader br = new BufferedReader(isr);){
            this.readMyContent(br);
        }
    }

    private void readMyContent(BufferedReader bReader) throws IOException {
        OutlineArea area = new OutlineArea();
        OutlineSegment segment = new OutlineSegment(OutlineSegment.SegmentType.SHAPES);
        String aLine = "";
        int icount = 0;
        while ((aLine = bReader.readLine()) != null) {
            ++icount;
            int commaAt = aLine.indexOf(44);
            if (commaAt > -1) {
                try {
                    double lon = Double.parseDouble(aLine.substring(0, commaAt));
                    double lat = Double.parseDouble(aLine.substring(commaAt + 1));
                    segment.addPoint(new PointLL(lon, lat));
                }
                catch (Exception ignore) {
                    LOGGER.warn("Bad outline point at line {}", (Object)icount);
                    if (segment.size() > 1) {
                        area.addSegment(segment);
                    }
                    if (area.size() > 0) {
                        this.addArea(area);
                    }
                    area = new OutlineArea();
                    segment = new OutlineSegment(OutlineSegment.SegmentType.SHAPES);
                }
                continue;
            }
            if (segment.size() > 1) {
                area.addSegment(segment);
            }
            if (area.size() > 0) {
                this.addArea(area);
            }
            area = new OutlineArea();
            segment = new OutlineSegment(OutlineSegment.SegmentType.SHAPES);
        }
        if (segment.size() > 1) {
            area.addSegment(segment);
        }
        if (area.size() > 0) {
            this.addArea(area);
        }
        this.setContentRead();
    }
}

