/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.Stereographic;

public class NcArrayLonLatStereographic
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private ProjectionImpl njProj_;
    private double cosPhiC_;
    private double sinPhiC_;

    public NcArrayLonLatStereographic(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.STEREOGRAPHIC);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.STEREOGRAPHIC)) {
            throw new NcException("Variable is not projected type stereographic.");
        }
        this.initGissProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (!(pj instanceof Stereographic)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of Stereographic");
        }
        this.njProj_ = pj;
    }

    private final void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("stereographic") && !this.mappingName_.equalsIgnoreCase("polar_stereographic")) {
            throw new NcException("Mapping name is not stereographic or polar_stereographic");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        if (this.mappingName_.equalsIgnoreCase("polar_stereographic")) {
            Attribute stdparA = this.mappingVarDS_.findAttribute("standard_parallel");
            Attribute sfactorA = this.mappingVarDS_.findAttribute("scale_factor_at_projection_origin");
            if (stdparA != null) {
                double stdpar = stdparA.getNumericValue().doubleValue();
                double sinSP = Math.abs(Math.sin(Math.toRadians(stdpar)));
                double ss = 0.5 * (1.0 + sinSP);
                if (sfactorA == null) {
                    this.setScalingFactor(ss);
                } else {
                    LOGGER.trace("Mapping var is polar stereographic and has both scale factor and standard parallel.");
                    if (Math.abs(this.sfactor_) == 90.0) {
                        LOGGER.warn("Specified scale factor is set to pole latitude...");
                        LOGGER.warn("Replacing it with calculated value.");
                        this.setScalingFactor(ss);
                    } else if (ss != this.sfactor_) {
                        LOGGER.warn("Specified scale factor {} does not match value calculayed from std par {}", (Object)this.sfactor_, (Object)stdpar);
                        LOGGER.warn("calculated factor is {}", (Object)ss);
                        this.setScalingFactor(ss);
                    }
                }
            }
        }
        double phiCRad = Math.toRadians(this.phiC_);
        this.cosPhiC_ = Math.cos(phiCRad);
        this.sinPhiC_ = Math.sin(phiCRad);
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = Math.toRadians(lon - this.lambdaC_);
        double phiRad = Math.toRadians(lat);
        double cosLambda = Math.cos(lambdaRad);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double k = 2.0 / (1.0 + this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda);
        if (k > 2.0) {
            return null;
        }
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        return new Point2D.Double(x * this.rS_ + this.falseEasting_, y * this.rS_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double rho = Math.hypot(xx, yy);
        double z = 2.0 * Math.atan(rho * 0.5 * this.oneOverRS_);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(xx * sinZ, rho * this.cosPhiC_ * cosZ - yy * this.sinPhiC_ * sinZ);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }
}

