/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcCartesianVarType;
import gov.nasa.giss.data.nc.NcDiscreteVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArrayDiscreteTrajectory;
import gov.nasa.giss.data.nc.array.NcArrayLatTime;
import gov.nasa.giss.data.nc.array.NcArrayLatVert;
import gov.nasa.giss.data.nc.array.NcArrayLonLatAuxiliary2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatAuxiliary3D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCartesian;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereCAMSE;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereGMAO;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReducedCF;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReducedISCCP;
import gov.nasa.giss.data.nc.array.NcArrayLonTime;
import gov.nasa.giss.data.nc.array.NcArrayLonVert;
import gov.nasa.giss.data.nc.array.NcArrayTimeLat;
import gov.nasa.giss.data.nc.array.NcArrayTimeVert;
import gov.nasa.giss.data.nc.array.NcArrayXY;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatAlbersEqualAreaConic;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatAzimuthalEqualArea;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatAzimuthalEquidistant;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatCylindricalEqualArea;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatGeostationary;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatLambertConformalConic;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatMSGNavigation;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatMercator;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatRotatedPole;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatSinusoidal;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatStereographic;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatTransverseMercator;
import gov.nasa.giss.data.nc.array.projected.NcArrayLonLatUTM;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NcArrayFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static NcArray create1D(NcVariable ncvar, Object axisInfo) throws NcException {
        LOGGER.trace("{}", (Object)ncvar.getClass());
        if (!ncvar.isGriddable1D()) {
            throw new IllegalArgumentException("Variable has no independent dimensions");
        }
        if (axisInfo != null) {
            return new NcArray1D(ncvar, axisInfo);
        }
        return new NcArray1D(ncvar, 0);
    }

    public static NcArray createGeneral2D(NcVariable ncvar, Object xaxisInfo, Object yaxisInfo) throws NcException {
        LOGGER.trace("{}", (Object)ncvar.getClass());
        LOGGER.trace("x {}, y {}", xaxisInfo, yaxisInfo);
        if (!ncvar.isGriddable2D()) {
            throw new IllegalArgumentException("Variable does not have two independent dimensions");
        }
        return new NcArrayXY(ncvar, xaxisInfo, yaxisInfo);
    }

    public static NcArray createGeo2D(NcVariable ncvar, NcAxisType xaxisType, NcAxisType yaxisType) throws NcException {
        LOGGER.trace("{}", (Object)ncvar.getClass());
        if (!ncvar.isGriddable2DGeo()) {
            throw new IllegalArgumentException("Variable does not appear to have at least two georeferenced dimensions");
        }
        NcVarType varType = ncvar.getVarType();
        if (xaxisType == NcAxisType.LON && yaxisType == NcAxisType.LAT) {
            if (varType instanceof NcAltGriddingVarType) {
                return NcArrayFactory.createAltLonLat(ncvar);
            }
            if (varType instanceof NcCartesianVarType) {
                if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.LAT)) {
                    return new NcArrayLonLatCartesian(ncvar);
                }
                throw new IllegalArgumentException("Variable does not seem to have lon and lat dimensions.");
            }
            throw new IllegalArgumentException("Could not determine appropriate lon-lat gridding array");
        }
        if (xaxisType == NcAxisType.LAT && yaxisType == NcAxisType.TIME) {
            if (ncvar.hasAxesOfType(NcAxisType.LAT, NcAxisType.TIME)) {
                return new NcArrayLatTime(ncvar);
            }
            throw new IllegalArgumentException("Variable does not seem to have both lat and time dimensions.");
        }
        if (xaxisType == NcAxisType.LON && yaxisType == NcAxisType.TIME) {
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.TIME)) {
                return new NcArrayLonTime(ncvar);
            }
            throw new IllegalArgumentException("Variable does not seem to have both lon and time dimensions.");
        }
        if (xaxisType == NcAxisType.LAT && yaxisType == NcAxisType.VERT) {
            if (ncvar.hasAxesOfType(NcAxisType.LAT, NcAxisType.VERT)) {
                return new NcArrayLatVert(ncvar);
            }
            throw new IllegalArgumentException("Variable does not seem to have both lat and vert dimensions.");
        }
        if (xaxisType == NcAxisType.LON && yaxisType == NcAxisType.VERT) {
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.VERT)) {
                return new NcArrayLonVert(ncvar);
            }
            throw new IllegalArgumentException("Variable does not seem to have both lon and vert dimensions.");
        }
        if (xaxisType == NcAxisType.TIME && yaxisType == NcAxisType.LAT) {
            if (ncvar.hasAxesOfType(NcAxisType.LAT, NcAxisType.TIME)) {
                return new NcArrayTimeLat(ncvar);
            }
            throw new IllegalArgumentException("Variable does not seem to have both time and lat dimensions.");
        }
        if (xaxisType == NcAxisType.TIME && yaxisType == NcAxisType.VERT) {
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.VERT)) {
                return new NcArrayTimeVert(ncvar);
            }
            throw new IllegalArgumentException("Variable does not seem to have both time and vert dimensions.");
        }
        throw new NcException("Available dimensions do not match requested array type.");
    }

    public static NcArray createGeoDiscrete(NcVariable ncvar) throws NcException {
        LOGGER.trace("{}", (Object)ncvar.getClass());
        NcVarType varType = ncvar.getVarType();
        LOGGER.trace("varType {}", (Object)varType);
        if (!(varType instanceof NcDiscreteVarType)) {
            throw new IllegalArgumentException("Var type is not discrete.");
        }
        NcDiscreteVarType dvtype = (NcDiscreteVarType)varType;
        if (dvtype.isTrajectory()) {
            return new NcArrayDiscreteTrajectory(ncvar);
        }
        throw new NcException("Discrete var type, but not one for which we can create an array.");
    }

    private static NcArray createAltLonLat(NcVariable ncvar) throws NcException {
        NcVarType varType = ncvar.getVarType();
        NcAltGridding pid = ((NcAltGriddingVarType)varType).getGrid();
        LOGGER.trace("pid {}", (Object)pid);
        if (pid.isProjected()) {
            LOGGER.trace("Appears to be alt 2D projected.");
            boolean tryAuxiliary = false;
            try {
                switch (pid) {
                    case ALBERS_CONIC: {
                        return new NcArrayLonLatAlbersEqualAreaConic(ncvar);
                    }
                    case AZIM_EQUAL_AREA: {
                        return new NcArrayLonLatAzimuthalEqualArea(ncvar);
                    }
                    case AZIM_EQUIDISTANT: {
                        return new NcArrayLonLatAzimuthalEquidistant(ncvar);
                    }
                    case CYL_EQUAL_AREA: {
                        return new NcArrayLonLatCylindricalEqualArea(ncvar);
                    }
                    case GEOSTATIONARY: {
                        return new NcArrayLonLatGeostationary(ncvar);
                    }
                    case LAMBERT_CONFORMAL: {
                        return new NcArrayLonLatLambertConformalConic(ncvar);
                    }
                    case MERCATOR: {
                        return new NcArrayLonLatMercator(ncvar);
                    }
                    case MSG_NAV: {
                        return new NcArrayLonLatMSGNavigation(ncvar);
                    }
                    case ROTATED_POLE: {
                        return new NcArrayLonLatRotatedPole(ncvar);
                    }
                    case SINUSOIDAL: {
                        return new NcArrayLonLatSinusoidal(ncvar);
                    }
                    case STEREOGRAPHIC: {
                        return new NcArrayLonLatStereographic(ncvar);
                    }
                    case TRANSVERSE_MERCATOR: {
                        return new NcArrayLonLatTransverseMercator(ncvar);
                    }
                    case UTM: {
                        return new NcArrayLonLatUTM(ncvar);
                    }
                }
                throw new NcException("No array handler available for proj lon-lat type " + (Object)((Object)pid));
            }
            catch (NcException exc) {
                String msg;
                LOGGER.debug("NcException creating proj grid array: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                if ((msg = exc.getMessage()).equals("Grid mapping variable was not found") || msg.equals("Grid mapping variable has no mapping name")) {
                    tryAuxiliary = true;
                }
                throw exc;
            }
            catch (Exception exc) {
                LOGGER.debug("Exception creating proj grid array: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw exc;
            }
            if (tryAuxiliary) {
                LOGGER.trace("Do we try aux 2D or 3D?");
                if (NcArrayLonLatAuxiliary2D.canGridVariable(ncvar)) {
                    LOGGER.trace("Trying 2D");
                    return new NcArrayLonLatAuxiliary2D(ncvar);
                }
                if (NcArrayLonLatAuxiliary3D.canGridVariable(ncvar)) {
                    LOGGER.trace("Trying3D");
                    return new NcArrayLonLatAuxiliary3D(ncvar);
                }
                LOGGER.trace("No. Not aux.");
            }
            throw new NcException("No known array handler for proj lon-lat type " + (Object)((Object)pid));
        }
        switch (pid) {
            case AUXILIARY_2D: {
                return new NcArrayLonLatAuxiliary2D(ncvar);
            }
            case AUXILIARY_3D: {
                return new NcArrayLonLatAuxiliary3D(ncvar);
            }
            case CUBED_SPHERE_SIMPLE: {
                return new NcArrayLonLatCubedSphereGMAO(ncvar);
            }
            case CUBED_SPHERE_CAM_SE: {
                return new NcArrayLonLatCubedSphereCAMSE(ncvar);
            }
            case REDUCED_1: {
                return new NcArrayLonLatReducedCF(ncvar);
            }
            case REDUCED_2: {
                return new NcArrayLonLatReduced2D(ncvar);
            }
            case REDUCED_ISCCP: {
                return new NcArrayLonLatReducedISCCP(ncvar);
            }
        }
        throw new NcException("No knownarray handler for alt lon-lat type " + (Object)((Object)pid));
    }

    private NcArrayFactory() {
    }
}

