/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.logging.Level;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class EquidistantCylindrical
extends MapProjection {
    private static final long serialVersionUID = -848975059471102069L;
    private final double cosStandardParallel;
    protected final double standardParallel;

    protected EquidistantCylindrical(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List<GeneralParameterDescriptor> expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.STANDARD_PARALLEL_1)) {
            this.standardParallel = Math.abs(this.doubleValue(expected, Provider.STANDARD_PARALLEL_1, parameters));
            EquidistantCylindrical.ensureLatitudeInRange(Provider.STANDARD_PARALLEL_1, this.standardParallel, false);
            this.cosStandardParallel = Math.cos(this.standardParallel);
        } else {
            this.standardParallel = 0.0;
            this.cosStandardParallel = 1.0;
        }
        assert (this.latitudeOfOrigin == 0.0) : this.latitudeOfOrigin;
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.standardParallel)) {
            List<GeneralParameterDescriptor> expected = this.getParameterDescriptors().descriptors();
            this.set(expected, Provider.STANDARD_PARALLEL_1, values, this.standardParallel);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        x *= this.cosStandardParallel;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        x /= this.cosStandardParallel;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.standardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            EquidistantCylindrical that = (EquidistantCylindrical)object;
            return EquidistantCylindrical.equals(this.standardParallel, that.standardParallel);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SphericalProvider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 8929981563074475828L;
        static final ParameterDescriptorGroup PARAMETERS = SphericalProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Equidistant Cylindrical (Spherical)"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(62))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, FALSE_EASTING, FALSE_NORTHING});

        public SphericalProvider() {
            super(PARAMETERS);
        }

        public Class<CylindricalProjection> getOperationType() {
            return CylindricalProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            return new EquidistantCylindrical(parameters){

                public ParameterDescriptorGroup getParameterDescriptors() {
                    return PARAMETERS;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -278288251842178001L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Equidistant_Cylindrical"), new NamedIdentifier(Citations.EPSG, "Equidistant Cylindrical"), new NamedIdentifier(Citations.ESRI, "Equidistant_Cylindrical"), new NamedIdentifier(Citations.EPSG, "9823"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(62))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<CylindricalProjection> getOperationType() {
            return CylindricalProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            if (!Provider.isSpherical(parameters)) {
                MapProjection.LOGGER.log(Level.FINE, "GeoTools EquidistantCylindrical is defined only on the sphere, we're going to use spherical equations even if the projection is using an ellipsoid");
            }
            return new EquidistantCylindrical(parameters);
        }
    }
}

