/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.registry.RIFRegistry;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.logging.Logging;

public final class Registry {
    public static final String JAI_TOOLS_PRODUCT = "jaitools.media.jai";
    public static final String GEOTOOLS_PRODUCT = "org.geotools";

    private Registry() {
    }

    public static synchronized void setNativeAccelerationAllowed(String operation, boolean allowed, JAI jai) {
        String product = "com.sun.media.jai";
        OperationRegistry registry = jai.getOperationRegistry();
        List factories = registry.getOrderedFactoryList("rendered", operation, "com.sun.media.jai");
        if (factories != null) {
            RenderedImageFactory javaFactory = null;
            RenderedImageFactory nativeFactory = null;
            Boolean currentState = null;
            for (RenderedImageFactory factory : factories) {
                String pack = factory.getClass().getPackage().getName();
                if (pack.equals("com.sun.media.jai.mlib")) {
                    nativeFactory = factory;
                    if (javaFactory != null) {
                        currentState = Boolean.FALSE;
                    }
                }
                if (!pack.equals("com.sun.media.jai.opimage")) continue;
                javaFactory = factory;
                if (nativeFactory == null) continue;
                currentState = Boolean.TRUE;
            }
            if (currentState != null && currentState != allowed) {
                RIFRegistry.unsetPreference(registry, operation, "com.sun.media.jai", allowed ? javaFactory : nativeFactory, allowed ? nativeFactory : javaFactory);
                RIFRegistry.setPreference(registry, operation, "com.sun.media.jai", allowed ? nativeFactory : javaFactory, allowed ? javaFactory : nativeFactory);
                LogRecord record = Loggings.format(Level.CONFIG, 31, operation, allowed ? 1 : 0);
                Registry.log("setNativeAccelerationAllowed", record);
            }
        }
    }

    public static void setNativeAccelerationAllowed(String operation, boolean allowed) {
        Registry.setNativeAccelerationAllowed(operation, allowed, JAI.getDefaultInstance());
    }

    public static boolean registerRIF(JAI jai, OperationDescriptor descriptor, String name, ContextualRenderedImageFactory crif) {
        OperationRegistry registry = jai.getOperationRegistry();
        try {
            registry.registerDescriptor(descriptor);
            registry.registerFactory("rendered", name, GEOTOOLS_PRODUCT, crif);
            return true;
        }
        catch (IllegalArgumentException exception) {
            LogRecord record = Loggings.format(Level.SEVERE, 10, name);
            record.setSourceClassName(GridSampleDimension.class.getName());
            record.setSourceMethodName("<classinit>");
            record.setThrown(exception);
            record.setLoggerName(AbstractGridCoverage.LOGGER.getName());
            AbstractGridCoverage.LOGGER.log(record);
            return false;
        }
    }

    public static boolean registerRIF(JAI jai, OperationDescriptor descriptor, RenderedImageFactory rif, String productName) {
        OperationRegistry registry = jai.getOperationRegistry();
        try {
            new ParameterBlockJAI(descriptor.getName());
            return false;
        }
        catch (Exception e) {
            registry.registerDescriptor(descriptor);
            String descName = descriptor.getName();
            registry.registerFactory("rendered", descName, productName, rif);
            return true;
        }
    }

    private static void log(String method, LogRecord record) {
        record.setSourceClassName(Registry.class.getName());
        record.setSourceMethodName(method);
        Logger logger = Logging.getLogger(Registry.class);
        record.setLoggerName(logger.getName());
        logger.log(record);
    }
}

