/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExtractBoundsFilterVisitor
extends NullFilterVisitor {
    public static NullFilterVisitor BOUNDS_VISITOR = new ExtractBoundsFilterVisitor();
    private static Logger LOGGER = Logging.getLogger("org.geotools.index.rtree");

    protected ExtractBoundsFilterVisitor() {
    }

    private ReferencedEnvelope bbox(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)data;
        }
        if (data instanceof Envelope) {
            return new ReferencedEnvelope((Envelope)data, null);
        }
        if (data instanceof CoordinateReferenceSystem) {
            return new ReferencedEnvelope((CoordinateReferenceSystem)data);
        }
        throw new ClassCastException("Could not cast data to ReferencedEnvelope");
    }

    public Object visit(ExcludeFilter filter, Object data) {
        return new Envelope();
    }

    public Object visit(IncludeFilter filter, Object data) {
        return this.infinity();
    }

    Envelope infinity() {
        return new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public Object visit(BBOX filter, Object data) {
        ReferencedEnvelope bbox = this.bbox(data);
        Envelope bounds = new Envelope(filter.getMinX(), filter.getMaxX(), filter.getMinY(), filter.getMaxY());
        if (bbox != null) {
            bbox.expandToInclude(bounds);
            return bbox;
        }
        return this.bbox(bounds);
    }

    public Object visit(Literal expression, Object data) {
        ReferencedEnvelope bbox = this.bbox(data);
        Object value = expression.getValue();
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            Envelope bounds = geometry.getEnvelopeInternal();
            if (bbox != null) {
                bbox.expandToInclude(bounds);
                return bbox;
            }
            return this.bbox(bounds);
        }
        LOGGER.finer("LiteralExpression ignored!");
        return bbox;
    }

    public Object visit(And filter, Object data) {
        Envelope mixed = this.infinity();
        for (Filter f : filter.getChildren()) {
            Envelope env = (Envelope)f.accept(this, data);
            mixed = mixed.intersection(env);
        }
        return mixed;
    }

    public Object visit(Not filter, Object data) {
        return this.infinity();
    }

    public Object visit(Or filter, Object data) {
        Envelope mixed = new Envelope();
        for (Filter f : filter.getChildren()) {
            Envelope env = (Envelope)f.accept(this, data);
            mixed.expandToInclude(env);
        }
        return mixed;
    }

    public Object visit(Beyond filter, Object data) {
        return this.infinity();
    }

    public Object visit(Contains filter, Object data) {
        data = filter.getExpression1().accept(this, data);
        data = filter.getExpression2().accept(this, data);
        return data;
    }

    public Object visit(Crosses filter, Object data) {
        data = filter.getExpression1().accept(this, data);
        data = filter.getExpression2().accept(this, data);
        return data;
    }

    public Object visit(Disjoint filter, Object data) {
        return this.infinity();
    }

    public Object visit(DWithin filter, Object data) {
        ReferencedEnvelope bbox = this.bbox(data);
        Literal geometry = null;
        if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
            geometry = (Literal)filter.getExpression2();
        }
        if (filter.getExpression2() instanceof PropertyName && filter.getExpression1() instanceof Literal) {
            geometry = (Literal)filter.getExpression2();
        }
        if (geometry == null) {
            return this.infinity();
        }
        Geometry geom = geometry.evaluate(null, Geometry.class);
        if (geom == null) {
            return this.infinity();
        }
        Envelope env = geom.getEnvelopeInternal();
        env.expandBy(filter.getDistance());
        if (bbox != null) {
            bbox.expandToInclude(env);
            return bbox;
        }
        return this.bbox(env);
    }

    public Object visit(Equals filter, Object data) {
        data = filter.getExpression1().accept(this, data);
        data = filter.getExpression2().accept(this, data);
        return data;
    }

    public Object visit(Intersects filter, Object data) {
        data = filter.getExpression1().accept(this, data);
        data = filter.getExpression2().accept(this, data);
        return data;
    }

    public Object visit(Overlaps filter, Object data) {
        data = filter.getExpression1().accept(this, data);
        data = filter.getExpression2().accept(this, data);
        return data;
    }

    public Object visit(Touches filter, Object data) {
        data = filter.getExpression1().accept(this, data);
        data = filter.getExpression2().accept(this, data);
        return data;
    }

    public Object visit(Within filter, Object data) {
        data = filter.getExpression1().accept(this, data);
        data = filter.getExpression2().accept(this, data);
        return data;
    }

    public Object visit(Add expression, Object data) {
        return this.infinity();
    }

    public Object visit(Divide expression, Object data) {
        return this.infinity();
    }

    public Object visit(Function expression, Object data) {
        return this.infinity();
    }

    public Object visit(Id filter, Object data) {
        return this.infinity();
    }

    public Object visit(Multiply expression, Object data) {
        return this.infinity();
    }

    public Object visit(NilExpression expression, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsLike filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyIsNull filter, Object data) {
        return this.infinity();
    }

    public Object visit(PropertyName expression, Object data) {
        return null;
    }

    public Object visit(Subtract expression, Object data) {
        return this.infinity();
    }

    public Object visitNullFilter(Object data) {
        return this.infinity();
    }
}

