/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class MaxVisitor
implements FeatureCalc {
    private Expression expr;
    Comparable maxvalue;
    Comparable curvalue;
    boolean visited = false;
    int countNull = 0;
    int countNaN = 0;

    public MaxVisitor(String attributeTypeName) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(attributeTypeName);
    }

    public MaxVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attributeTypeIndex).getLocalName());
    }

    public MaxVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attrName).getLocalName());
    }

    public MaxVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    public void init(SimpleFeatureCollection collection) {
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        double doubleVal;
        Object attribValue = this.expr.evaluate(feature);
        if (attribValue == null) {
            ++this.countNull;
            return;
        }
        if (attribValue instanceof Double && (Double.isNaN(doubleVal = ((Double)attribValue).doubleValue()) || Double.isInfinite(doubleVal))) {
            ++this.countNaN;
            return;
        }
        this.curvalue = (Comparable)attribValue;
        if (!this.visited || this.curvalue.compareTo(this.maxvalue) > 0) {
            this.maxvalue = this.curvalue;
            this.visited = true;
        }
    }

    public Comparable getMax() {
        if (!this.visited) {
            throw new IllegalStateException("Must visit before max value is ready!");
        }
        return this.maxvalue;
    }

    public int getNaNCount() {
        return this.countNaN;
    }

    public int getNullCount() {
        return this.countNull;
    }

    public void reset() {
        this.visited = false;
        this.maxvalue = new Integer(Integer.MIN_VALUE);
        this.countNaN = 0;
        this.countNull = 0;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public CalcResult getResult() {
        if (!this.visited) {
            return CalcResult.NULL_RESULT;
        }
        return new MaxResult(this.maxvalue);
    }

    public void setValue(Object result) {
        this.visited = true;
        this.maxvalue = (Comparable)result;
    }

    public static class MaxResult
    extends AbstractCalcResult {
        private Comparable maxValue;

        public MaxResult(Comparable newMaxValue) {
            this.maxValue = newMaxValue;
        }

        public Object getValue() {
            Comparable max = this.maxValue;
            return max;
        }

        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof MaxResult || targetResults == CalcResult.NULL_RESULT;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof MaxResult) {
                Comparable toAdd = (Comparable)resultsToAdd.getValue();
                Comparable newMax = this.maxValue;
                if (newMax.getClass() != toAdd.getClass()) {
                    Class bestClass = CalcUtil.bestClass(new Object[]{toAdd, newMax});
                    if (bestClass != toAdd.getClass()) {
                        toAdd = (Comparable)CalcUtil.convert(toAdd, bestClass);
                    }
                    if (bestClass != newMax.getClass()) {
                        newMax = (Comparable)CalcUtil.convert(newMax, bestClass);
                    }
                }
                if (newMax.compareTo(toAdd) < 0) {
                    newMax = toAdd;
                }
                return new MaxResult(newMax);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

