/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import org.geotools.coverage.Category;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.NumberRange;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GeophysicsCategory
extends Category {
    private static final long serialVersionUID = -7164422654831370784L;

    GeophysicsCategory(Category inverse, boolean isQuantitative) throws TransformException {
        super(inverse, isQuantitative);
    }

    @Override
    public InternationalString getName() {
        assert (!(this.inverse instanceof GeophysicsCategory));
        return this.inverse.getName();
    }

    @Override
    public Color[] getColors() {
        assert (!(this.inverse instanceof GeophysicsCategory));
        return this.inverse.getColors();
    }

    @Override
    public NumberRange<? extends Number> getRange() throws IllegalStateException {
        if (this.range == null) {
            try {
                MathTransform1D tr = this.inverse.transform;
                NumberRange<? extends Number> r = this.inverse.range;
                boolean minIncluded = r.isMinIncluded();
                boolean maxIncluded = r.isMaxIncluded();
                double min = tr.transform(r.getMinimum());
                double max = tr.transform(r.getMaximum());
                double min2 = tr.transform(r.getMinimum(!minIncluded));
                double max2 = tr.transform(r.getMaximum(!maxIncluded));
                double d = minIncluded ? min2 : min;
                double d2 = maxIncluded ? max2 : max;
                if (d > d2) {
                    double tmp = min;
                    double tmp2 = min2;
                    boolean tmpIncluded = minIncluded;
                    min = max;
                    min2 = max2;
                    minIncluded = maxIncluded;
                    max = tmp;
                    max2 = tmp2;
                    maxIncluded = tmpIncluded;
                }
                assert (Double.doubleToLongBits(this.minimum) == Double.doubleToLongBits(minIncluded ? min : min2));
                assert (Double.doubleToLongBits(this.maximum) == Double.doubleToLongBits(maxIncluded ? max : max2));
                this.range = new Range(min, minIncluded, max, maxIncluded, min2, max2);
            }
            catch (TransformException cause) {
                throw new IllegalStateException(Errors.format(15, Classes.getClass(this.inverse.transform)), cause);
            }
        }
        return this.range;
    }

    @Override
    public MathTransform1D getSampleToGeophysics() {
        return this.isQuantitative() ? LinearTransform1D.IDENTITY : null;
    }

    @Override
    public boolean isQuantitative() {
        assert (!(this.inverse instanceof GeophysicsCategory)) : this.inverse;
        return this.inverse.isQuantitative();
    }

    @Override
    public Category recolor(Color[] colors) {
        assert (!(this.inverse instanceof GeophysicsCategory)) : this.inverse;
        return this.inverse.recolor((Color[])colors).inverse;
    }

    @Override
    public Category rescale(MathTransform1D sampleToGeophysics) {
        if (sampleToGeophysics.isIdentity()) {
            return this;
        }
        sampleToGeophysics = (MathTransform1D)ConcatenatedTransform.create(this.inverse.getSampleToGeophysics(), sampleToGeophysics);
        return this.inverse.rescale((MathTransform1D)sampleToGeophysics).inverse;
    }

    @Override
    public Category geophysics(boolean geo) {
        assert (!(this.inverse instanceof GeophysicsCategory)) : this.inverse;
        return this.inverse.geophysics(geo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Range
    extends NumberRange<Double> {
        private static final long serialVersionUID = -1416908614729956928L;
        private final double minimum2;
        private final double maximum2;

        public Range(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded, double minimum2, double maximum2) {
            super(NumberRange.create(minimum, isMinIncluded, maximum, isMaxIncluded));
            this.minimum2 = minimum2;
            this.maximum2 = maximum2;
        }

        @Override
        public double getMinimum(boolean inclusive) {
            return inclusive == this.isMinIncluded() ? this.getMinimum() : this.minimum2;
        }

        @Override
        public double getMaximum(boolean inclusive) {
            return inclusive == this.isMaxIncluded() ? this.getMaximum() : this.maximum2;
        }
    }
}

