/*
 * Decompiled with CFR 0.152.
 */
package org.eumetsat.beam.dataio.metop;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.AvhrrFile;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.framework.datamodel.ProductData;
import org.eumetsat.beam.dataio.metop.MetopFile;

class PlainBandReader
implements BandReader {
    private static final String VIS_RADIANCE_UNIT = "W / (m^2 sr)";
    private static final String IR_RADIANCE_UNIT = "mW / (m^2 sr cm)";
    protected int channel;
    protected MetopFile metopFile;
    protected final ImageInputStream inputStream;

    public PlainBandReader(int channel, MetopFile metopFile, ImageInputStream inputStream) {
        this.channel = channel;
        this.metopFile = metopFile;
        this.inputStream = inputStream;
    }

    @Override
    public String getBandName() {
        return "radiance_" + AvhrrConstants.CH_STRINGS[this.channel];
    }

    @Override
    public String getBandUnit() {
        if (this.isVisibleBand()) {
            return VIS_RADIANCE_UNIT;
        }
        return IR_RADIANCE_UNIT;
    }

    @Override
    public String getBandDescription() {
        if (this.isVisibleBand()) {
            return PlainBandReader.format("Spectral radiance for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
        }
        return PlainBandReader.format("Earth scene radiance for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
    }

    @Override
    public double getScalingFactor() {
        if (this.channel == 2 || this.channel == 3) {
            return 1.0E-4;
        }
        return 0.01;
    }

    @Override
    public int getDataType() {
        return 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AvhrrFile.RawCoordinates rawCoord = this.metopFile.getRawCoordinates(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
        short[] targetData = (short[])destBuffer.getElems();
        pm.beginTask(MessageFormat.format("Reading AVHRR band ''{0}''...", this.getBandName()), rawCoord.maxY - rawCoord.minY);
        int targetIdx = rawCoord.targetStart;
        int sourceY = rawCoord.minY;
        while (sourceY <= rawCoord.maxY) {
            if (pm.isCanceled()) break;
            if (this.hasData(sourceY)) {
                int dataOffset = this.getDataOffset(sourceOffsetX, sourceY);
                ImageInputStream imageInputStream = this.inputStream;
                synchronized (imageInputStream) {
                    this.inputStream.seek(dataOffset);
                    this.inputStream.readFully(targetData, targetIdx, sourceWidth);
                }
                targetIdx += sourceWidth;
            } else {
                int sourceX = rawCoord.minX;
                while (sourceX <= rawCoord.maxX) {
                    targetData[targetIdx] = 0;
                    targetIdx += rawCoord.targetIncrement;
                    sourceX += sourceStepX;
                }
            }
            pm.worked(1);
            sourceY += sourceStepY;
        }
        pm.done();
    }

    protected int getDataOffset(int sourceOffsetX, int sourceY) {
        return this.metopFile.getScanLineOffset(sourceY) + 24 + 2048 * AvhrrConstants.CH_DATASET_INDEXES[this.channel] * 2 + (this.metopFile.getNumTrimX() + sourceOffsetX) * 2;
    }

    protected boolean isVisibleBand() {
        return this.channel == 0 || this.channel == 1 || this.channel == 2;
    }

    protected boolean hasData(int rawY) throws IOException {
        if (this.channel != 2 && this.channel != 3) {
            return true;
        }
        int bitField = this.metopFile.readFrameIndicator(rawY);
        int channel3ab = bitField & 1;
        return channel3ab == 1 && this.channel == 2 || channel3ab == 0 && this.channel == 3;
    }

    private static String format(String pattern, String arg) {
        return new MessageFormat(pattern).format(new Object[]{arg});
    }
}

