/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import org.esa.beam.util.math.DistanceMeasure;

public final class SinusoidalDistance
implements DistanceMeasure {
    private final double lon0;
    private final double lat0;
    private final double lonFactor;

    public SinusoidalDistance(double lon0, double lat0) {
        this.lon0 = lon0;
        this.lat0 = lat0;
        this.lonFactor = Math.cos(Math.toRadians(lat0));
    }

    @Override
    public double distance(double lon, double lat) {
        double deltaLat = lat - this.lat0;
        double deltaLon = lon - this.lon0;
        if (deltaLon < 0.0) {
            deltaLon = -deltaLon;
        }
        if (deltaLon > 180.0) {
            deltaLon = 360.0 - deltaLon;
        }
        return deltaLat * deltaLat + (deltaLon *= this.lonFactor) * deltaLon;
    }
}

