/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.io;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class WildcardMatcher {
    private final Pattern pattern;
    private final boolean windowsFs;

    public WildcardMatcher(String wildcard) {
        this(wildcard, WildcardMatcher.isWindowsOs());
    }

    WildcardMatcher(String wildcard, boolean windowsFs) {
        this.pattern = Pattern.compile(WildcardMatcher.wildcardToRegexp(wildcard.trim(), windowsFs));
        this.windowsFs = windowsFs;
    }

    boolean isWindowsFs() {
        return this.windowsFs;
    }

    public static File[] glob(String filePattern) throws IOException {
        TreeSet<File> fileSet = new TreeSet<File>();
        WildcardMatcher.glob(filePattern, fileSet);
        return fileSet.toArray(new File[fileSet.size()]);
    }

    public static void glob(String filePattern, Set<File> fileSet) throws IOException {
        File patternFile = new File(filePattern);
        if (patternFile.exists()) {
            fileSet.add(patternFile.getCanonicalFile());
            return;
        }
        boolean windowsOs = WildcardMatcher.isWindowsOs();
        String[] patternSplit = WildcardMatcher.splitBasePath(filePattern, windowsOs);
        String basePath = patternSplit[0];
        String patternPath = patternSplit[1];
        if (patternPath.isEmpty()) {
            return;
        }
        File canonicalBaseFile = new File(basePath).getCanonicalFile();
        String newpattern = String.valueOf(canonicalBaseFile.getPath()) + "/" + patternPath;
        WildcardMatcher matcher = new WildcardMatcher(newpattern);
        WildcardMatcher.collectFiles(matcher, canonicalBaseFile, fileSet);
    }

    private static void collectFiles(WildcardMatcher matcher, File dir, Set<File> fileSet) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException(String.format("Failed to access directory '%s'", dir));
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (matcher.matches(file.getCanonicalPath()) || matcher.matches(file.getPath())) {
                fileSet.add(file);
            }
            if (file.isDirectory()) {
                WildcardMatcher.collectFiles(matcher, file, fileSet);
            }
            ++n2;
        }
    }

    static String[] splitBasePath(String filePattern, boolean iswindows) {
        if (iswindows) {
            filePattern = filePattern.replace("\\", "/");
        }
        String basePath = filePattern.startsWith("/") ? "/" : "";
        String[] parts = filePattern.split("/");
        int firstPatternIndex = 0;
        int i = 0;
        while (i < parts.length && !WildcardMatcher.containsWildcardChar(parts[i])) {
            if (!parts[i].isEmpty()) {
                basePath = String.valueOf(basePath) + parts[i];
                if (i < parts.length - 1) {
                    basePath = String.valueOf(basePath) + "/";
                }
                firstPatternIndex = i + 1;
            }
            ++i;
        }
        String patterPath = "";
        int i2 = firstPatternIndex;
        while (i2 < parts.length) {
            patterPath = String.valueOf(patterPath) + parts[i2];
            if (i2 < parts.length - 1) {
                patterPath = String.valueOf(patterPath) + "/";
            }
            ++i2;
        }
        return new String[]{basePath, patterPath};
    }

    private static boolean containsWildcardChar(String part) {
        return part.equals("**") || part.contains("*") || part.contains("?");
    }

    String getRegex() {
        return this.pattern.pattern();
    }

    static String wildcardToRegexp(String wildcard, boolean windowsFs) {
        String[] metas;
        String s = WildcardMatcher.resolvePath(wildcard, windowsFs);
        s = s.replace("/**/", "_%SLASHSTARSTARSLASH%_");
        s = s.replace("/**", "_%SLASHSTARSTAR%_");
        s = s.replace("**/", "_%STARSTARSLASH%_");
        s = s.replace("*", "_%STAR%_");
        s = s.replace("?", "_%QUOTE%_");
        String[] stringArray = metas = new String[]{"\\", "|", "^", "$", "+", ".", "(", ")", "{", "}", "<", ">"};
        int n = metas.length;
        int n2 = 0;
        while (n2 < n) {
            String meta = stringArray[n2];
            s = s.replace(meta, "\\" + meta);
            ++n2;
        }
        s = s.replace("_%SLASHSTARSTARSLASH%_", "((/.*/)?|/)");
        s = s.replace("_%SLASHSTARSTAR%_", "(/.*)?");
        s = s.replace("_%STARSTARSLASH%_", "(.*/)?");
        s = s.replace("_%STAR%_", "[^/:]*");
        s = s.replace("_%QUOTE%_", ".");
        return s;
    }

    public boolean matches(String text) {
        return this.pattern.matcher(WildcardMatcher.resolvePath(text, this.windowsFs)).matches();
    }

    private static boolean isWindowsOs() {
        return System.getProperty("os.name").contains("Win");
    }

    private static String resolvePath(String text, boolean windowsFs) {
        if (windowsFs) {
            text = text.toLowerCase().replace("\\", "/");
        }
        while (text.startsWith("./")) {
            text = text.substring(2);
        }
        return text;
    }
}

