/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.geotiff.codes;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class CodeClassGenerator {
    static final String[] GEOTIFF_CODE_FILENAMES = new String[]{"geokey.properties", "geo_rasters.properties", "geo_models.properties", "geo_ctrans.properties"};
    static final String[] EPSG_CODE_FILE_NAMES = new String[]{"epsg_vertcs.properties", "epsg_unit.properties", "epsg_proj.properties", "epsg_pm.properties", "epsg_pcs.properties", "epsg_gcs.properties", "epsg_ellipse.properties", "epsg_datum.properties"};
    private static final String INDENT = "    ";

    public static void main(String[] args) {
        try {
            CodeClassGenerator.writeJavaClassFile(GEOTIFF_CODE_FILENAMES, "_GeoTIFFCodes");
            CodeClassGenerator.writeJavaClassFile(EPSG_CODE_FILE_NAMES, "_EPSGCodes");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeJavaClassFile(String[] fileNames, String className) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter("./src/com/bc/geotiff/" + className + ".java"));
        writer.println("package com.bc.geotiff;");
        writer.println();
        writer.print("public class ");
        writer.print(className);
        writer.print(" extends IntMap {");
        writer.println();
        int i = 0;
        while (i < fileNames.length) {
            String line;
            String fileName = fileNames[i];
            writer.print(INDENT);
            writer.print("/* Generated from file ");
            writer.print(fileName);
            writer.print(" */");
            writer.println();
            InputStream resourceAsStream = CodeClassGenerator.class.getResourceAsStream(fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
            while ((line = reader.readLine()) != null) {
                int pos;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || (pos = line.indexOf("=")) < 0) continue;
                String name = line.substring(0, pos).trim();
                String value = line.substring(pos + 1).trim();
                if (value.startsWith("$")) {
                    value = value.substring(1);
                }
                writer.print(INDENT);
                writer.print("public static final int ");
                writer.print(name);
                writer.print(" = ");
                writer.print(value);
                writer.print(";");
                writer.println();
            }
            reader.close();
            ++i;
        }
        writer.println();
        writer.println("    static {");
        writer.println("        init(" + className + ".class.getFields());");
        writer.println("    }");
        writer.println();
        writer.println("    private " + className + "() {");
        writer.println("    }");
        writer.println("}");
        writer.close();
    }
}

