/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.Puntal;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.SingleBandedOpImage;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class VectorDataMaskOpImage
extends SingleBandedOpImage {
    private static final byte FALSE = 0;
    private static final byte TRUE = -1;
    private final VectorDataNode vectorDataNode;
    private final AffineTransform m2iTransform;

    public VectorDataMaskOpImage(VectorDataNode vectorDataNode, ResolutionLevel level) {
        super(0, vectorDataNode.getProduct().getSceneRasterWidth(), vectorDataNode.getProduct().getSceneRasterHeight(), vectorDataNode.getProduct().getPreferredTileSize(), null, level);
        this.vectorDataNode = vectorDataNode;
        GeoCoding geoCoding = vectorDataNode.getProduct().getGeoCoding();
        AffineTransform transform = ImageManager.getImageToModelTransform(geoCoding);
        try {
            transform.invert();
            this.m2iTransform = transform;
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Could not invert model-to-image transformation.", e);
        }
    }

    public VectorDataNode getVectorData() {
        return this.vectorDataNode;
    }

    @Override
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        BufferedImage image = new BufferedImage(this.colorModel, RasterFactory.createWritableRaster(tile.getSampleModel(), tile.getDataBuffer(), new Point(0, 0)), false, null);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.translate(-((double)tile.getMinX() + 0.5), -((double)tile.getMinY() + 0.5));
        graphics2D.setColor(Color.WHITE);
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = this.vectorDataNode.getFeatureCollection();
        try (FeatureIterator<SimpleFeature> featureIterator = features.features();){
            AffineTransform transform = AffineTransform.getScaleInstance(1.0 / this.getScale(), 1.0 / this.getScale());
            transform.concatenate(this.m2iTransform);
            AffineTransform2D transform2D = new AffineTransform2D(transform);
            while (featureIterator.hasNext()) {
                SimpleFeature feature = featureIterator.next();
                Object value = feature.getDefaultGeometry();
                if (!(value instanceof Geometry)) continue;
                try {
                    VectorDataMaskOpImage.renderGeometry((Geometry)value, graphics2D, transform2D);
                }
                catch (Exception exception) {}
            }
        }
        graphics2D.dispose();
        byte[] data = ((DataBufferByte)tile.getDataBuffer()).getData();
        int i = 0;
        while (i < data.length) {
            data[i] = data[i] != 0 ? -1 : 0;
            ++i;
        }
    }

    private static void renderGeometry(Geometry geom, Graphics2D graphics, MathTransform2D transform) throws Exception {
        if (geom instanceof Puntal) {
            Coordinate c = geom.getCoordinate();
            Point2D.Double pt = new Point2D.Double(c.x, c.y);
            transform.transform(pt, pt);
            graphics.drawLine((int)pt.x, (int)pt.y, (int)pt.x, (int)pt.y);
        } else if (geom instanceof Lineal) {
            LiteShape2 shape = new LiteShape2(geom, (MathTransform)transform, null, false, true);
            graphics.draw(shape);
        } else if (geom instanceof Polygonal) {
            LiteShape2 shape = new LiteShape2(geom, (MathTransform)transform, null, false, true);
            graphics.fill(shape);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geom;
            int i = 0;
            while (i < collection.getNumGeometries()) {
                VectorDataMaskOpImage.renderGeometry(collection.getGeometryN(i), graphics, transform);
                ++i;
            }
        }
    }
}

