/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.awt.Color;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.esa.beam.framework.param.ParamValidator;
import org.esa.beam.framework.param.validators.BooleanValidator;
import org.esa.beam.framework.param.validators.ColorValidator;
import org.esa.beam.framework.param.validators.FileValidator;
import org.esa.beam.framework.param.validators.NumberValidator;
import org.esa.beam.framework.param.validators.StringArrayValidator;
import org.esa.beam.framework.param.validators.StringValidator;

public class ParamValidatorRegistry {
    private static Map _validators = new Hashtable();

    static {
        ParamValidatorRegistry.registerValidator(Short.class, new NumberValidator());
        ParamValidatorRegistry.registerValidator(Integer.class, new NumberValidator());
        ParamValidatorRegistry.registerValidator(Long.class, new NumberValidator());
        ParamValidatorRegistry.registerValidator(Float.class, new NumberValidator());
        ParamValidatorRegistry.registerValidator(Double.class, new NumberValidator());
        ParamValidatorRegistry.registerValidator(String.class, new StringValidator());
        ParamValidatorRegistry.registerValidator(String[].class, new StringArrayValidator());
        ParamValidatorRegistry.registerValidator(Boolean.class, new BooleanValidator());
        ParamValidatorRegistry.registerValidator(Color.class, new ColorValidator());
        ParamValidatorRegistry.registerValidator(File.class, new FileValidator());
    }

    public static ParamValidator getDefaultValidator() {
        ParamValidator validator = ParamValidatorRegistry.getValidator(String.class);
        if (validator == null) {
            validator = new StringValidator();
        }
        return validator;
    }

    public static ParamValidator getValidator(Class valueType) {
        return valueType != null ? (ParamValidator)_validators.get(valueType) : ParamValidatorRegistry.getDefaultValidator();
    }

    public static void registerValidator(Class valueType, ParamValidator validator) {
        _validators.put(valueType, validator);
    }

    public static boolean deregisterValidator(Class valueType) {
        return _validators.remove(valueType) != null;
    }

    private ParamValidatorRegistry() {
    }
}

