/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.esa.beam.framework.param.ParamChangeListener;
import org.esa.beam.framework.param.ParamExceptionHandler;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.PropertyMap;

public class ParamGroup {
    private List _parameters = new Vector();

    public static ParamGroup create(PropertyMap propertyMap) {
        ParamGroup paramGroup = new ParamGroup();
        Enumeration keys = propertyMap.getPropertyKeys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.endsWith(".name")) continue;
            String paramName = propertyMap.getPropertyString(key);
            Parameter parameter = paramGroup.createParameter(paramName);
            parameter.setPropertyValues(propertyMap);
            if (parameter.getValue() != null || parameter.getProperties().getDefaultValue() == null) continue;
            parameter.setDefaultValue();
        }
        return paramGroup;
    }

    public void setParameterValues(PropertyMap propertyMap, ParamExceptionHandler handler) {
        Guardian.assertNotNull("propertyMap", propertyMap);
        int i = 0;
        while (i < this.getNumParameters()) {
            Parameter parameter = this.getParameterAt(i);
            String valueText = propertyMap.getPropertyString(parameter.getName(), null);
            if (valueText != null) {
                parameter.setValueAsText(valueText, handler);
            }
            ++i;
        }
    }

    public PropertyMap getParameterValues() {
        return this.getParameterValues(null);
    }

    public PropertyMap getParameterValues(PropertyMap propertyMap) {
        if (propertyMap == null) {
            propertyMap = new PropertyMap();
        }
        int i = 0;
        while (i < this.getNumParameters()) {
            Parameter parameter = this.getParameterAt(i);
            String valueText = parameter.getValueAsText();
            if (valueText != null) {
                propertyMap.setPropertyString(parameter.getName(), valueText);
            } else {
                propertyMap.setPropertyString(parameter.getName(), null);
            }
            ++i;
        }
        return propertyMap;
    }

    public int getNumParameters() {
        return this._parameters.size();
    }

    public Parameter getParameterAt(int index) {
        return (Parameter)this._parameters.get(index);
    }

    public Parameter getParameter(String name) {
        return this.getParameter(name, false);
    }

    public Parameter createParameter(String name) {
        return this.getParameter(name, true);
    }

    public int getParameterIndex(String name) {
        int n = this.getNumParameters();
        int i = 0;
        while (i < n) {
            if (this.getParameterAt(i).getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addParameter(Parameter parameter) {
        if (parameter != null && !this._parameters.contains(parameter)) {
            if (this.getParameterIndex(parameter.getName()) >= 0) {
                throw new IllegalArgumentException("A parameter with name '" + parameter.getName() + "' is already in group!");
            }
            this._parameters.add(parameter);
        }
    }

    public void removeParameter(Parameter parameter) {
        if (parameter != null) {
            this._parameters.remove(parameter);
        }
    }

    public void addParamChangeListener(ParamChangeListener listener) {
        if (listener == null) {
            return;
        }
        int i = 0;
        while (i < this.getNumParameters()) {
            this.getParameterAt(i).addParamChangeListener(listener);
            ++i;
        }
    }

    public void removeParamChangeListener(ParamChangeListener listener) {
        if (listener == null) {
            return;
        }
        int i = 0;
        while (i < this.getNumParameters()) {
            this.getParameterAt(i).removeParamChangeListener(listener);
            ++i;
        }
    }

    private Parameter getParameter(String name, boolean create) {
        Parameter parameter = null;
        int index = this.getParameterIndex(name);
        if (index >= 0) {
            parameter = this.getParameterAt(index);
        } else if (create) {
            parameter = new Parameter(name);
            this.addParameter(parameter);
        }
        return parameter;
    }
}

