/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.beam.framework.param.AbstractParamEditor;
import org.esa.beam.framework.param.Parameter;

public abstract class AbstractParamXEditor
extends AbstractParamEditor {
    private XEditorPane _xEditorPane;
    private static Icon _xEditorIcon;
    private AbstractButton _xEditorButton;

    protected AbstractParamXEditor(Parameter parameter, boolean useDefaultVerifier) {
        super(parameter, useDefaultVerifier);
    }

    @Override
    public JComponent getEditorComponent() {
        return this._xEditorPane;
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.initUIChild();
        this._xEditorPane = new XEditorPane();
        this.nameComponent(this._xEditorPane, "XEditor");
        JComponent editorComponentChild = this.getEditorComponentChild();
        this._xEditorPane.add("Center", editorComponentChild);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.nameComponent(buttonPanel, "ButtonPanel");
        AbstractButton xEditorButton = this.getXEditorButton();
        if (editorComponentChild instanceof JTextField) {
            buttonPanel.add("Center", xEditorButton);
        } else {
            Dimension size = xEditorButton.getPreferredSize();
            xEditorButton.setPreferredSize(new Dimension(size.width, size.width));
            buttonPanel.add("North", xEditorButton);
        }
        this._xEditorPane.add("East", buttonPanel);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._xEditorPane.isEnabled() != this.isEnabled()) {
            this._xEditorPane.setEnabled(this.isEnabled());
        }
    }

    protected abstract void initUIChild();

    public abstract JComponent getEditorComponentChild();

    protected abstract void invokeXEditor();

    protected AbstractButton getXEditorButton() {
        if (this._xEditorButton == null) {
            this._xEditorButton = this.createXEditorButton();
        }
        return this._xEditorButton;
    }

    protected AbstractButton createXEditorButton() {
        JButton button = new JButton("...");
        this.nameComponent(button, "Button");
        Dimension size = new Dimension(26, 16);
        button.setPreferredSize(size);
        button.setMinimumSize(size);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractParamXEditor.this.invokeXEditor();
            }
        });
        return button;
    }

    protected Icon getXEditorIcon() {
        URL url;
        if (_xEditorIcon == null && (url = AbstractParamEditor.class.getResource("/org/esa/beam/resources/images/icons/Edit16.gif")) != null) {
            _xEditorIcon = new ImageIcon(url);
        }
        return _xEditorIcon;
    }

    protected String getXEditorTitle() {
        String title = this.getParameter().getProperties().getLabel();
        if (title == null) {
            title = this.getParameter().getName();
        }
        return title;
    }

    class XEditorPane
    extends JPanel {
        public XEditorPane() {
            super(new BorderLayout(3, 3));
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            AbstractParamXEditor.this.getEditorComponentChild().setEnabled(enabled);
            AbstractParamXEditor.this.getXEditorButton().setEnabled(enabled);
        }
    }
}

