/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import java.awt.geom.Point2D;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.CartographicMapTransform;
import org.esa.beam.framework.dataop.maptransf.DefaultMapTransformUI;
import org.esa.beam.framework.dataop.maptransf.Ellipsoid;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapProjectionRegistry;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.dataop.maptransf.MapTransformUI;
import org.esa.beam.framework.dataop.maptransf.MapTransformUtils;
import org.esa.beam.framework.param.Parameter;

@Deprecated
public class LambertConformalConicDescriptor
implements MapTransformDescriptor {
    public static final String TYPE_ID = "Lambert_Conformal_Conic";
    public static final String NAME = "Lambert Conformal Conic";
    public static final String MAP_UNIT = "meter";
    private static final int SEMI_MAJOR_INDEX = 0;
    private static final int SEMI_MINOR_INDEX = 1;
    private static final int LATITUDE_OF_ORIGIN_INDEX = 2;
    private static final int CENTRAL_MERIDIAN_INDEX = 3;
    private static final int LATITUDE_OF_INTERSECTION_1_INDEX = 4;
    private static final int LATITUDE_OF_INTERSECTION_2_INDEX = 5;
    private static final int SCALE_FACTOR_INDEX = 6;
    public static final String[] PARAMETER_NAMES = new String[]{"semi_major", "semi_minor", "latitude_of_origin", "central_meridian", "latitude_of_intersection_1", "latitude_of_intersection_2", "scale_factor"};
    public static final double[] PARAMETER_DEFAULT_VALUES = new double[]{Ellipsoid.WGS_84.getSemiMajor(), Ellipsoid.WGS_84.getSemiMinor(), 90.0, 0.0, 20.0, 60.0, 1.0};
    public static final String[] PARAMETER_LABELS = new String[]{"Semi major", "Semi minor", "Latitude of origin", "Central meridian", "Latitude of intersection 1", "Latitude of intersection 2", "Scale factor"};
    public static final String[] PARAMETER_UNITS = new String[]{"meter", "meter", "degree", "degree", "degree", "degree", ""};

    @Override
    public void registerProjections() {
        MapProjectionRegistry.registerProjection(new MapProjection(this.getName(), this.createTransform(null), false));
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getMapUnit() {
        return MAP_UNIT;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[PARAMETER_NAMES.length];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = new Parameter(PARAMETER_NAMES[i], PARAMETER_DEFAULT_VALUES[i]);
            parameters[i].getProperties().setLabel(PARAMETER_LABELS[i]);
            parameters[i].getProperties().setPhysicalUnit(PARAMETER_UNITS[i]);
            ++i;
        }
        return parameters;
    }

    @Override
    public double[] getParameterDefaultValues() {
        double[] values = new double[PARAMETER_DEFAULT_VALUES.length];
        System.arraycopy(PARAMETER_DEFAULT_VALUES, 0, values, 0, values.length);
        return values;
    }

    @Override
    public boolean hasTransformUI() {
        return true;
    }

    @Override
    public MapTransformUI getTransformUI(MapTransform transform) {
        return new DefaultMapTransformUI(transform);
    }

    @Override
    public MapTransform createTransform(double[] parameterValues) {
        if (parameterValues == null) {
            parameterValues = this.getParameterDefaultValues();
        }
        return new LCCT(parameterValues);
    }

    @Deprecated
    public class LCCT
    extends CartographicMapTransform {
        private static final double _epsilon = 1.0E-10;
        private double[] _parameterValues;
        private double _n;
        private double _invN;
        private double _rho0;
        private double _e;
        private double _c;
        private double _invC;
        private double _k0;
        private double _invK0;

        public LCCT(double[] parameterValues) {
            double temp;
            double sinPhi;
            super(parameterValues[3], 0.0, 0.0, parameterValues[0]);
            this._parameterValues = new double[parameterValues.length];
            System.arraycopy(parameterValues, 0, this._parameterValues, 0, parameterValues.length);
            double phi0 = Math.PI / 180 * this._parameterValues[2];
            double phi1 = Math.PI / 180 * this._parameterValues[4];
            double phi2 = Math.PI / 180 * this._parameterValues[5];
            if (Math.abs(phi1 + phi2) < 1.0E-10) {
                throw new IllegalArgumentException("Invalid parameter set.");
            }
            this._n = sinPhi = Math.sin(phi1);
            double cosPhi = Math.cos(phi1);
            boolean isSecant = Math.abs(phi1 - phi2) >= 1.0E-10;
            double a = this._parameterValues[0];
            double b = this._parameterValues[1];
            double es = 1.0 - b * b / (a * a);
            this._e = Math.sqrt(es);
            double m1 = MapTransformUtils.msfn(sinPhi, cosPhi, es);
            double ml1 = MapTransformUtils.tsfn(phi1, sinPhi, this._e);
            if (isSecant) {
                temp = MapTransformUtils.msfn(Math.sin(phi2), Math.cos(phi2), es);
                this._n = Math.log(m1 / temp);
                temp = MapTransformUtils.tsfn(phi2, Math.sin(phi2), this._e);
                this._n /= Math.log(ml1 / temp);
            }
            this._invN = 1.0 / this._n;
            this._c = m1 * Math.pow(ml1, -this._n) * this._invN;
            this._invC = 1.0 / this._c;
            this._rho0 = 0.0;
            if (Math.abs(Math.abs(phi0) - 1.5707963267948966) >= 1.0E-10) {
                temp = MapTransformUtils.tsfn(phi0, Math.sin(phi0), this._e);
                this._rho0 = this._c * Math.pow(temp, this._n);
            }
            this._k0 = this._parameterValues[6];
            this._invK0 = 1.0 / this._k0;
        }

        @Override
        public MapTransformDescriptor getDescriptor() {
            return LambertConformalConicDescriptor.this;
        }

        @Override
        public MapTransform createDeepClone() {
            return new LCCT(this._parameterValues);
        }

        @Override
        public double[] getParameterValues() {
            double[] values = new double[this._parameterValues.length];
            System.arraycopy(this._parameterValues, 0, values, 0, values.length);
            return values;
        }

        @Override
        protected Point2D forward_impl(float lat, float lon, Point2D mapPoint) {
            double rho;
            double phi = Math.PI / 180 * (double)lat;
            double lam = Math.PI / 180 * (double)lon;
            if (Math.abs(Math.abs(phi) - 1.5707963267948966) < 1.0E-10) {
                if (phi * this._n < 0.0) {
                    throw new IllegalArgumentException("Invalid parameter range");
                }
                rho = 0.0;
            } else {
                double temp = MapTransformUtils.tsfn(phi, Math.sin(phi), this._e);
                rho = this._c * Math.pow(temp, this._n);
            }
            double tempX = this._k0 * (rho * Math.sin(lam *= this._n));
            double tempY = this._k0 * (this._rho0 - rho * Math.cos(lam));
            mapPoint.setLocation(tempX, tempY);
            return mapPoint;
        }

        @Override
        protected GeoPos inverse_impl(float x, float y, GeoPos geoPoint) {
            double localX = (double)x * this._invK0;
            double localY = (double)y * this._invK0;
            double rho = Math.sqrt(localX * localX + (localY = this._rho0 - localY) * localY);
            if (rho != 0.0) {
                if (this._n < 0.0) {
                    rho = -rho;
                    localX = -localX;
                    localY = -localY;
                }
                double temp = Math.pow(rho * this._invC, this._invN);
                geoPoint.lat = (float)MapTransformUtils.phi2(temp, this._e);
                geoPoint.lon = (float)(Math.atan2(localX, localY) * this._invN);
            } else {
                geoPoint.lat = 0.0f;
                geoPoint.lon = this._n > 0.0 ? 1.5707964f : -1.5707964f;
            }
            geoPoint.lat *= 57.29578f;
            geoPoint.lon *= 57.29578f;
            return geoPoint;
        }

        public double getSemiMinor() {
            return this._parameterValues[1];
        }

        public double getLatitudeOfOrigin() {
            return this._parameterValues[2];
        }

        public double getScaleFactor() {
            return this._parameterValues[6];
        }

        public double getStandardParallel1() {
            return this._parameterValues[4];
        }

        public double getStandardParallel2() {
            return this._parameterValues[5];
        }
    }
}

