/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.barithm;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.jexp.Term;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;
import org.esa.beam.framework.dataop.barithm.RasterDataSymbol;
import org.esa.beam.util.Guardian;

public class RasterDataLoop {
    private final RasterDataEvalEnv rasterDataEvalEnv;
    private final Term[] terms;
    private final RasterRegion[] rasterRegions;
    private ProgressMonitor pm;

    public RasterDataLoop(int offsetX, int offsetY, int regionWidth, int regionHeight, Term[] terms, ProgressMonitor pm) {
        this(new RasterDataEvalEnv(offsetX, offsetY, regionWidth, regionHeight), terms, pm);
    }

    public RasterDataLoop(RasterDataEvalEnv rasterDataEvalEnv, Term[] terms, ProgressMonitor pm) {
        Guardian.assertNotNull("rasterDataEvalEnv", rasterDataEvalEnv);
        Guardian.assertNotNull("pm", pm);
        RasterDataLoop.checkTerms(terms);
        RasterDataLoop.checkRegion(rasterDataEvalEnv.getOffsetX(), rasterDataEvalEnv.getOffsetY(), rasterDataEvalEnv.getRegionWidth(), rasterDataEvalEnv.getRegionHeight(), terms);
        this.rasterDataEvalEnv = rasterDataEvalEnv;
        this.terms = terms;
        this.rasterRegions = RasterDataLoop.createRasterRegions(terms, rasterDataEvalEnv.getRegionWidth(), 1);
        this.pm = pm;
    }

    public int getOffsetX() {
        return this.rasterDataEvalEnv.getOffsetX();
    }

    public int getOffsetY() {
        return this.rasterDataEvalEnv.getOffsetY();
    }

    public int getRegionWidth() {
        return this.rasterDataEvalEnv.getRegionWidth();
    }

    public int getRegionHeight() {
        return this.rasterDataEvalEnv.getRegionHeight();
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public void forEachPixel(Body body) throws IOException {
        this.forEachPixel(body, "Performing raster data operation...");
    }

    public void forEachPixel(Body body, String message) throws IOException {
        Guardian.assertNotNull("body", body);
        int offsetY = this.getOffsetY();
        int width = this.getRegionWidth();
        int height = this.getRegionHeight();
        RasterDataEvalEnv env = this.rasterDataEvalEnv;
        message = message == null ? "Computing pixels..." : message;
        this.pm.beginTask(message, (height - offsetY) * 2);
        try {
            int pixelIndex = 0;
            int y = offsetY;
            while (y < offsetY + height) {
                if (this.pm.isCanceled()) {
                    break;
                }
                this.readRegion(y, 1, SubProgressMonitor.create(this.pm, 1));
                int x = 0;
                while (x < width) {
                    env.setElemIndex(x);
                    body.eval(env, pixelIndex);
                    ++pixelIndex;
                    ++x;
                }
                this.pm.worked(1);
                ++y;
            }
        }
        finally {
            this.pm.done();
        }
    }

    private void readRegion(int offsetY, int height, ProgressMonitor pm) throws IOException {
        RasterRegion[] rasterRegionArray = this.rasterRegions;
        int n = this.rasterRegions.length;
        int n2 = 0;
        while (n2 < n) {
            RasterRegion rasterRegion = rasterRegionArray[n2];
            rasterRegion.readRegion(this.getOffsetX(), offsetY, this.getRegionWidth(), height, pm);
            ++n2;
        }
    }

    private static void checkTerms(Term[] terms) {
        Guardian.assertNotNull("terms", terms);
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            Guardian.assertNotNull("term", term);
            ++n2;
        }
    }

    private static void checkRegion(int offsetX, int offsetY, int width, int height, Term[] terms) {
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            RasterDataSymbol[] refRasterDataSymbols;
            Term term = termArray[n2];
            RasterDataSymbol[] rasterDataSymbolArray = refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols(term);
            int n3 = refRasterDataSymbols.length;
            int n4 = 0;
            while (n4 < n3) {
                RasterDataSymbol refRasterDataSymbol = rasterDataSymbolArray[n4];
                RasterDataNode raster = refRasterDataSymbol.getRaster();
                int rasterWidth = raster.getSceneRasterWidth();
                int rasterHeight = raster.getSceneRasterHeight();
                if (rasterWidth < offsetX + width || rasterHeight < offsetY + height) {
                    throw new IllegalArgumentException("out of bounds.");
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static RasterRegion[] createRasterRegions(Term[] terms, int width, int height) {
        HashSet<RasterDataSymbol> rasterSymbolSet = new HashSet<RasterDataSymbol>();
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            RasterDataSymbol[] refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols(term);
            rasterSymbolSet.addAll(Arrays.asList(refRasterDataSymbols));
            ++n2;
        }
        ArrayList<RasterRegion> rasterRegions = new ArrayList<RasterRegion>(rasterSymbolSet.size());
        for (RasterDataSymbol symbol : rasterSymbolSet) {
            RasterRegion rasterRegion = RasterRegion.createRasterRegion(symbol.getRaster(), width, height);
            rasterRegions.add(rasterRegion);
            symbol.setData(rasterRegion.getData().getElems());
        }
        return rasterRegions.toArray(new RasterRegion[rasterRegions.size()]);
    }

    public static interface Body {
        public void eval(RasterDataEvalEnv var1, int var2);
    }

    private static class RasterRegion {
        private final RasterDataNode _rasterNode;
        private final ProductData _regionData;

        static RasterRegion createRasterRegion(RasterDataNode rasterNode, int width, int height) {
            ProductData data = rasterNode.isFloatingPointType() ? ProductData.createInstance(30, width * height) : ProductData.createInstance(12, width * height);
            return new RasterRegion(rasterNode, data);
        }

        private RasterRegion(RasterDataNode rasterNode, ProductData regionData) {
            this._rasterNode = rasterNode;
            this._regionData = regionData;
        }

        RasterDataNode getRasterNode() {
            return this._rasterNode;
        }

        ProductData getData() {
            return this._regionData;
        }

        void readRegion(int x, int y, int w, int h, ProgressMonitor pm) throws IOException {
            if (this._rasterNode.isFloatingPointType()) {
                this._rasterNode.readPixels(x, y, w, h, (float[])this._regionData.getElems(), pm);
            } else {
                this._rasterNode.readPixels(x, y, w, h, (int[])this._regionData.getElems(), pm);
            }
        }
    }
}

