/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeFilter;
import org.esa.beam.util.Guardian;

public final class ProductNodeList<T extends ProductNode> {
    private final List<T> nodes = Collections.synchronizedList(new ArrayList());
    private final List<T> removedNodes = Collections.synchronizedList(new ArrayList());

    public final int size() {
        return this.nodes.size();
    }

    public final T getAt(int index) {
        return (T)((ProductNode)this.nodes.get(index));
    }

    public final String[] getNames() {
        String[] names = new String[this.nodes.size()];
        int i = 0;
        while (i < this.nodes.size()) {
            names[i] = ((ProductNode)this.nodes.get(i)).getName();
            ++i;
        }
        return names;
    }

    public String[] getDisplayNames() {
        String[] displayNames = new String[this.nodes.size()];
        int i = 0;
        while (i < this.nodes.size()) {
            displayNames[i] = ((ProductNode)this.nodes.get(i)).getDisplayName();
            ++i;
        }
        return displayNames;
    }

    public final T get(String name) {
        int index = this.indexOf(name);
        return (T)(index >= 0 ? (ProductNode)this.nodes.get(index) : null);
    }

    public T getByDisplayName(String displayName) {
        Guardian.assertNotNull("displayName", displayName);
        for (ProductNode node : this.nodes) {
            if (!node.getDisplayName().equals(displayName)) continue;
            return (T)node;
        }
        return null;
    }

    public final boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public final boolean contains(T node) {
        return node != null && this.nodes.contains(node);
    }

    public final boolean add(T node) {
        return node != null && this.nodes.add(node);
    }

    public final void add(int index, T node) {
        if (node != null) {
            this.nodes.add(index, node);
        }
    }

    public void clearRemovedList() {
        this.removedNodes.clear();
    }

    public Collection<T> getRemovedNodes() {
        return this.removedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(T node) {
        if (node != null) {
            ProductNodeList productNodeList = this;
            synchronized (productNodeList) {
                block5: {
                    if (!this.nodes.remove(node)) break block5;
                    this.removedNodes.add(node);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAll() {
        ProductNodeList productNodeList = this;
        synchronized (productNodeList) {
            this.removedNodes.addAll(this.nodes);
            this.nodes.clear();
        }
    }

    public final void dispose() {
        int i = 0;
        while (i < this.size()) {
            ((ProductNode)this.getAt(i)).dispose();
            ++i;
        }
        this.removeAll();
        this.disposeRemovedList();
    }

    public ProductNodeList<T> createSubset(ProductNodeFilter<T> filter) {
        ProductNodeList<T> list = new ProductNodeList<T>();
        int i = 0;
        while (i < this.size()) {
            T node = this.getAt(i);
            if (filter.accept(node)) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    public final ProductNode[] toArray() {
        return this.nodes.toArray(new ProductNode[this.nodes.size()]);
    }

    public final T[] toArray(T[] array) {
        return (ProductNode[])this.nodes.toArray(array);
    }

    public final void copyInto(T[] array) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T node = TArray[n2];
            this.add(node);
            ++n2;
        }
    }

    public final int indexOf(String name) {
        Guardian.assertNotNull("name", name);
        int n = this.size();
        int i = 0;
        while (i < n) {
            if (((ProductNode)this.getAt(i)).getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int indexOf(T node) {
        Guardian.assertNotNull("node", node);
        return this.nodes.indexOf(node);
    }

    private void disposeRemovedList() {
        for (ProductNode removedNode : this.removedNodes) {
            removedNode.dispose();
        }
        this.clearRemovedList();
    }
}

