/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.AbstractGeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.util.Debug;
import org.geotools.factory.Hints;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.CRSUtilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public class CrsGeoCoding
extends AbstractGeoCoding {
    private final Rectangle imageBounds;
    private final AffineTransform imageToMap;
    private final MathTransform imageToGeo;
    private final MathTransform geoToImage;
    private final Datum datum;
    private final boolean crossingMeridianAt180;

    public CrsGeoCoding(CoordinateReferenceSystem mapCRS, int imageWidth, int imageHeight, double easting, double northing, double pixelSizeX, double pixelSizeY) throws FactoryException, TransformException {
        this(mapCRS, imageWidth, imageHeight, easting, northing, pixelSizeX, pixelSizeY, 0.5, 0.5);
    }

    public CrsGeoCoding(CoordinateReferenceSystem mapCRS, int imageWidth, int imageHeight, double easting, double northing, double pixelSizeX, double pixelSizeY, double referencePixelX, double referencePixelY) throws FactoryException, TransformException {
        this(mapCRS, new Rectangle(imageWidth, imageHeight), CrsGeoCoding.createImageToMapTransform(easting, northing, pixelSizeX, pixelSizeY, referencePixelX, referencePixelY));
    }

    public CrsGeoCoding(CoordinateReferenceSystem mapCRS, Rectangle imageBounds, AffineTransform imageToMap) throws FactoryException, TransformException {
        this.imageBounds = imageBounds;
        this.imageToMap = imageToMap;
        this.setMapCRS(mapCRS);
        Ellipsoid gtEllipsoid = CRS.getEllipsoid(mapCRS);
        String ellipsoidName = gtEllipsoid.getName().getCode();
        org.esa.beam.framework.dataop.maptransf.Ellipsoid ellipsoid = new org.esa.beam.framework.dataop.maptransf.Ellipsoid(ellipsoidName, gtEllipsoid.getSemiMinorAxis(), gtEllipsoid.getSemiMajorAxis());
        org.opengis.referencing.datum.Datum gtDatum = CRSUtilities.getDatum(mapCRS);
        String datumName = gtDatum.getName().getCode();
        this.datum = new Datum(datumName, ellipsoid, 0.0, 0.0, 0.0);
        AffineTransform2D i2m = new AffineTransform2D(imageToMap);
        if (mapCRS instanceof DerivedCRS) {
            DerivedCRS derivedCRS = (DerivedCRS)mapCRS;
            CoordinateReferenceSystem baseCRS = derivedCRS.getBaseCRS();
            this.setGeoCRS(baseCRS);
        } else if (gtDatum instanceof GeodeticDatum) {
            this.setGeoCRS(new DefaultGeographicCRS((GeodeticDatum)gtDatum, DefaultEllipsoidalCS.GEODETIC_2D));
        } else {
            this.setGeoCRS(DefaultGeographicCRS.WGS84);
        }
        this.setImageCRS(CrsGeoCoding.createImageCRS(mapCRS, i2m.inverse()));
        MathTransform map2Geo = CRS.findMathTransform(mapCRS, this.getGeoCRS(), true);
        Hints hints = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
        CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
        MathTransformFactory mtFactory = factory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)factory).getMathTransformFactory() : ReferencingFactoryFinder.getMathTransformFactory(hints);
        this.imageToGeo = mtFactory.createConcatenatedTransform(i2m, map2Geo);
        this.geoToImage = this.imageToGeo.inverse();
        this.crossingMeridianAt180 = this.detect180MeridianCrossing();
    }

    @Override
    public MathTransform getImageToMapTransform() {
        return new AffineTransform2D(this.imageToMap);
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        AffineTransform destTransform = new AffineTransform(this.imageToMap);
        Rectangle destBounds = new Rectangle(destScene.getRasterWidth(), destScene.getRasterHeight());
        if (subsetDef != null) {
            Rectangle region = subsetDef.getRegion();
            double scaleX = subsetDef.getSubSamplingX();
            double scaleY = subsetDef.getSubSamplingY();
            if (region != null) {
                destTransform.translate(region.getX(), region.getY());
                destBounds.setRect(0.0, 0.0, region.getWidth() / scaleX, region.getHeight() / scaleY);
            }
            destTransform.scale(scaleX, scaleY);
        }
        try {
            destScene.setGeoCoding(new CrsGeoCoding(this.getMapCRS(), destBounds, destTransform));
        }
        catch (Exception e) {
            Debug.trace(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean canGetGeoPos() {
        return true;
    }

    @Override
    public boolean canGetPixelPos() {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Datum getDatum() {
        return this.datum;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        try {
            DirectPosition2D directPixelPos = new DirectPosition2D(pixelPos);
            DirectPosition directGeoPos = this.imageToGeo.transform(directPixelPos, null);
            geoPos.setLocation((float)directGeoPos.getOrdinate(1), (float)directGeoPos.getOrdinate(0));
        }
        catch (Exception exception) {
            geoPos.setInvalid();
        }
        return geoPos;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        try {
            DirectPosition2D directGeoPos = new DirectPosition2D(geoPos.getLon(), geoPos.getLat());
            DirectPosition directPixelPos = this.geoToImage.transform(directGeoPos, null);
            pixelPos.setLocation((float)directPixelPos.getOrdinate(0), (float)directPixelPos.getOrdinate(1));
        }
        catch (Exception exception) {
            pixelPos.setInvalid();
        }
        return pixelPos;
    }

    public final void getPixels(int x1, int y1, int w, int h, float[] latPixels, float[] lonPixels) {
        DirectPosition2D directPixPos = new DirectPosition2D();
        GeneralDirectPosition directGeoPos = new GeneralDirectPosition(0.0, 0.0);
        int x2 = x1 + w;
        int y2 = y1 + h;
        int pos = 0;
        int y = y1;
        while (y < y2) {
            double yp = (double)y + 0.5;
            int x = x1;
            while (x < x2) {
                try {
                    directPixPos.setLocation((double)x + 0.5, yp);
                    this.imageToGeo.transform(directPixPos, directGeoPos);
                    latPixels[pos] = (float)directGeoPos.getOrdinate(1);
                    lonPixels[pos] = (float)directGeoPos.getOrdinate(0);
                }
                catch (Exception exception) {
                    latPixels[pos] = Float.NaN;
                    lonPixels[pos] = Float.NaN;
                }
                ++pos;
                ++x;
            }
            ++y;
        }
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        return this.crossingMeridianAt180;
    }

    public String toString() {
        String s = super.toString();
        return String.valueOf(s) + "\n\n" + "Map CRS:\n" + this.getMapCRS().toString() + "\n" + "Image To Map:\n" + this.imageToMap.toString();
    }

    private boolean detect180MeridianCrossing() throws TransformException, FactoryException {
        Rectangle bounds = this.imageBounds;
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(bounds.getMinX() + 0.5, bounds.getMaxX() - 0.5, bounds.getMinY() + 0.5, bounds.getMaxY() - 0.5, this.getImageCRS());
        referencedEnvelope = referencedEnvelope.transform(this.getGeoCRS(), true);
        DirectPosition uc = referencedEnvelope.getUpperCorner();
        DirectPosition lc = referencedEnvelope.getLowerCorner();
        return uc.getOrdinate(0) > 180.0 || lc.getOrdinate(0) < -180.0;
    }

    private static AffineTransform createImageToMapTransform(double easting, double northing, double pixelSizeX, double pixelSizeY, double referencePixelX, double referencePixelY) {
        AffineTransform at = new AffineTransform();
        at.translate(easting, northing);
        at.scale(pixelSizeX, -pixelSizeY);
        at.translate(-referencePixelX, -referencePixelY);
        return at;
    }
}

